/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.sapdb;

import com.sap.sql.jdbc.basic.BasicDbPortingServices;
import com.sap.sql.jdbc.basic.DbPortingFactory;
import com.sap.sql.jdbc.basic.SQLExceptionAnalyzer;
import com.sap.sql.jdbc.sapdb.SapdbPortingServices;
import com.sap.sql.jdbc.sapdb.SapdbSQLExceptionAnalyzer;
import java.sql.Connection;
import java.sql.SQLException;

public class SapdbPortingFactory
implements DbPortingFactory {
    public boolean isJdbcDriverSupported(Connection connection) throws SQLException {
        if (!connection.getMetaData().getDriverName().equals("SAP DB")) {
            return false;
        }
        String myclass = connection.getClass().getPackage().getName();
        return myclass.equals("com.sap.dbtech.jdbc") || myclass.equals("com.sap.dbtech.jdbc.trace");
    }

    public Connection createPortedConnection(Connection connection) throws SQLException {
        return connection;
    }

    public BasicDbPortingServices createDbPortingServices(Connection connection) throws SQLException {
        return new SapdbPortingServices(connection);
    }

    public SQLExceptionAnalyzer createSQLExceptionAnalyzer(Connection connection) throws SQLException {
        return new SapdbSQLExceptionAnalyzer(connection);
    }
}

