/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.oracle;

import com.sap.sql.jdbc.basic.BasicJdbcObjectFactory;
import com.sap.sql.jdbc.basic.BasicResultSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class OracleResultSet
extends BasicResultSet {
    public OracleResultSet(BasicJdbcObjectFactory factory, Statement statement, ResultSet resultSet) throws SQLException {
        super(factory, statement, resultSet);
    }

    public byte getByte(int columnIndex) throws SQLException {
        long value = super.getLong(columnIndex);
        if (value < -128L || value > 127L) {
            throw new SQLException("Numeric value out of range for datatype byte: " + value, "22003");
        }
        return (byte)value;
    }

    public byte getByte(String columnName) throws SQLException {
        long value = super.getLong(columnName);
        if (value < -128L || value > 127L) {
            throw new SQLException("Numeric value out of range for datatype byte: " + value, "22003");
        }
        return (byte)value;
    }

    public short getShort(int columnIndex) throws SQLException {
        long value = super.getLong(columnIndex);
        if (value < -32768L || value > 32767L) {
            throw new SQLException("Numeric value out of range for datatype short: " + value, "22003");
        }
        return (short)value;
    }

    public short getShort(String columnName) throws SQLException {
        long value = super.getLong(columnName);
        if (value < -32768L || value > 32767L) {
            throw new SQLException("Numeric value out of range for datatype short: " + value, "22003");
        }
        return (short)value;
    }

    public int getInt(int columnIndex) throws SQLException {
        long value = super.getLong(columnIndex);
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw new SQLException("Numeric value out of range for datatype int: " + value, "22003");
        }
        return (int)value;
    }

    public int getInt(String columnName) throws SQLException {
        long value = super.getLong(columnName);
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw new SQLException("Numeric value out of range for datatype int: " + value, "22003");
        }
        return (int)value;
    }
}

