/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.oracle;

import com.sap.sql.jdbc.basic.BasicDbPortingServices;
import com.sap.sql.jdbc.basic.DbPortingFactory;
import com.sap.sql.jdbc.basic.SQLExceptionAnalyzer;
import com.sap.sql.jdbc.oracle.OracleConnection;
import com.sap.sql.jdbc.oracle.OraclePortingServices;
import com.sap.sql.jdbc.oracle.OracleSQLExceptionAnalyzer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

public class OraclePortingFactory
implements DbPortingFactory {
    public boolean isJdbcDriverSupported(Connection connection) throws SQLException {
        boolean jdbcDriverSupported = false;
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        if (connection.getClass().getPackage().getName().startsWith("oracle.jdbc")) {
            if (databaseMetaData.getDriverMajorVersion() > 9) {
                jdbcDriverSupported = true;
            } else if (databaseMetaData.getDriverMajorVersion() == 9 && databaseMetaData.getDriverMinorVersion() == 2 && !databaseMetaData.getDriverVersion().startsWith("9.2.0.1") && !databaseMetaData.getDriverVersion().startsWith("9.2.0.2")) {
                jdbcDriverSupported = true;
            }
        }
        return jdbcDriverSupported;
    }

    public Connection createPortedConnection(Connection connection) throws SQLException {
        return new OracleConnection(connection);
    }

    public BasicDbPortingServices createDbPortingServices(Connection connection) throws SQLException {
        return new OraclePortingServices(connection);
    }

    public SQLExceptionAnalyzer createSQLExceptionAnalyzer(Connection connection) throws SQLException {
        return new OracleSQLExceptionAnalyzer(connection);
    }
}

