/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.oracle;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class OracleBlob
implements Blob {
    private byte[] byteArray;

    OracleBlob(Blob aBlob) throws SQLException {
        if (null == aBlob) {
            throw new IllegalArgumentException("null blob");
        }
        InputStream input = aBlob.getBinaryStream();
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream byteWriter = new ByteArrayOutputStream();
        try {
            int len;
            while ((len = input.read(buffer)) > 0) {
                byteWriter.write(buffer, 0, len);
            }
        }
        catch (IOException ex) {
            throw new SQLException(ex.getMessage());
        }
        this.byteArray = byteWriter.toByteArray();
    }

    public long length() throws SQLException {
        return this.byteArray.length;
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos < 1L || pos > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("position (" + pos + ") out of range");
        }
        int startIndex = (int)pos - 1;
        byte[] copy = new byte[length];
        System.arraycopy(this.byteArray, startIndex, copy, 0, length);
        return copy;
    }

    public InputStream getBinaryStream() throws SQLException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.byteArray);
        return inputStream;
    }

    public long position(byte[] pattern, long start) throws SQLException {
        return 0L;
    }

    public long position(Blob pattern, long start) throws SQLException {
        return 0L;
    }
}

