/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.mss;

import com.sap.sql.jdbc.basic.SQLExceptionAnalyzer;
import java.sql.Connection;
import java.sql.SQLException;

public class MssSQLExceptionAnalyzer
extends SQLExceptionAnalyzer {
    public MssSQLExceptionAnalyzer(Connection con) {
        super(con);
    }

    public int getCategory(SQLException exception) {
        int category = 0;
        SQLException sex = exception;
        while (sex != null) {
            if (category != 9 && category != 8 && category != 6) {
                String state = exception.getSQLState();
                int errcode = exception.getErrorCode();
                boolean nxt = false;
                if (state.startsWith("00") || state.startsWith("01")) {
                    nxt = true;
                } else if (state.startsWith("23")) {
                    if (category <= 7 || category == 1) {
                        category = 1;
                    }
                    nxt = true;
                } else if (state.startsWith("08")) {
                    category = 9;
                    nxt = true;
                } else if (state.equals("22003")) {
                    if (category <= 7) {
                        category = 2;
                    }
                    nxt = true;
                }
                if (!nxt) {
                    switch (errcode) {
                        case 11: 
                        case 17: 
                        case 10005: 
                        case 10008: 
                        case 10018: 
                        case 10025: 
                        case 10027: {
                            category = 9;
                            break;
                        }
                        case 601: 
                        case 602: 
                        case 604: 
                        case 605: 
                        case 623: 
                        case 624: 
                        case 625: 
                        case 701: 
                        case 708: 
                        case 1105: 
                        case 8908: 
                        case 9002: {
                            category = 8;
                            break;
                        }
                        case 2601: 
                        case 2627: {
                            if (category > 7) break;
                            category = 1;
                            break;
                        }
                        case 207: {
                            if (category > 7 && category != 1) break;
                            category = 3;
                            break;
                        }
                        case 208: 
                        case 2706: {
                            if (category > 7 && category != 1 && category != 3) break;
                            category = 4;
                            break;
                        }
                        case 1913: 
                        case 2714: {
                            if (category > 7 && category != 1) break;
                            category = 5;
                            break;
                        }
                        case 1205: {
                            if (category > 7 && category != 1 && category != 5 && category != 4 && category != 3) break;
                            category = 6;
                            break;
                        }
                        default: {
                            if (category >= 7) break;
                            category = 7;
                        }
                    }
                }
            }
            sex = sex.getNextException();
        }
        return category;
    }
}

