/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.mss;

import com.sap.sql.jdbc.basic.BasicJdbcObjectFactory;
import com.sap.sql.jdbc.basic.BasicResultSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class MssInetResultSet
extends BasicResultSet {
    public MssInetResultSet(BasicJdbcObjectFactory aFactory, Statement stmt, ResultSet rs) throws SQLException {
        super(aFactory, stmt, rs);
    }

    public byte getByte(int columnIndex) throws SQLException {
        long lval = super.getLong(columnIndex);
        if (lval > 127L || lval < -128L) {
            throw new SQLException("numeric value (" + lval + ") out of range for Byte", "22003");
        }
        return (byte)lval;
    }

    public byte getByte(String columnName) throws SQLException {
        long lval = super.getLong(columnName);
        if (lval > 127L || lval < -128L) {
            throw new SQLException("numeric value (" + lval + ") out of range for Byte", "22003");
        }
        return (byte)lval;
    }

    public short getShort(int columnIndex) throws SQLException {
        long lval = super.getLong(columnIndex);
        if (lval > 32767L || lval < -32768L) {
            throw new SQLException("numeric value (" + lval + ") out of range for Short", "22003");
        }
        return (short)lval;
    }

    public short getShort(String columnName) throws SQLException {
        long lval = super.getLong(columnName);
        if (lval > 32767L || lval < -32768L) {
            throw new SQLException("numeric value (" + lval + ") out of range for Short", "22003");
        }
        return (short)lval;
    }

    public int getInt(int columnIndex) throws SQLException {
        long lval = super.getLong(columnIndex);
        if (lval > Integer.MAX_VALUE || lval < Integer.MIN_VALUE) {
            throw new SQLException("numeric value (" + lval + ") out of range for Integer", "22003");
        }
        return (int)lval;
    }

    public int getInt(String columnName) throws SQLException {
        long lval = super.getLong(columnName);
        if (lval > Integer.MAX_VALUE || lval < Integer.MIN_VALUE) {
            throw new SQLException("numeric value (" + lval + ") out of range for Integer", "22003");
        }
        return (int)lval;
    }
}

