/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.mss;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.Clob;
import java.sql.SQLException;

public class MssClob
implements Clob {
    private String clobBuffer;

    MssClob(Reader reader) throws SQLException {
        if (null == reader) {
            throw new IllegalArgumentException("null clob");
        }
        StringWriter stringWriter = new StringWriter();
        char[] buffer = new char[4096];
        try {
            int len;
            while ((len = reader.read(buffer)) > 0) {
                stringWriter.write(buffer, 0, len);
            }
        }
        catch (IOException ex) {
            throw new SQLException(ex.getMessage());
        }
        this.clobBuffer = stringWriter.toString();
    }

    public long length() throws SQLException {
        return this.clobBuffer.length();
    }

    public String getSubString(long pos, int length) throws SQLException {
        if (pos < 1L || pos > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("position (" + pos + ") out of range");
        }
        int startIndex = (int)pos - 1;
        String subString = this.clobBuffer.substring(startIndex, startIndex + length);
        return subString;
    }

    public Reader getCharacterStream() throws SQLException {
        StringReader reader = new StringReader(this.clobBuffer);
        return reader;
    }

    public InputStream getAsciiStream() throws SQLException {
        return null;
    }

    public long position(String searchstr, long start) throws SQLException {
        return 0L;
    }

    public long position(Clob searchstr, long start) throws SQLException {
        return 0L;
    }
}

