/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.monitor.impl;

import com.sap.sql.jdbc.ConnectionContext;
import com.sap.sql.jdbc.DataSourceContext;
import com.sap.sql.jdbc.direct.DirectConnectionFactory;
import com.sap.sql.jdbc.direct.DirectStatement;
import com.sap.sql.jdbc.direct.PhysicalConnection;
import com.sap.sql.jdbc.monitor.ConnectionInfo;
import com.sap.sql.jdbc.monitor.ConnectionMonitor;
import com.sap.sql.jdbc.monitor.DataSourceInfo;
import com.sap.sql.jdbc.monitor.PooledStatementInfo;
import com.sap.sql.jdbc.monitor.StatementInfo;
import com.sap.sql.jdbc.monitor.StatementPoolInfo;
import com.sap.sql.jdbc.stmtpool.StatementPool;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ConnectionMonitorImpl
implements ConnectionMonitor {
    private static ConnectionMonitorImpl monitor = new ConnectionMonitorImpl();

    private ConnectionMonitorImpl() {
    }

    public static ConnectionMonitor getInstance() {
        return monitor;
    }

    public DataSourceInfo getDataSource(String dsName) {
        Map dsMap = DirectConnectionFactory.getOpenConnections();
        Collection connections = (Collection)dsMap.get(dsName);
        return connections != null ? this.createDataSourceInfo(dsName, connections) : null;
    }

    public Collection getDataSources() {
        Map dsMap = DirectConnectionFactory.getOpenConnections();
        ArrayList<DataSourceInfo> result = new ArrayList<DataSourceInfo>(dsMap.size());
        Iterator dsIter = dsMap.entrySet().iterator();
        while (dsIter.hasNext()) {
            Map.Entry entry = dsIter.next();
            result.add(this.createDataSourceInfo((String)entry.getKey(), (Collection)entry.getValue()));
        }
        return result;
    }

    public Collection getConnections() {
        Map dsMap = DirectConnectionFactory.getOpenConnections();
        ArrayList<ConnectionInfo> result = new ArrayList<ConnectionInfo>(dsMap.size() * 5);
        Iterator dsIter = dsMap.values().iterator();
        while (dsIter.hasNext()) {
            Collection connections = (Collection)dsIter.next();
            Iterator connIter = connections.iterator();
            while (connIter.hasNext()) {
                result.add(this.createConnectionInfo((PhysicalConnection)connIter.next()));
            }
        }
        return result;
    }

    public Collection getConnections(String dsName) {
        Map dsMap = DirectConnectionFactory.getOpenConnections();
        Collection connections = (Collection)dsMap.get(dsName);
        if (connections != null) {
            ArrayList<ConnectionInfo> result = new ArrayList<ConnectionInfo>(connections.size());
            Iterator connIter = connections.iterator();
            while (connIter.hasNext()) {
                result.add(this.createConnectionInfo((PhysicalConnection)connIter.next()));
            }
            return result;
        }
        return new ArrayList(0);
    }

    public Collection getPooledStatements(String dataSourceName, String connId) {
        PhysicalConnection physConn = this.findConnection(dataSourceName, connId);
        return physConn != null ? this.getPooledStatements(physConn) : null;
    }

    public Collection getOpenStatements(String dataSourceName, String connId) {
        PhysicalConnection physConn = this.findConnection(dataSourceName, connId);
        if (physConn != null) {
            Collection openStmts = physConn.getOpenStatements();
            ArrayList<StatementInfo> result = new ArrayList<StatementInfo>();
            if (!openStmts.isEmpty()) {
                Iterator iter = openStmts.iterator();
                while (iter.hasNext()) {
                    DirectStatement stmt = (DirectStatement)iter.next();
                    result.add(new StatementInfo(stmt.getSQL(), true, ConnectionMonitorImpl.getStatementType(stmt)));
                }
            }
            result.addAll(this.getPooledStatements(physConn));
            return result;
        }
        return null;
    }

    private static int getStatementType(Statement stmt) {
        if (stmt instanceof CallableStatement) {
            return 3;
        }
        if (stmt instanceof PreparedStatement) {
            return 2;
        }
        return 1;
    }

    private PhysicalConnection findConnection(String dsName, String connId) {
        Map dsMap = DirectConnectionFactory.getOpenConnections();
        Collection connections = (Collection)dsMap.get(dsName);
        if (connections != null) {
            Iterator iter = connections.iterator();
            while (iter.hasNext()) {
                PhysicalConnection physConn = (PhysicalConnection)iter.next();
                if (!connId.equals(physConn.toString())) continue;
                return physConn;
            }
        }
        return null;
    }

    private DataSourceInfo createDataSourceInfo(String dsName, Collection connections) {
        Iterator iter;
        String dbName = "";
        String serverName = "";
        String userName = "";
        String vendorName = "";
        int sqlType = 1;
        int connCnt = 0;
        if (connections != null && (iter = connections.iterator()).hasNext()) {
            PhysicalConnection physConn = (PhysicalConnection)iter.next();
            ConnectionContext connCtxt = physConn.getConnectionContext();
            DataSourceContext dsCtxt = connCtxt.getDataSourceContext();
            serverName = dsCtxt.getServerName();
            dbName = dsCtxt.getDatabaseName();
            vendorName = dsCtxt.getVendorName();
            sqlType = dsCtxt.getSqlType();
            userName = dsCtxt.getUserName();
            if (userName == null) {
                userName = connCtxt.getUserName();
            }
            connCnt = connections.size();
        }
        return new DataSourceInfo(dsName, dbName, serverName, userName, vendorName, sqlType, connCnt);
    }

    private ConnectionInfo createConnectionInfo(PhysicalConnection physConn) {
        String connId = physConn.toString();
        ConnectionContext connCtxt = physConn.getConnectionContext();
        StatementPool stmtPool = connCtxt.getStatementPool();
        StatementPoolInfo stmtPoolInfo = stmtPool == null ? null : new StatementPoolInfo(stmtPool.getCapacity(), stmtPool.getPooledStatementCount(), stmtPool.getUsedPooledStatementCount(), stmtPool.getRequests(), stmtPool.getHits(), stmtPool.getMaxHashBucketSize());
        return new ConnectionInfo(connId, connCtxt.getUserName(), connCtxt.getTransactionIsolation(), connCtxt.getAutoCommit(), physConn.getOpenStatements().size(), stmtPoolInfo);
    }

    private Collection getPooledStatements(PhysicalConnection physConn) {
        StatementPool stmtPool = physConn.getConnectionContext().getStatementPool();
        if (stmtPool != null) {
            Set statements = stmtPool.getPooledStatements();
            ArrayList<PooledStatementInfo> result = new ArrayList<PooledStatementInfo>(statements.size());
            Iterator iter = statements.iterator();
            while (iter.hasNext()) {
                StatementPool.PooledStatementInfo psInfo = (StatementPool.PooledStatementInfo)iter.next();
                result.add(new PooledStatementInfo(psInfo.getSQL(), psInfo.getHits(), psInfo.getHashValue(), psInfo.isUsed()));
            }
            return result;
        }
        return new ArrayList(0);
    }
}

