/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.direct;

import com.sap.sql.jdbc.direct.DirectConnection;
import com.sap.sql.jdbc.direct.DirectResultSetMetaData;
import com.sap.sql.jdbc.direct.DirectStatement;
import com.sap.sql.log.Syslog;
import com.sap.sql.trace.Id;
import com.sap.sql.trace.SQLTracable;
import com.sap.sql.trace.SQLTrace;
import com.sap.sql.trace.SQLTracer;
import com.sap.tc.logging.Location;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class DirectResultSet
implements ResultSet,
SQLTracable {
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$jdbc$direct$DirectResultSet == null ? (class$com$sap$sql$jdbc$direct$DirectResultSet = DirectResultSet.class$("com.sap.sql.jdbc.direct.DirectResultSet")) : class$com$sap$sql$jdbc$direct$DirectResultSet));
    private DirectConnection myConn;
    private DirectStatement myStatement;
    private ResultSet resultSet;
    private SQLTracer trc;
    private boolean isClosed = false;
    static /* synthetic */ Class class$com$sap$sql$jdbc$direct$DirectResultSet;

    DirectResultSet(DirectConnection connection, DirectStatement statement, ResultSet resultSet) throws SQLException {
        this.myConn = connection;
        this.myStatement = statement;
        this.resultSet = resultSet;
    }

    DirectResultSet(DirectConnection connection, ResultSet resultSet) throws SQLException {
        this.myConn = connection;
        this.resultSet = resultSet;
    }

    public boolean next() throws SQLException {
        boolean found = false;
        if (TRACE.bePath()) {
            TRACE.entering("next()");
        }
        try {
            this.validate();
            try {
                if (SQLTrace.isOn()) {
                    SQLTracer sqlTrace = this.getSQLTracer();
                    sqlTrace.startTimer();
                    found = this.resultSet.next();
                    sqlTrace.stopTimer();
                    sqlTrace.trace("next()", "next()", "" + found);
                } else {
                    found = this.resultSet.next();
                }
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "next()");
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE.bePath()) {
                TRACE.exiting((Object)new Boolean(found));
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting((Object)new Boolean(found));
        }
        return found;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws SQLException {
        block13: {
            block12: {
                if (TRACE.bePath()) {
                    TRACE.entering("close()");
                }
                try {
                    try {
                        if (this.isClosed) {
                            Object var3_1 = null;
                            if (!this.isClosed && this.myConn.getConnectionContext().getState() == 0) {
                                this.myConn = null;
                                this.myStatement = null;
                                this.resultSet = null;
                                this.trc = null;
                            }
                            this.isClosed = true;
                            break block12;
                        }
                        if (SQLTrace.isOn()) {
                            SQLTracer sqlTracer = this.getSQLTracer();
                            sqlTracer.startTimer();
                            this.resultSet.close();
                            sqlTracer.stopTimer();
                            sqlTracer.trace("close()");
                            break block13;
                        } else {
                            this.resultSet.close();
                        }
                        break block13;
                    }
                    catch (SQLException e) {
                        throw this.processSQLException(e, true, "close()");
                    }
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (!this.isClosed && this.myConn.getConnectionContext().getState() == 0) {
                        this.myConn = null;
                        this.myStatement = null;
                        this.resultSet = null;
                        this.trc = null;
                    }
                    this.isClosed = true;
                    if (!TRACE.bePath()) throw throwable;
                    TRACE.exiting();
                    throw throwable;
                }
            }
            if (!TRACE.bePath()) return;
            TRACE.exiting();
            return;
        }
        Object var3_2 = null;
        if (!this.isClosed && this.myConn.getConnectionContext().getState() == 0) {
            this.myConn = null;
            this.myStatement = null;
            this.resultSet = null;
            this.trc = null;
        }
        this.isClosed = true;
        if (!TRACE.bePath()) return;
        TRACE.exiting();
    }

    public boolean wasNull() throws SQLException {
        this.validate();
        return this.resultSet.wasNull();
    }

    public String getString(int columnIndex) throws SQLException {
        this.validate();
        return this.resultSet.getString(columnIndex);
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        this.validate();
        return this.resultSet.getBoolean(columnIndex);
    }

    public byte getByte(int columnIndex) throws SQLException {
        this.validate();
        return this.resultSet.getByte(columnIndex);
    }

    public short getShort(int columnIndex) throws SQLException {
        this.validate();
        return this.resultSet.getShort(columnIndex);
    }

    public int getInt(int columnIndex) throws SQLException {
        this.validate();
        return this.resultSet.getInt(columnIndex);
    }

    public long getLong(int columnIndex) throws SQLException {
        this.validate();
        return this.resultSet.getLong(columnIndex);
    }

    public float getFloat(int columnIndex) throws SQLException {
        this.validate();
        return this.resultSet.getFloat(columnIndex);
    }

    public double getDouble(int columnIndex) throws SQLException {
        this.validate();
        return this.resultSet.getDouble(columnIndex);
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.validate();
        return this.resultSet.getBigDecimal(columnIndex, scale);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        this.validate();
        return this.resultSet.getBytes(columnIndex);
    }

    public Date getDate(int columnIndex) throws SQLException {
        this.validate();
        return this.resultSet.getDate(columnIndex);
    }

    public Time getTime(int columnIndex) throws SQLException {
        this.validate();
        return this.resultSet.getTime(columnIndex);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.validate();
        return this.resultSet.getTimestamp(columnIndex);
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.validate();
        return this.resultSet.getAsciiStream(columnIndex);
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.validate();
        return this.resultSet.getUnicodeStream(columnIndex);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.validate();
        return this.resultSet.getBinaryStream(columnIndex);
    }

    public String getString(String columnName) throws SQLException {
        this.validate();
        return this.resultSet.getString(columnName);
    }

    public boolean getBoolean(String columnName) throws SQLException {
        this.validate();
        return this.resultSet.getBoolean(columnName);
    }

    public byte getByte(String columnName) throws SQLException {
        this.validate();
        return this.resultSet.getByte(columnName);
    }

    public short getShort(String columnName) throws SQLException {
        this.validate();
        return this.resultSet.getShort(columnName);
    }

    public int getInt(String columnName) throws SQLException {
        this.validate();
        return this.resultSet.getInt(columnName);
    }

    public long getLong(String columnName) throws SQLException {
        this.validate();
        return this.resultSet.getLong(columnName);
    }

    public float getFloat(String columnName) throws SQLException {
        this.validate();
        return this.resultSet.getFloat(columnName);
    }

    public double getDouble(String columnName) throws SQLException {
        this.validate();
        return this.resultSet.getDouble(columnName);
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        this.validate();
        return this.resultSet.getBigDecimal(columnName, scale);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        this.validate();
        return this.resultSet.getBytes(columnName);
    }

    public Date getDate(String columnName) throws SQLException {
        this.validate();
        return this.resultSet.getDate(columnName);
    }

    public Time getTime(String columnName) throws SQLException {
        this.validate();
        return this.resultSet.getTime(columnName);
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        this.validate();
        return this.resultSet.getTimestamp(columnName);
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        this.validate();
        return this.resultSet.getAsciiStream(columnName);
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        this.validate();
        return this.resultSet.getUnicodeStream(columnName);
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        this.validate();
        return this.resultSet.getBinaryStream(columnName);
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.isClosed) {
            return null;
        }
        return this.resultSet.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.resultSet.clearWarnings();
    }

    public String getCursorName() throws SQLException {
        this.validate();
        return this.resultSet.getCursorName();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.validate();
        ResultSetMetaData md = this.resultSet.getMetaData();
        return md == null ? null : new DirectResultSetMetaData(md);
    }

    public Object getObject(int columnIndex) throws SQLException {
        this.validate();
        return this.resultSet.getObject(columnIndex);
    }

    public Object getObject(String columnName) throws SQLException {
        this.validate();
        return this.resultSet.getObject(columnName);
    }

    public int findColumn(String columnName) throws SQLException {
        this.validate();
        return this.resultSet.findColumn(columnName);
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.validate();
        return this.resultSet.getCharacterStream(columnIndex);
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        this.validate();
        return this.resultSet.getCharacterStream(columnName);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.validate();
        return this.resultSet.getBigDecimal(columnIndex);
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        this.validate();
        return this.resultSet.getBigDecimal(columnName);
    }

    public boolean isBeforeFirst() throws SQLException {
        this.validate();
        return this.resultSet.isBeforeFirst();
    }

    public boolean isAfterLast() throws SQLException {
        this.validate();
        return this.resultSet.isAfterLast();
    }

    public boolean isFirst() throws SQLException {
        this.validate();
        return this.resultSet.isFirst();
    }

    public boolean isLast() throws SQLException {
        this.validate();
        return this.resultSet.isLast();
    }

    public void beforeFirst() throws SQLException {
        this.validate();
        this.resultSet.beforeFirst();
    }

    public void afterLast() throws SQLException {
        this.validate();
        this.resultSet.afterLast();
    }

    public boolean first() throws SQLException {
        boolean found = false;
        if (TRACE.bePath()) {
            TRACE.entering("first()");
        }
        try {
            this.validate();
            try {
                if (SQLTrace.isOn()) {
                    SQLTracer sqlTracer = this.getSQLTracer();
                    sqlTracer.startTimer();
                    found = this.resultSet.first();
                    sqlTracer.stopTimer();
                    sqlTracer.trace("first()", "first()", "" + found);
                } else {
                    found = this.resultSet.first();
                }
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "first()");
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE.bePath()) {
                TRACE.exiting((Object)new Boolean(found));
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting((Object)new Boolean(found));
        }
        return found;
    }

    public boolean last() throws SQLException {
        boolean found = false;
        if (TRACE.bePath()) {
            TRACE.entering("last()");
        }
        try {
            this.validate();
            try {
                if (SQLTrace.isOn()) {
                    SQLTracer sqlTracer = this.getSQLTracer();
                    sqlTracer.startTimer();
                    found = this.resultSet.last();
                    sqlTracer.stopTimer();
                    sqlTracer.trace("last()", "last()", "" + found);
                } else {
                    found = this.resultSet.last();
                }
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "last()");
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE.bePath()) {
                TRACE.exiting((Object)new Boolean(found));
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting((Object)new Boolean(found));
        }
        return found;
    }

    public int getRow() throws SQLException {
        this.validate();
        return this.resultSet.getRow();
    }

    public boolean absolute(int row) throws SQLException {
        boolean found = false;
        if (TRACE.bePath()) {
            TRACE.entering("absolute()");
        }
        try {
            this.validate();
            try {
                if (SQLTrace.isOn()) {
                    SQLTracer sqlTracer = this.getSQLTracer();
                    sqlTracer.startTimer();
                    found = this.resultSet.absolute(row);
                    sqlTracer.stopTimer();
                    sqlTracer.addInParam("" + row);
                    sqlTracer.trace("absolute()", "absolute()", "" + found);
                } else {
                    found = this.resultSet.absolute(row);
                }
            }
            catch (SQLException e) {
                throw this.processSQLException(e, found, "absolute()");
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE.bePath()) {
                TRACE.exiting((Object)new Boolean(found));
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting((Object)new Boolean(found));
        }
        return found;
    }

    public boolean relative(int rows) throws SQLException {
        boolean found = false;
        if (TRACE.bePath()) {
            TRACE.entering("relative()");
        }
        try {
            this.validate();
            try {
                if (SQLTrace.isOn()) {
                    SQLTracer sqlTracer = this.getSQLTracer();
                    sqlTracer.startTimer();
                    found = this.resultSet.relative(rows);
                    sqlTracer.stopTimer();
                    sqlTracer.addInParam("" + rows);
                    sqlTracer.trace("relative()", "relative()", "" + found);
                } else {
                    found = this.resultSet.relative(rows);
                }
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "relative()");
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE.bePath()) {
                TRACE.exiting((Object)new Boolean(found));
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting((Object)new Boolean(found));
        }
        return found;
    }

    public boolean previous() throws SQLException {
        boolean found = false;
        if (TRACE.bePath()) {
            TRACE.entering("previous()");
        }
        try {
            this.validate();
            try {
                if (SQLTrace.isOn()) {
                    SQLTracer sqlTracer = this.getSQLTracer();
                    sqlTracer.startTimer();
                    found = this.resultSet.previous();
                    sqlTracer.stopTimer();
                    sqlTracer.trace("previous()", "previous()", "" + found);
                } else {
                    found = this.resultSet.previous();
                }
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "previous()");
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE.bePath()) {
                TRACE.exiting((Object)new Boolean(found));
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting((Object)new Boolean(found));
        }
        return found;
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.validate();
        this.resultSet.setFetchDirection(direction);
    }

    public int getFetchDirection() throws SQLException {
        this.validate();
        return this.resultSet.getFetchDirection();
    }

    public void setFetchSize(int rows) throws SQLException {
        this.validate();
        this.resultSet.setFetchSize(rows);
    }

    public int getFetchSize() throws SQLException {
        this.validate();
        return this.resultSet.getFetchSize();
    }

    public int getType() throws SQLException {
        this.validate();
        return this.resultSet.getType();
    }

    public int getConcurrency() throws SQLException {
        this.validate();
        return this.resultSet.getConcurrency();
    }

    public boolean rowUpdated() throws SQLException {
        this.validate();
        return this.resultSet.rowUpdated();
    }

    public boolean rowInserted() throws SQLException {
        this.validate();
        return this.resultSet.rowInserted();
    }

    public boolean rowDeleted() throws SQLException {
        this.validate();
        return this.resultSet.rowDeleted();
    }

    public void updateNull(int columnIndex) throws SQLException {
        this.validate();
        this.resultSet.updateNull(columnIndex);
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.validate();
        this.resultSet.updateBoolean(columnIndex, x);
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.validate();
        this.resultSet.updateByte(columnIndex, x);
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        this.validate();
        this.resultSet.updateShort(columnIndex, x);
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        this.validate();
        this.resultSet.updateInt(columnIndex, x);
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        this.validate();
        this.resultSet.updateLong(columnIndex, x);
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.validate();
        this.resultSet.updateFloat(columnIndex, x);
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.validate();
        this.resultSet.updateDouble(columnIndex, x);
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.validate();
        this.resultSet.updateBigDecimal(columnIndex, x);
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        this.validate();
        this.resultSet.updateString(columnIndex, x);
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.validate();
        this.resultSet.updateBytes(columnIndex, x);
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.validate();
        this.resultSet.updateDate(columnIndex, x);
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.validate();
        this.resultSet.updateTime(columnIndex, x);
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.validate();
        this.resultSet.updateTimestamp(columnIndex, x);
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.validate();
        this.resultSet.updateAsciiStream(columnIndex, x, length);
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.validate();
        this.resultSet.updateBinaryStream(columnIndex, x, length);
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.validate();
        this.resultSet.updateCharacterStream(columnIndex, x, length);
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.validate();
        this.resultSet.updateObject(columnIndex, x, scale);
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.validate();
        this.resultSet.updateObject(columnIndex, x);
    }

    public void updateNull(String columnName) throws SQLException {
        this.validate();
        this.resultSet.updateNull(columnName);
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.validate();
        this.resultSet.updateBoolean(columnName, x);
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.validate();
        this.resultSet.updateByte(columnName, x);
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.validate();
        this.resultSet.updateShort(columnName, x);
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.validate();
        this.resultSet.updateInt(columnName, x);
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.validate();
        this.resultSet.updateLong(columnName, x);
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.validate();
        this.resultSet.updateFloat(columnName, x);
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.validate();
        this.resultSet.updateDouble(columnName, x);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.validate();
        this.resultSet.updateBigDecimal(columnName, x);
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.validate();
        this.resultSet.updateString(columnName, x);
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.validate();
        this.resultSet.updateBytes(columnName, x);
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.validate();
        this.resultSet.updateDate(columnName, x);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.validate();
        this.resultSet.updateTime(columnName, x);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.validate();
        this.resultSet.updateTimestamp(columnName, x);
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.validate();
        this.resultSet.updateAsciiStream(columnName, x, length);
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.validate();
        this.resultSet.updateBinaryStream(columnName, x, length);
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.validate();
        this.resultSet.updateCharacterStream(columnName, reader, length);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.validate();
        this.resultSet.updateObject(columnName, x, scale);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.validate();
        this.resultSet.updateObject(columnName, x);
    }

    public void insertRow() throws SQLException {
        this.validate();
        this.resultSet.insertRow();
    }

    public void updateRow() throws SQLException {
        this.validate();
        this.resultSet.updateRow();
    }

    public void deleteRow() throws SQLException {
        this.validate();
        this.resultSet.deleteRow();
    }

    public void refreshRow() throws SQLException {
        this.validate();
        this.resultSet.refreshRow();
    }

    public void cancelRowUpdates() throws SQLException {
        this.validate();
        this.resultSet.cancelRowUpdates();
    }

    public void moveToInsertRow() throws SQLException {
        this.validate();
        this.resultSet.moveToInsertRow();
    }

    public void moveToCurrentRow() throws SQLException {
        this.validate();
        this.resultSet.moveToCurrentRow();
    }

    public Statement getStatement() throws SQLException {
        this.validate();
        return this.myStatement;
    }

    public Object getObject(int i, Map map) throws SQLException {
        this.validate();
        return this.resultSet.getObject(i, map);
    }

    public Ref getRef(int i) throws SQLException {
        this.validate();
        return this.resultSet.getRef(i);
    }

    public Blob getBlob(int i) throws SQLException {
        this.validate();
        return this.resultSet.getBlob(i);
    }

    public Clob getClob(int i) throws SQLException {
        this.validate();
        return this.resultSet.getClob(i);
    }

    public Array getArray(int i) throws SQLException {
        this.validate();
        return this.resultSet.getArray(i);
    }

    public Object getObject(String colName, Map map) throws SQLException {
        this.validate();
        return this.resultSet.getObject(colName, map);
    }

    public Ref getRef(String colName) throws SQLException {
        this.validate();
        return this.resultSet.getRef(colName);
    }

    public Blob getBlob(String colName) throws SQLException {
        this.validate();
        return this.resultSet.getBlob(colName);
    }

    public Clob getClob(String colName) throws SQLException {
        this.validate();
        return this.resultSet.getClob(colName);
    }

    public Array getArray(String colName) throws SQLException {
        this.validate();
        return this.resultSet.getArray(colName);
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.validate();
        return this.resultSet.getDate(columnIndex, cal);
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        this.validate();
        return this.resultSet.getDate(columnName, cal);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.validate();
        return this.resultSet.getTime(columnIndex, cal);
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        this.validate();
        return this.resultSet.getTime(columnName, cal);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.validate();
        return this.resultSet.getTimestamp(columnIndex, cal);
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        this.validate();
        return this.resultSet.getTimestamp(columnName, cal);
    }

    public Id[] getIds() {
        return new Id[]{new Id(this, "rsid")};
    }

    public String getDbIdForTrace() {
        return this.myConn.getDbIdForTrace();
    }

    private void validate() throws SQLException {
        if (this.isClosed) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0017", new Object[]{this});
        }
    }

    private SQLException processSQLException(SQLException e, boolean trace, String methodName) {
        if (trace && SQLTrace.isOn()) {
            SQLTracer sqlTracer = this.getSQLTracer();
            sqlTracer.traceException(e, methodName, methodName);
        }
        String sql = this.myStatement != null ? this.myStatement.getSQL() : null;
        SQLException ex = Syslog.logSQLException(this, e, this.myConn.getConnectionContext().getConnectionID(), sql);
        this.myConn.analyzeSQLException(e);
        return ex;
    }

    private SQLTracer getSQLTracer() {
        if (this.trc == null) {
            this.trc = new SQLTracer(this);
            return this.trc;
        }
        return this.trc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

