/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.direct;

import com.sap.sql.jdbc.ConnectionContext;
import com.sap.sql.jdbc.ExtendedPreparedStatement;
import com.sap.sql.jdbc.direct.DirectConnection;
import com.sap.sql.jdbc.direct.DirectPooledStatement;
import com.sap.sql.jdbc.direct.DirectResultSet;
import com.sap.sql.jdbc.direct.DirectResultSetMetaData;
import com.sap.sql.jdbc.direct.DirectStatement;
import com.sap.sql.log.Syslog;
import com.sap.sql.services.core.CoreServices;
import com.sap.sql.trace.Id;
import com.sap.sql.trace.SQLTrace;
import com.sap.sql.trace.SQLTracer;
import com.sap.sql.trace.TraceContext;
import com.sap.sql.trace.Utils;
import com.sap.tc.logging.Location;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class DirectPreparedStatement
extends DirectStatement
implements ExtendedPreparedStatement {
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$jdbc$direct$DirectPreparedStatement == null ? (class$com$sap$sql$jdbc$direct$DirectPreparedStatement = DirectPreparedStatement.class$("com.sap.sql.jdbc.direct.DirectPreparedStatement")) : class$com$sap$sql$jdbc$direct$DirectPreparedStatement));
    private static final int MAX_BYTES = 32;
    protected int iSet = 0;
    protected boolean isFirstAddBatch = true;
    private PreparedStatement prepStmt = (PreparedStatement)this.stmt;
    private DirectPooledStatement pooledStmt = null;
    static /* synthetic */ Class class$com$sap$sql$jdbc$direct$DirectPreparedStatement;

    DirectPreparedStatement(DirectConnection dConn, PreparedStatement ps, String sql) {
        this(dConn, ps, sql, null);
    }

    DirectPreparedStatement(DirectConnection dConn, PreparedStatement ps, String sql, DirectPooledStatement pooledStmt) {
        super(dConn, ps);
        this.sql = sql;
        this.pooledStmt = pooledStmt;
    }

    public void addBatch() throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("addBatch");
        }
        try {
            this.validate();
            try {
                if (SQLTrace.isOn()) {
                    SQLTracer sqlTrace = this.getSQLTracer();
                    sqlTrace.startTimer();
                    this.prepStmt.addBatch();
                    sqlTrace.stopTimer();
                    sqlTrace.addAttribute("vars_per_batch", "" + this.iSet);
                    sqlTrace.trace("addBatch()", this.sql);
                } else {
                    this.prepStmt.addBatch();
                }
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "addBatch()", this.sql);
            }
            Object var3_3 = null;
            this.isFirstAddBatch = false;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.isFirstAddBatch = false;
            TRACE.exiting();
            throw throwable;
        }
        TRACE.exiting();
    }

    public void clearParameters() throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("clearParameters()");
        }
        try {
            this.validate();
            if (SQLTrace.isOn()) {
                SQLTracer sqlTrace = this.getSQLTracer();
                sqlTrace.clearBindParams();
            }
            if (this.isFirstAddBatch) {
                this.iSet = 0;
            }
            try {
                this.prepStmt.clearParameters();
            }
            catch (SQLException e) {
                throw this.processSQLException(e, false, this.sql);
            }
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public boolean execute() throws SQLException {
        return this.execute((TraceContext)null);
    }

    public boolean execute(TraceContext traceContext) throws SQLException {
        boolean success = false;
        if (TRACE.bePath()) {
            TRACE.entering("execute()");
        }
        try {
            this.validate();
            try {
                this.closeResultSet();
                if (SQLTrace.isOn()) {
                    SQLTracer sqlTrace = this.getSQLTracer();
                    sqlTrace.startTimer();
                    success = this.prepStmt.execute();
                    sqlTrace.stopTimer();
                    sqlTrace.setTraceContext(traceContext);
                    sqlTrace.trace("execute()", this.sql, "" + success);
                } else {
                    success = this.prepStmt.execute();
                }
            }
            catch (SQLException e) {
                throw this.processSQLException(e, "execute()", this.sql, traceContext);
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE.bePath()) {
                TRACE.exiting((Object)new Boolean(success));
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting((Object)new Boolean(success));
        }
        return success;
    }

    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery((TraceContext)null);
    }

    public ResultSet executeQuery(TraceContext traceContext) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("executeQuery()");
        }
        try {
            this.validate();
            try {
                this.closeResultSet();
                if (SQLTrace.isOn()) {
                    SQLTracer sqlTrace = this.getSQLTracer();
                    sqlTrace.startTimer();
                    this.resultSet = new DirectResultSet(this.dConn, this, this.prepStmt.executeQuery());
                    sqlTrace.stopTimer();
                    sqlTrace.setId(this.resultSet, "rsid");
                    sqlTrace.setTraceContext(traceContext);
                    sqlTrace.trace("executeQuery()", this.sql);
                } else {
                    this.resultSet = new DirectResultSet(this.dConn, this, this.prepStmt.executeQuery());
                }
            }
            catch (SQLException e) {
                throw this.processSQLException(e, "executeQuery()", this.sql, traceContext);
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE.bePath()) {
                TRACE.exiting((Object)this.resultSet);
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting((Object)this.resultSet);
        }
        return this.resultSet;
    }

    public int executeUpdate() throws SQLException {
        return this.executeUpdate((TraceContext)null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(TraceContext traceContext) throws SQLException {
        int rowCount;
        block7: {
            int n;
            block6: {
                rowCount = 0;
                if (TRACE.bePath()) {
                    TRACE.entering("executeUpdate()");
                }
                try {
                    this.validate();
                    try {
                        this.closeResultSet();
                        if (SQLTrace.isOn()) {
                            SQLTracer sqlTrace = this.getSQLTracer();
                            sqlTrace.startTimer();
                            rowCount = this.prepStmt.executeUpdate();
                            sqlTrace.stopTimer();
                            sqlTrace.setTraceContext(traceContext);
                            sqlTrace.trace("executeUpdate()", this.sql, "" + rowCount);
                            n = rowCount;
                            Object var6_6 = null;
                            break block6;
                        }
                        rowCount = this.prepStmt.executeUpdate();
                        break block7;
                    }
                    catch (SQLException e) {
                        throw this.processSQLException(e, "executeUpdate()", this.sql, traceContext);
                    }
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (!TRACE.bePath()) throw throwable;
                    TRACE.exiting((Object)new Integer(rowCount));
                    throw throwable;
                }
            }
            if (!TRACE.bePath()) return n;
            TRACE.exiting((Object)new Integer(rowCount));
            return n;
        }
        Object var6_7 = null;
        if (!TRACE.bePath()) return rowCount;
        TRACE.exiting((Object)new Integer(rowCount));
        return rowCount;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.validate();
        try {
            ResultSetMetaData md = this.prepStmt.getMetaData();
            return md == null ? null : new DirectResultSetMetaData(md);
        }
        catch (SQLException e) {
            throw this.processSQLException(e);
        }
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setNull(" + parameterIndex + "," + sqlType + ")");
        }
        try {
            this.validate();
            if (this.isFirstAddBatch) {
                ++this.iSet;
            }
            if (SQLTrace.isOn()) {
                this.addParamToSQLTrace(parameterIndex, "setNull(" + parameterIndex + "," + sqlType + ")");
            }
            try {
                this.prepStmt.setNull(parameterIndex, sqlType);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setNull(" + parameterIndex + "," + sqlType + ")", this.sql);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setBoolean(" + parameterIndex + "," + x + ")");
        }
        try {
            this.validate();
            if (this.isFirstAddBatch) {
                ++this.iSet;
            }
            if (SQLTrace.isOn()) {
                this.addParamToSQLTrace(parameterIndex, "" + x);
            }
            try {
                this.prepStmt.setBoolean(parameterIndex, x);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setBoolean(" + parameterIndex + "," + x + ")", this.sql);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setByte(" + parameterIndex + "," + x + ")");
        }
        try {
            this.validate();
            if (this.isFirstAddBatch) {
                ++this.iSet;
            }
            if (SQLTrace.isOn()) {
                this.addParamToSQLTrace(parameterIndex, "" + x);
            }
            try {
                this.prepStmt.setByte(parameterIndex, x);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setByte(" + parameterIndex + "," + x + ")", this.sql);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setShort(" + parameterIndex + "," + x + ")");
        }
        try {
            this.validate();
            if (this.isFirstAddBatch) {
                ++this.iSet;
            }
            if (SQLTrace.isOn()) {
                this.addParamToSQLTrace(parameterIndex, "" + x);
            }
            try {
                this.prepStmt.setShort(parameterIndex, x);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setShort(" + parameterIndex + "," + x + ")", this.sql);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setInt(" + parameterIndex + "," + x + ")");
        }
        try {
            this.validate();
            if (this.isFirstAddBatch) {
                ++this.iSet;
            }
            if (SQLTrace.isOn()) {
                this.addParamToSQLTrace(parameterIndex, "" + x);
            }
            try {
                this.prepStmt.setInt(parameterIndex, x);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setInt(" + parameterIndex + "," + x + ")", this.sql);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setLong(" + parameterIndex + "," + x + ")");
        }
        try {
            this.validate();
            if (this.isFirstAddBatch) {
                ++this.iSet;
            }
            if (SQLTrace.isOn()) {
                this.addParamToSQLTrace(parameterIndex, "" + x);
            }
            try {
                this.prepStmt.setLong(parameterIndex, x);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setLong(" + parameterIndex + "," + x + ")", this.sql);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setFloat(" + parameterIndex + "," + x + ")");
        }
        try {
            this.validate();
            if (this.isFirstAddBatch) {
                ++this.iSet;
            }
            if (SQLTrace.isOn()) {
                this.addParamToSQLTrace(parameterIndex, "" + x);
            }
            try {
                this.prepStmt.setFloat(parameterIndex, x);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setFloat(" + parameterIndex + "," + x + ")", this.sql);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setDouble(" + parameterIndex + "," + x + ")");
        }
        try {
            this.validate();
            if (this.isFirstAddBatch) {
                ++this.iSet;
            }
            if (SQLTrace.isOn()) {
                this.addParamToSQLTrace(parameterIndex, "" + x);
            }
            try {
                this.prepStmt.setDouble(parameterIndex, x);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setDouble(" + parameterIndex + "," + x + ")", this.sql);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setBigDecimal(" + parameterIndex + "," + x.toString() + ")");
        }
        try {
            this.validate();
            if (this.isFirstAddBatch) {
                ++this.iSet;
            }
            if (SQLTrace.isOn()) {
                this.addParamToSQLTrace(parameterIndex, "" + x);
            }
            try {
                this.prepStmt.setBigDecimal(parameterIndex, x);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setBigDecimal(" + parameterIndex + "," + x.toString() + ")", this.sql);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setString(" + parameterIndex + "," + x + ")");
        }
        try {
            this.validate();
            if (this.isFirstAddBatch) {
                ++this.iSet;
            }
            if (SQLTrace.isOn()) {
                this.addParamToSQLTrace(parameterIndex, "" + x);
            }
            try {
                this.prepStmt.setString(parameterIndex, x);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setString(" + parameterIndex + "," + x + ")", this.sql);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setBytes(" + parameterIndex + "," + x + ")");
        }
        try {
            this.validate();
            if (this.isFirstAddBatch) {
                ++this.iSet;
            }
            if (SQLTrace.isOn()) {
                this.addParamToSQLTrace(parameterIndex, Utils.ByteArrayToHexString(x, 32));
            }
            try {
                this.prepStmt.setBytes(parameterIndex, x);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setBytes(" + parameterIndex + "," + Utils.ByteArrayToHexString(x, 32) + ")", this.sql);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setDate(" + parameterIndex + "," + x + ")");
        }
        try {
            this.validate();
            if (this.isFirstAddBatch) {
                ++this.iSet;
            }
            if (SQLTrace.isOn()) {
                this.addParamToSQLTrace(parameterIndex, "" + x);
            }
            try {
                this.prepStmt.setDate(parameterIndex, x);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setDate(" + parameterIndex + "," + x + ")", this.sql);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setTime(" + parameterIndex + "," + x + ")");
        }
        try {
            try {
                this.validate();
                if (this.isFirstAddBatch) {
                    ++this.iSet;
                }
                if (SQLTrace.isOn()) {
                    this.addParamToSQLTrace(parameterIndex, "" + x);
                }
                this.prepStmt.setTime(parameterIndex, x);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setTime(" + parameterIndex + "," + x + ")", this.sql);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (!TRACE.bePath()) throw throwable;
            TRACE.exiting();
            throw throwable;
        }
        if (!TRACE.bePath()) return;
        TRACE.exiting();
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setTimestamp(" + parameterIndex + "," + x + ")");
        }
        try {
            this.validate();
            if (this.isFirstAddBatch) {
                ++this.iSet;
            }
            if (SQLTrace.isOn()) {
                this.addParamToSQLTrace(parameterIndex, "" + x);
            }
            try {
                this.prepStmt.setTimestamp(parameterIndex, x);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setTimeStamp(" + parameterIndex + "," + x + ")", this.sql);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setAsciiStream(" + parameterIndex + "," + x + "," + length + ")");
        }
        try {
            this.validate();
            if (this.isFirstAddBatch) {
                ++this.iSet;
            }
            if (SQLTrace.isOn()) {
                this.addParamToSQLTrace(parameterIndex, "" + x);
            }
            try {
                this.prepStmt.setAsciiStream(parameterIndex, x, length);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setAsciiStream(" + parameterIndex + "," + x + ")", this.sql);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setUnicodeStream(" + parameterIndex + "," + x + "," + length + ")");
        }
        try {
            this.validate();
            if (this.isFirstAddBatch) {
                ++this.iSet;
            }
            if (SQLTrace.isOn()) {
                this.addParamToSQLTrace(parameterIndex, "" + x);
            }
            try {
                this.prepStmt.setUnicodeStream(parameterIndex, x, length);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setUnicodeStream(" + parameterIndex + "," + x + ")", this.sql);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setBinaryStream(" + parameterIndex + "," + x + "," + length + ")");
        }
        try {
            this.validate();
            if (this.isFirstAddBatch) {
                ++this.iSet;
            }
            if (SQLTrace.isOn()) {
                this.addParamToSQLTrace(parameterIndex, "" + x);
            }
            try {
                this.prepStmt.setBinaryStream(parameterIndex, x, length);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setBinaryStream(" + parameterIndex + "," + x + ")", this.sql);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setObject(int, Object, int, int)");
        }
        try {
            this.validate();
            if (this.isFirstAddBatch) {
                ++this.iSet;
            }
            if (SQLTrace.isOn()) {
                this.addParamToSQLTrace(parameterIndex, "" + x);
            }
            try {
                this.prepStmt.setObject(parameterIndex, x, targetSqlType, scale);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setObject( int, Object, int, int)", this.sql);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setObject(int, Object, int)");
        }
        try {
            this.validate();
            if (this.isFirstAddBatch) {
                ++this.iSet;
            }
            if (SQLTrace.isOn()) {
                this.addParamToSQLTrace(parameterIndex, "" + x);
            }
            try {
                this.prepStmt.setObject(parameterIndex, x, targetSqlType);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setObject( int, Object, int )", this.sql);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setObject(int, Object)");
        }
        try {
            this.validate();
            if (this.isFirstAddBatch) {
                ++this.iSet;
            }
            if (SQLTrace.isOn()) {
                this.addParamToSQLTrace(parameterIndex, "" + x);
            }
            try {
                this.prepStmt.setObject(parameterIndex, x);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setObject( int, object )", this.sql);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setCharacterStream(int, Reader, int)");
        }
        try {
            this.validate();
            if (this.isFirstAddBatch) {
                ++this.iSet;
            }
            if (SQLTrace.isOn()) {
                this.addParamToSQLTrace(parameterIndex, "" + reader);
            }
            try {
                this.prepStmt.setCharacterStream(parameterIndex, reader, length);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setCharacterStream( int, Reader, int )", this.sql);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void setRef(int parameterIndex, Ref x) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setRef(int, Ref)");
        }
        try {
            this.validate();
            if (this.isFirstAddBatch) {
                ++this.iSet;
            }
            if (SQLTrace.isOn()) {
                this.addParamToSQLTrace(parameterIndex, "" + x);
            }
            try {
                this.prepStmt.setRef(parameterIndex, x);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setRef( int, Ref )", this.sql);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setBlob(int, Blob)");
        }
        try {
            this.validate();
            if (this.isFirstAddBatch) {
                ++this.iSet;
            }
            if (SQLTrace.isOn()) {
                this.addParamToSQLTrace(parameterIndex, "" + x);
            }
            try {
                this.prepStmt.setBlob(parameterIndex, x);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setBlob( int, Blob )", this.sql);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void setClob(int parameterIndex, Clob x) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setClob(int, Clob)");
        }
        try {
            this.validate();
            if (this.isFirstAddBatch) {
                ++this.iSet;
            }
            if (SQLTrace.isOn()) {
                this.addParamToSQLTrace(parameterIndex, "" + x);
            }
            try {
                this.prepStmt.setClob(parameterIndex, x);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setClob( int, Ref )", this.sql);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void setArray(int parameterIndex, Array x) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setArray(int, Blob)");
        }
        try {
            this.validate();
            if (this.isFirstAddBatch) {
                ++this.iSet;
            }
            if (SQLTrace.isOn()) {
                this.addParamToSQLTrace(parameterIndex, "" + x);
            }
            try {
                this.prepStmt.setArray(parameterIndex, x);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setArray( int, Ref )", this.sql);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setdate(int, Date, Calendar)");
        }
        try {
            this.validate();
            if (this.isFirstAddBatch) {
                ++this.iSet;
            }
            try {
                if (SQLTrace.isOn()) {
                    this.addParamToSQLTrace(parameterIndex, "" + x);
                }
                this.prepStmt.setDate(parameterIndex, x, cal);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setDate( int, Date, Calendar )", this.sql);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setTime(int, Time, Calendar)");
        }
        try {
            this.validate();
            if (this.isFirstAddBatch) {
                ++this.iSet;
            }
            try {
                if (SQLTrace.isOn()) {
                    this.addParamToSQLTrace(parameterIndex, "" + x);
                }
                this.prepStmt.setTime(parameterIndex, x, cal);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setTime( int, Time, Calendar )", this.sql);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setTimestamp(int, Timestamp, Calendar)");
        }
        try {
            this.validate();
            if (this.isFirstAddBatch) {
                ++this.iSet;
            }
            try {
                if (SQLTrace.isOn()) {
                    this.addParamToSQLTrace(parameterIndex, "" + x);
                }
                this.prepStmt.setTimestamp(parameterIndex, x, cal);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setTimestamp( int, Timestamp, Calendar )", this.sql);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setNull(int, int, String)");
        }
        try {
            this.validate();
            if (this.isFirstAddBatch) {
                ++this.iSet;
            }
            if (SQLTrace.isOn()) {
                this.addParamToSQLTrace(parameterIndex, "setNull(int, int, String)");
            }
            try {
                this.prepStmt.setNull(parameterIndex, sqlType, typeName);
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setNull( int, int, String )", this.sql);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void clearBatch() throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("clearBatch()");
        }
        try {
            this.validate();
            try {
                if (SQLTrace.isOn()) {
                    SQLTracer sqlTrace = this.getSQLTracer();
                    sqlTrace.clearBindParams();
                    sqlTrace.startTimer();
                    this.prepStmt.clearBatch();
                    sqlTrace.stopTimer();
                    sqlTrace.trace("clearBatch()");
                } else {
                    this.prepStmt.clearBatch();
                }
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "clearBatch()", this.sql);
            }
            Object var3_3 = null;
            this.iSet = 0;
            this.isFirstAddBatch = true;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.iSet = 0;
            this.isFirstAddBatch = true;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void close() throws SQLException {
        this.close(true);
    }

    public int[] executeBatch() throws SQLException {
        return this.executeBatch(null);
    }

    public int[] executeBatch(TraceContext traceContext) throws SQLException {
        int[] updateCounts = null;
        if (TRACE.bePath()) {
            TRACE.entering("executeBatch()");
        }
        try {
            this.validate();
            try {
                this.closeResultSet();
                if (SQLTrace.isOn()) {
                    SQLTracer sqlTrace = this.getSQLTracer();
                    sqlTrace.startTimer();
                    updateCounts = this.prepStmt.executeBatch();
                    sqlTrace.stopTimer();
                    StringBuffer sb = new StringBuffer();
                    if (updateCounts != null) {
                        int index = 0;
                        while (index < updateCounts.length) {
                            sb.append(updateCounts[index] + " ");
                            ++index;
                        }
                    } else {
                        sb.append("null");
                    }
                    sqlTrace.setTraceContext(traceContext);
                    sqlTrace.trace("executeBatch()", this.sql, sb.toString());
                } else {
                    updateCounts = this.prepStmt.executeBatch();
                }
            }
            catch (SQLException e) {
                throw this.processSQLException(e, "executeBatch()", this.sql, traceContext);
            }
            Object var7_7 = null;
            this.iSet = 0;
            this.isFirstAddBatch = true;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.iSet = 0;
            this.isFirstAddBatch = true;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
        return updateCounts;
    }

    public Id[] getIds() {
        return new Id[]{new Id(this, "pstmtid"), new Id(this.stmt, "physstmtid")};
    }

    protected SQLException processSQLException(SQLException e, String methodName, String sql, TraceContext context) {
        if (SQLTrace.isOn()) {
            SQLTracer sqlTrace = this.getSQLTracer();
            sqlTrace.traceException(e, methodName, sql, context);
        }
        ConnectionContext ctx = this.dConn.getConnectionContext();
        SQLException ex = e;
        if (!CoreServices.isDuplicateKeyException(ctx, e)) {
            ex = Syslog.logSQLException(this, e, ctx.getConnectionID(), sql);
        }
        this.dConn.analyzeSQLException(e);
        return ex;
    }

    protected void addParamToSQLTrace(int index, String param) {
        if (SQLTrace.isOn()) {
            SQLTracer sqlTrace = this.getSQLTracer();
            sqlTrace.addBindParam(index, param);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void close(boolean notify) throws SQLException {
        block14: {
            block13: {
                String methodName = "close()";
                if (TRACE.bePath()) {
                    TRACE.entering("close()");
                }
                try {
                    if (this.isClosed) {
                        Object var5_3 = null;
                        if (!this.isClosed && this.dConn.getConnectionContext().getState() == 0) {
                            this.invalidate();
                            this.pooledStmt = null;
                            this.prepStmt = null;
                        }
                        this.isClosed = true;
                        break block13;
                    }
                    if (notify) {
                        this.dConn.statementClosed(this);
                    }
                    this.closeResultSet();
                    if (this.pooledStmt != null) {
                        this.pooledStmt.statementClosed();
                        break block14;
                    }
                    try {
                        if (SQLTrace.isOn()) {
                            SQLTracer sqlTrace = this.getSQLTracer();
                            sqlTrace.startTimer();
                            this.stmt.close();
                            sqlTrace.stopTimer();
                            sqlTrace.trace("close()", this.sql);
                            break block14;
                        } else {
                            this.stmt.close();
                        }
                        break block14;
                    }
                    catch (SQLException e) {
                        throw this.processSQLException(e, true, "close()", this.sql);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (!this.isClosed && this.dConn.getConnectionContext().getState() == 0) {
                        this.invalidate();
                        this.pooledStmt = null;
                        this.prepStmt = null;
                    }
                    this.isClosed = true;
                    if (!TRACE.bePath()) throw throwable;
                    TRACE.exiting();
                    throw throwable;
                }
            }
            if (!TRACE.bePath()) return;
            TRACE.exiting();
            return;
        }
        Object var5_4 = null;
        if (!this.isClosed && this.dConn.getConnectionContext().getState() == 0) {
            this.invalidate();
            this.pooledStmt = null;
            this.prepStmt = null;
        }
        this.isClosed = true;
        if (!TRACE.bePath()) return;
        TRACE.exiting();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

