/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.direct;

import com.sap.sql.jdbc.ConnectionWrapper;
import com.sap.sql.jdbc.direct.DirectConnection;
import com.sap.sql.jdbc.direct.DirectPooledConnection;
import com.sap.sql.jdbc.direct.DirectPreparedStatement;
import com.sap.sql.jdbc.direct.PhysicalConnection;
import com.sap.sql.jdbc.stmtpool.PooledStatement;
import com.sap.sql.jdbc.stmtpool.StatementEventListener;
import com.sap.sql.log.Syslog;
import com.sap.sql.trace.Id;
import com.sap.sql.trace.SQLTracable;
import com.sap.sql.trace.SQLTrace;
import com.sap.sql.trace.SQLTracer;
import com.sap.tc.logging.Location;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.ArrayList;

public class DirectPooledStatement
implements PooledStatement,
SQLTracable {
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$jdbc$direct$DirectPooledStatement == null ? (class$com$sap$sql$jdbc$direct$DirectPooledStatement = DirectPooledStatement.class$("com.sap.sql.jdbc.direct.DirectPooledStatement")) : class$com$sap$sql$jdbc$direct$DirectPooledStatement));
    private final PhysicalConnection pConn;
    private final PreparedStatement prepStmt;
    private final String sql;
    private final int resultSetType;
    private final int resultSetConcurrency;
    private final int transactionIsolation;
    private boolean isPooled = false;
    private ArrayList listeners = new ArrayList(1);
    private SQLTracer trc = null;
    static /* synthetic */ Class class$com$sap$sql$jdbc$direct$DirectPooledStatement;

    DirectPooledStatement(PhysicalConnection pConn, PreparedStatement prepStmt, String sql) {
        this(pConn, prepStmt, sql, 1003, 1007);
    }

    DirectPooledStatement(PhysicalConnection pConn, PreparedStatement prepStmt, String sql, int resultSetType, int resultSetConcurrency) {
        this.pConn = pConn;
        this.prepStmt = prepStmt;
        this.sql = sql;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.transactionIsolation = pConn.getConnectionContext().getTransactionIsolation();
    }

    public PreparedStatement getPreparedStatement() {
        DirectPreparedStatement ps = null;
        if (TRACE.bePath()) {
            TRACE.entering("getPreparedStatement()");
        }
        ps = new DirectPreparedStatement(this.pConn instanceof DirectPooledConnection ? ((DirectPooledConnection)this.pConn).getDirectConnection() : (DirectConnection)this.pConn, this.prepStmt, this.sql, this);
        if (TRACE.bePath()) {
            TRACE.exiting((Object)ps);
        }
        return ps;
    }

    public String getSql() {
        return this.sql;
    }

    public void clear() throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("clear()");
        }
        try {
            this.prepStmt.clearParameters();
            this.prepStmt.clearBatch();
            this.prepStmt.clearWarnings();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("close()");
        }
        try {
            try {
                if (SQLTrace.isOn()) {
                    SQLTracer sqlTrace = this.getSQLTracer();
                    sqlTrace.startTimer();
                    this.prepStmt.close();
                    sqlTrace.stopTimer();
                    sqlTrace.trace("close()", this.sql);
                }
                this.prepStmt.close();
            }
            catch (SQLException e) {
                throw this.processSQLException("close()", e);
            }
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (!TRACE.bePath()) throw throwable;
            TRACE.exiting();
            throw throwable;
        }
        if (!TRACE.bePath()) return;
        TRACE.exiting();
    }

    public boolean match(String sql, int resultSetType, int resultSetConcurrency) {
        return this.resultSetType == resultSetType && this.resultSetConcurrency == resultSetConcurrency && this.transactionIsolation == this.pConn.getConnectionContext().getTransactionIsolation() && this.sql.equals(sql);
    }

    public void addStatementEventListener(StatementEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeStatementEventListener(StatementEventListener listener) {
        ((AbstractCollection)this.listeners).remove(listener);
    }

    public String getDbIdForTrace() {
        return this.pConn instanceof SQLTracable ? ((SQLTracable)((Object)this.pConn)).getDbIdForTrace() : null;
    }

    public Id[] getIds() {
        return new Id[]{new Id(this, "pooledstmtid"), new Id(this.pConn, "physconnid")};
    }

    void statementClosed() throws SQLException {
        TRACE.entering("statementClosed()");
        if (this.isPooled) {
            int i = 0;
            while (i < this.listeners.size()) {
                ((StatementEventListener)this.listeners.get(i)).statementClosed(this);
                ++i;
            }
        } else if (this.pConn.getConnectionContext().getStatementPool().add(this)) {
            this.isPooled = true;
        } else {
            this.close();
        }
        TRACE.exiting();
    }

    private String getConnId() {
        return this.pConn instanceof ConnectionWrapper ? ((ConnectionWrapper)((Object)this.pConn)).getConnectionContext().getConnectionID() : "";
    }

    private SQLTracer getSQLTracer() {
        if (this.trc == null) {
            this.trc = new SQLTracer(this);
        }
        return this.trc;
    }

    private SQLException processSQLException(String methodName, SQLException e) {
        if (SQLTrace.isOn()) {
            this.getSQLTracer().traceException(e, methodName, this.sql, null);
        }
        return Syslog.logSQLException(this, e, this.getConnId(), this.sql);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

