/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.direct;

import com.sap.exception.standard.SAPIllegalArgumentException;
import com.sap.sql.jdbc.ConnectionContext;
import com.sap.sql.jdbc.ContextFactory;
import com.sap.sql.jdbc.DataSourceContext;
import com.sap.sql.jdbc.DatabaseVendor;
import com.sap.sql.jdbc.VMContext;
import com.sap.sql.jdbc.basic.BasicDbPortingServices;
import com.sap.sql.jdbc.basic.DbPortingFactory;
import com.sap.sql.jdbc.basic.SQLExceptionAnalyzer;
import com.sap.sql.jdbc.direct.DirectConnection;
import com.sap.sql.jdbc.direct.DirectPooledConnection;
import com.sap.sql.jdbc.direct.DirectXAConnection;
import com.sap.sql.jdbc.direct.PhysicalConnection;
import com.sap.sql.jdbc.stmtpool.StatementPool;
import com.sap.sql.log.Syslog;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;

public class DirectConnectionFactory {
    public static final String CONNECTION_NAME = "jndiName";
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$jdbc$direct$DirectConnectionFactory == null ? (class$com$sap$sql$jdbc$direct$DirectConnectionFactory = DirectConnectionFactory.class$("com.sap.sql.jdbc.direct.DirectConnectionFactory")) : class$com$sap$sql$jdbc$direct$DirectConnectionFactory));
    private static String[] portingFactoryClassNames = new String[DatabaseVendor.getVendorNames().length];
    private static Set openConnections = Collections.synchronizedSet(new HashSet());
    static /* synthetic */ Class class$com$sap$sql$jdbc$direct$DirectConnectionFactory;

    private DirectConnectionFactory() {
    }

    public static Connection createDirectConnection(Connection basicConnection, Properties properties) throws SQLException {
        DirectConnection conn = null;
        TRACE.entering("createDirectConnection(Connection, Properties)", new Object[]{basicConnection, properties});
        try {
            if (basicConnection == null) {
                throw new SAPIllegalArgumentException("com.sap.exception.standard_0001", new Object[]{"basicConnection"});
            }
            ContextFactory factory = DirectConnectionFactory.createContextFactory(basicConnection, properties);
            ConnectionContext context = factory.getConnectionContext();
            conn = new DirectConnection(context);
            factory.setConnection(conn);
            openConnections.add(conn);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            TRACE.exiting(conn);
            throw throwable;
        }
        TRACE.exiting((Object)conn);
        return conn;
    }

    public static PooledConnection createDirectPooledConnection(Connection basicConnection, Properties properties) throws SQLException {
        DirectPooledConnection pooledConn = null;
        TRACE.entering("createDirectPooledConnection(Connection, Properties)", new Object[]{basicConnection, properties});
        try {
            if (basicConnection == null) {
                throw new SAPIllegalArgumentException("com.sap.exception.standard_0001", new Object[]{"basicConnection"});
            }
            ContextFactory factory = DirectConnectionFactory.createContextFactory(basicConnection, properties);
            pooledConn = new DirectPooledConnection(factory);
            openConnections.add(pooledConn);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            TRACE.exiting(pooledConn);
            throw throwable;
        }
        TRACE.exiting((Object)pooledConn);
        return pooledConn;
    }

    public static PooledConnection createDirectPooledConnection(PooledConnection basicPooledConnection, Properties properties) throws SQLException {
        DirectPooledConnection pooledConn = null;
        TRACE.entering("createDirectPooledConnection(PooledConnection, Properties)", new Object[]{basicPooledConnection, properties});
        try {
            if (basicPooledConnection == null) {
                throw new SAPIllegalArgumentException("com.sap.exception.standard_0001", new Object[]{"basicPooledConnection"});
            }
            ContextFactory factory = DirectConnectionFactory.createContextFactory(basicPooledConnection.getConnection(), properties);
            pooledConn = new DirectPooledConnection(basicPooledConnection, factory);
            basicPooledConnection.addConnectionEventListener(pooledConn);
            openConnections.add(pooledConn);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            TRACE.exiting(pooledConn);
            throw throwable;
        }
        TRACE.exiting((Object)pooledConn);
        return pooledConn;
    }

    public static XAConnection createDirectXAConnection(XAConnection basicXAConnection, Properties properties) throws SQLException {
        DirectXAConnection xaConn = null;
        TRACE.entering("createDirectXAConnection(XAConnection, Properties)", new Object[]{basicXAConnection, properties});
        try {
            if (basicXAConnection == null) {
                throw new SAPIllegalArgumentException("com.sap.exception.standard_0001", new Object[]{"basicXAConnection"});
            }
            ContextFactory factory = DirectConnectionFactory.createContextFactory(basicXAConnection.getConnection(), properties);
            xaConn = new DirectXAConnection(basicXAConnection, factory);
            basicXAConnection.addConnectionEventListener(xaConn);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            TRACE.exiting(xaConn);
            throw throwable;
        }
        TRACE.exiting((Object)xaConn);
        return xaConn;
    }

    static Connection createDirectConnectionHandle(DirectPooledConnection pooledConnection, ContextFactory factory) throws SQLException {
        DirectConnection conn = null;
        TRACE.entering("createDirectConnection(DirectPooledConnection, ContextFactory)", new Object[]{pooledConnection, factory});
        try {
            ConnectionContext context = factory.createConnectionContextClone();
            conn = new DirectConnection(pooledConnection, context);
            factory.setConnection(conn);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            TRACE.exiting(conn);
            throw throwable;
        }
        TRACE.exiting((Object)conn);
        return conn;
    }

    public static Map getOpenConnections() {
        Set set = openConnections;
        synchronized (set) {
            int connCnt = openConnections.size();
            HashMap<String, ArrayList<PhysicalConnection>> result = new HashMap<String, ArrayList<PhysicalConnection>>(connCnt);
            Iterator iter = openConnections.iterator();
            while (iter.hasNext()) {
                PhysicalConnection physConn = (PhysicalConnection)iter.next();
                ConnectionContext connCtxt = physConn.getConnectionContext();
                String dsName = connCtxt.getConnectionName();
                ArrayList<PhysicalConnection> connections = (ArrayList<PhysicalConnection>)result.get(dsName);
                if (connections == null) {
                    connections = new ArrayList<PhysicalConnection>(connCnt);
                }
                connections.add(physConn);
                result.put(dsName, connections);
            }
            HashMap<String, ArrayList<PhysicalConnection>> hashMap = result;
            return hashMap;
        }
    }

    static void unregisterConnection(PhysicalConnection conn) {
        if (TRACE.bePath()) {
            TRACE.entering("unregisterConnection", new Object[]{conn});
        }
        openConnections.remove(conn);
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    private static ContextFactory createContextFactory(Connection basicConnection, Properties properties) throws SQLException {
        int vendorID = DatabaseVendor.getVendorID(basicConnection);
        DbPortingFactory portFactory = DirectConnectionFactory.getDbPortingFactory(basicConnection, vendorID);
        try {
            if (!portFactory.isJdbcDriverSupported(basicConnection)) {
                throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$jdbc$direct$DirectConnectionFactory == null ? (class$com$sap$sql$jdbc$direct$DirectConnectionFactory = DirectConnectionFactory.class$("com.sap.sql.jdbc.direct.DirectConnectionFactory")) : class$com$sap$sql$jdbc$direct$DirectConnectionFactory, "com.sap.sql.jdbc.direct_1052", new Object[]{DatabaseVendor.getVendorName(vendorID)});
            }
        }
        catch (SQLException ex) {
            throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$jdbc$direct$DirectConnectionFactory == null ? (class$com$sap$sql$jdbc$direct$DirectConnectionFactory = DirectConnectionFactory.class$("com.sap.sql.jdbc.direct.DirectConnectionFactory")) : class$com$sap$sql$jdbc$direct$DirectConnectionFactory, "com.sap.sql.jdbc.direct_1052", new Object[]{DatabaseVendor.getVendorName(vendorID)}, (Throwable)ex);
        }
        Connection portConnection = null;
        BasicDbPortingServices portServices = null;
        SQLExceptionAnalyzer sqlExceptionAnalyzer = null;
        String serverName = null;
        String databaseName = null;
        String schemaName = null;
        String userName = null;
        String method = "";
        try {
            method = "createPortedConnection(conn)";
            portConnection = portFactory.createPortedConnection(basicConnection);
            method = "createDbPortingServices(conn)";
            portServices = portFactory.createDbPortingServices(basicConnection);
            method = "createSQLExceptionAnalyzer(conn)";
            sqlExceptionAnalyzer = portFactory.createSQLExceptionAnalyzer(basicConnection);
            method = "getDatabaseHost()";
            serverName = portServices.getDatabaseHost();
            method = "getDatabaseName()";
            databaseName = portServices.getDatabaseName();
            method = "getSchemaName()";
            schemaName = portServices.getSchemaName();
            method = "getUserName()";
            userName = portServices.getUserName();
        }
        catch (SQLException ex) {
            throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$jdbc$direct$DirectConnectionFactory == null ? (class$com$sap$sql$jdbc$direct$DirectConnectionFactory = DirectConnectionFactory.class$("com.sap.sql.jdbc.direct.DirectConnectionFactory")) : class$com$sap$sql$jdbc$direct$DirectConnectionFactory, "com.sap.sql.jdbc.direct_1053", new Object[]{DatabaseVendor.getVendorName(vendorID), method}, (Throwable)ex);
        }
        String dataSourceID = serverName + ":" + databaseName + ":" + schemaName;
        String dataSourceName = null;
        boolean isSystemDS = false;
        if (properties != null) {
            dataSourceName = properties.getProperty(CONNECTION_NAME);
            String sds = properties.getProperty("systemDataSource");
            boolean bl = isSystemDS = sds != null && sds.equalsIgnoreCase("true");
        }
        if (dataSourceName == null) {
            dataSourceName = dataSourceID;
        }
        Properties props = ContextFactory.mergeProperties(isSystemDS ? "SYSTEM" : dataSourceID, isSystemDS ? "SYSTEM" : dataSourceName, properties);
        VMContext.initInstance(props);
        StatementPool stmtPool = DirectConnectionFactory.createStatementPool(props);
        DataSourceContext dsContext = ContextFactory.createDataSourceContext(dataSourceName, serverName, databaseName, null, vendorID, DatabaseVendor.getVendorName(vendorID), 2);
        ContextFactory factory = new ContextFactory();
        factory.createConnectionContext(dsContext);
        factory.setWrappedConnection(portConnection);
        factory.setConnectionID(dataSourceID);
        factory.setUserName(userName);
        factory.setStatementPool(stmtPool);
        factory.setDbPortingServices(portServices);
        factory.setSQLExceptionAnalyzer(sqlExceptionAnalyzer);
        factory.setProperties(props);
        factory.setAutoCommit(basicConnection.getAutoCommit());
        factory.setTransactionIsolation(basicConnection.getTransactionIsolation());
        return factory;
    }

    private static DbPortingFactory getDbPortingFactory(Connection basicConnection, int vendorID) throws SQLException {
        if (vendorID == -1) {
            throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$jdbc$direct$DirectConnectionFactory == null ? (class$com$sap$sql$jdbc$direct$DirectConnectionFactory = DirectConnectionFactory.class$("com.sap.sql.jdbc.direct.DirectConnectionFactory")) : class$com$sap$sql$jdbc$direct$DirectConnectionFactory, "com.sap.sql.jdbc.direct_1051", new Object[]{basicConnection.getMetaData().getDatabaseProductName().toUpperCase()});
        }
        String factoryClassName = portingFactoryClassNames[vendorID];
        if (factoryClassName == null) {
            throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$jdbc$direct$DirectConnectionFactory == null ? (class$com$sap$sql$jdbc$direct$DirectConnectionFactory = DirectConnectionFactory.class$("com.sap.sql.jdbc.direct.DirectConnectionFactory")) : class$com$sap$sql$jdbc$direct$DirectConnectionFactory, "com.sap.sql.jdbc.direct_1051", new Object[]{DatabaseVendor.getVendorName(vendorID)});
        }
        ClassLoader loader = VMContext.isJ2EEServerActive() ? basicConnection.getClass().getClassLoader() : (class$com$sap$sql$jdbc$direct$DirectConnectionFactory == null ? (class$com$sap$sql$jdbc$direct$DirectConnectionFactory = DirectConnectionFactory.class$("com.sap.sql.jdbc.direct.DirectConnectionFactory")) : class$com$sap$sql$jdbc$direct$DirectConnectionFactory).getClassLoader();
        try {
            Class<?> factoryClass = Class.forName(factoryClassName, true, loader);
            DbPortingFactory factory = (DbPortingFactory)factoryClass.newInstance();
            return factory;
        }
        catch (ClassNotFoundException notFoundEx) {
            throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$jdbc$direct$DirectConnectionFactory == null ? (class$com$sap$sql$jdbc$direct$DirectConnectionFactory = DirectConnectionFactory.class$("com.sap.sql.jdbc.direct.DirectConnectionFactory")) : class$com$sap$sql$jdbc$direct$DirectConnectionFactory, "com.sap.sql_0006", new Object[]{factoryClassName}, (Throwable)notFoundEx);
        }
        catch (IllegalAccessException illegalEx) {
            throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$jdbc$direct$DirectConnectionFactory == null ? (class$com$sap$sql$jdbc$direct$DirectConnectionFactory = DirectConnectionFactory.class$("com.sap.sql.jdbc.direct.DirectConnectionFactory")) : class$com$sap$sql$jdbc$direct$DirectConnectionFactory, "com.sap.sql_0007", new Object[]{factoryClassName}, (Throwable)illegalEx);
        }
        catch (InstantiationException instantiationEx) {
            throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$jdbc$direct$DirectConnectionFactory == null ? (class$com$sap$sql$jdbc$direct$DirectConnectionFactory = DirectConnectionFactory.class$("com.sap.sql.jdbc.direct.DirectConnectionFactory")) : class$com$sap$sql$jdbc$direct$DirectConnectionFactory, "com.sap.sql_0007", new Object[]{factoryClassName}, (Throwable)instantiationEx);
        }
    }

    private static StatementPool createStatementPool(Properties props) throws SQLException {
        String prop = "com.sap.sql.jdbc.stmtpool.capacity";
        String propValue = props.getProperty("com.sap.sql.jdbc.stmtpool.capacity");
        int capacity = 0;
        if (propValue != null) {
            try {
                capacity = Integer.parseInt(propValue);
            }
            catch (NumberFormatException ex) {
                throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$jdbc$direct$DirectConnectionFactory == null ? (class$com$sap$sql$jdbc$direct$DirectConnectionFactory = DirectConnectionFactory.class$("com.sap.sql.jdbc.direct.DirectConnectionFactory")) : class$com$sap$sql$jdbc$direct$DirectConnectionFactory, "com.sap.sql_0014", new Object[]{"com.sap.sql.jdbc.stmtpool.capacity", propValue}, (Throwable)ex);
            }
        } else {
            throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$jdbc$direct$DirectConnectionFactory == null ? (class$com$sap$sql$jdbc$direct$DirectConnectionFactory = DirectConnectionFactory.class$("com.sap.sql.jdbc.direct.DirectConnectionFactory")) : class$com$sap$sql$jdbc$direct$DirectConnectionFactory, "com.sap.sql_0013", new Object[]{"com.sap.sql.jdbc.stmtpool.capacity", propValue});
        }
        return capacity > 0 ? new StatementPool(capacity) : null;
    }

    private static void registerPortingFactory(String vendorName, String className) {
        int vendorID = DatabaseVendor.getVendorID(vendorName);
        if (vendorID != -1) {
            DirectConnectionFactory.portingFactoryClassNames[vendorID] = className;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DirectConnectionFactory.registerPortingFactory("DB2_UDB", "com.sap.sql.jdbc.db6.Db6PortingFactory");
        DirectConnectionFactory.registerPortingFactory("DB2_UDB_AS400", "com.sap.sql.jdbc.db4.Db4PortingFactory");
        DirectConnectionFactory.registerPortingFactory("DB2_UDB_OS390", "com.sap.sql.jdbc.db2.Db2PortingFactory");
        DirectConnectionFactory.registerPortingFactory("MS_SQL_SERVER", "com.sap.sql.jdbc.mss.MssPortingFactory");
        DirectConnectionFactory.registerPortingFactory("ORACLE", "com.sap.sql.jdbc.oracle.OraclePortingFactory");
        DirectConnectionFactory.registerPortingFactory("SAPDB", "com.sap.sql.jdbc.sapdb.SapdbPortingFactory");
    }
}

