/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.direct;

import com.sap.sql.jdbc.ConnectionContext;
import com.sap.sql.jdbc.ConnectionWrapper;
import com.sap.sql.jdbc.ContextFactory;
import com.sap.sql.jdbc.ExtendedConnection;
import com.sap.sql.jdbc.ServiceConnection;
import com.sap.sql.jdbc.direct.DirectCallableStatement;
import com.sap.sql.jdbc.direct.DirectConnectionFactory;
import com.sap.sql.jdbc.direct.DirectDatabaseMetaData;
import com.sap.sql.jdbc.direct.DirectPooledConnection;
import com.sap.sql.jdbc.direct.DirectPooledStatement;
import com.sap.sql.jdbc.direct.DirectPreparedStatement;
import com.sap.sql.jdbc.direct.DirectStatement;
import com.sap.sql.jdbc.direct.PhysicalConnection;
import com.sap.sql.jdbc.stmtpool.StatementPool;
import com.sap.sql.log.Syslog;
import com.sap.sql.trace.Id;
import com.sap.sql.trace.SQLTracable;
import com.sap.sql.trace.SQLTrace;
import com.sap.sql.trace.SQLTracer;
import com.sap.sql.trace.TraceContext;
import com.sap.tc.logging.Location;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class DirectConnection
implements ExtendedConnection,
ConnectionWrapper,
SQLTracable,
PhysicalConnection,
ServiceConnection {
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$jdbc$direct$DirectConnection == null ? (class$com$sap$sql$jdbc$direct$DirectConnection = DirectConnection.class$("com.sap.sql.jdbc.direct.DirectConnection")) : class$com$sap$sql$jdbc$direct$DirectConnection));
    private Connection nConn;
    private ConnectionContext connCtxt;
    private String dbIdForTrace = null;
    private DirectPooledConnection pConn = null;
    private StatementPool stmtPool = null;
    private SQLTracer trc = null;
    private HashSet openStatements = new HashSet();
    private boolean isClosed = false;
    static /* synthetic */ Class class$com$sap$sql$jdbc$direct$DirectConnection;

    DirectConnection(ConnectionContext connCtxt) throws SQLException {
        this(null, connCtxt);
    }

    DirectConnection(DirectPooledConnection pooledConn, ConnectionContext connCtxt) throws SQLException {
        this.pConn = pooledConn;
        this.connCtxt = connCtxt;
        this.nConn = connCtxt.getWrappedConnection();
        this.stmtPool = connCtxt.getStatementPool();
        this.setSQLTraceProps(connCtxt);
        this.setAutoCommit(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Statement createStatement() throws SQLException {
        DirectStatement st = null;
        if (TRACE.bePath()) {
            TRACE.entering("createStatement()");
        }
        try {
            try {
                this.validate();
                st = new DirectStatement(this, this.nConn.createStatement());
                this.openStatements.add(st);
            }
            catch (SQLException e) {
                throw this.processSQLException(e);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (!TRACE.bePath()) throw throwable;
            TRACE.exiting((Object)st);
            throw throwable;
        }
        if (!TRACE.bePath()) return st;
        TRACE.exiting((Object)st);
        return st;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        DirectStatement st = null;
        if (TRACE.bePath()) {
            TRACE.entering("createStatement()");
        }
        try {
            this.validate();
            try {
                st = new DirectStatement(this, this.nConn.createStatement(resultSetType, resultSetConcurrency));
                this.openStatements.add(st);
            }
            catch (SQLException e) {
                throw this.processSQLException(e);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (TRACE.bePath()) {
                TRACE.exiting(st);
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting((Object)st);
        }
        return st;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, (TraceContext)null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PreparedStatement prepareStatement(String sql, TraceContext trcCtxt) throws SQLException {
        PreparedStatement ps;
        block10: {
            PreparedStatement preparedStatement;
            block9: {
                ps = null;
                if (TRACE.bePath()) {
                    TRACE.entering("prepareStatement(String)", new Object[]{sql});
                }
                try {
                    this.validate();
                    if (this.stmtPool != null && (ps = this.stmtPool.lookup(sql, 1003, 1007)) != null) {
                        this.openStatements.add(ps);
                        preparedStatement = ps;
                        Object var7_8 = null;
                        break block9;
                    }
                    try {
                        if (SQLTrace.isOn()) {
                            SQLTracer sqlTrace = this.getSQLTracer();
                            sqlTrace.startTimer();
                            PreparedStatement vendorPS = this.nConn.prepareStatement(sql);
                            sqlTrace.stopTimer();
                            ps = this.wrapVendorPreparedStatement(vendorPS, sql, 1003, 1007);
                            this.openStatements.add(ps);
                            sqlTrace.setId(ps, "pstmtid");
                            if (trcCtxt != null) {
                                sqlTrace.setTraceContext(trcCtxt);
                            }
                            sqlTrace.trace("prepareStatement(String)", sql);
                            break block10;
                        } else {
                            PreparedStatement vendorPS = this.nConn.prepareStatement(sql);
                            ps = this.wrapVendorPreparedStatement(vendorPS, sql, 1003, 1007);
                            this.openStatements.add(ps);
                        }
                        break block10;
                    }
                    catch (SQLException e) {
                        throw this.processSQLException(e, true, "prepareStatement(String)", sql);
                    }
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    if (!TRACE.bePath()) throw throwable;
                    TRACE.exiting(ps);
                    throw throwable;
                }
            }
            if (!TRACE.bePath()) return preparedStatement;
            TRACE.exiting((Object)ps);
            return preparedStatement;
        }
        Object var7_9 = null;
        if (!TRACE.bePath()) return ps;
        TRACE.exiting((Object)ps);
        return ps;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement ps;
        block9: {
            PreparedStatement preparedStatement;
            block8: {
                PreparedStatement preparedStatement2;
                block7: {
                    ps = null;
                    if (TRACE.bePath()) {
                        TRACE.entering("prepareStatement(String, int, int)", new Object[]{sql, new Integer(resultSetType), new Integer(resultSetConcurrency)});
                    }
                    try {
                        this.validate();
                        if (this.stmtPool != null && (ps = this.stmtPool.lookup(sql, resultSetType, resultSetConcurrency)) != null) {
                            this.openStatements.add(ps);
                            preparedStatement2 = ps;
                            Object var9_9 = null;
                            break block7;
                        }
                        try {
                            if (SQLTrace.isOn()) {
                                SQLTracer sqlTrace = this.getSQLTracer();
                                sqlTrace.startTimer();
                                PreparedStatement vendorPS = this.nConn.prepareStatement(sql, resultSetType, resultSetConcurrency);
                                sqlTrace.stopTimer();
                                ps = this.wrapVendorPreparedStatement(vendorPS, sql, resultSetType, resultSetConcurrency);
                                this.openStatements.add(ps);
                                sqlTrace.addInParam("" + resultSetType);
                                sqlTrace.addInParam("" + resultSetConcurrency);
                                sqlTrace.setId(ps, "pstmtid");
                                sqlTrace.trace("prepareStatement(String, int, int)", sql);
                                preparedStatement = ps;
                                break block8;
                            }
                            PreparedStatement vendorPS = this.nConn.prepareStatement(sql, resultSetType, resultSetConcurrency);
                            ps = this.wrapVendorPreparedStatement(vendorPS, sql, resultSetType, resultSetConcurrency);
                            this.openStatements.add(ps);
                            break block9;
                        }
                        catch (SQLException e) {
                            throw this.processSQLException(e, true, "prepareStatement(String, int, int)", sql);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        if (!TRACE.bePath()) throw throwable;
                        TRACE.exiting(ps);
                        throw throwable;
                    }
                }
                if (!TRACE.bePath()) return preparedStatement2;
                TRACE.exiting((Object)ps);
                return preparedStatement2;
            }
            Object var9_10 = null;
            if (!TRACE.bePath()) return preparedStatement;
            TRACE.exiting((Object)ps);
            return preparedStatement;
        }
        Object var9_11 = null;
        if (!TRACE.bePath()) return ps;
        TRACE.exiting((Object)ps);
        return ps;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        DirectCallableStatement cs = null;
        if (TRACE.bePath()) {
            TRACE.entering("prepareCall(String)", new Object[]{sql});
        }
        try {
            this.validate();
            try {
                if (SQLTrace.isOn()) {
                    SQLTracer sqlTrace = this.getSQLTracer();
                    sqlTrace.startTimer();
                    cs = new DirectCallableStatement(this, this.nConn.prepareCall(sql), sql);
                    sqlTrace.stopTimer();
                    this.openStatements.add(cs);
                    sqlTrace.trace("prepareCall(String)", sql);
                } else {
                    cs = new DirectCallableStatement(this, this.nConn.prepareCall(sql), sql);
                    this.openStatements.add(cs);
                }
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "prepareCall(String)", sql);
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE.bePath()) {
                TRACE.exiting(cs);
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting((Object)cs);
        }
        return cs;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        DirectCallableStatement cs = null;
        if (TRACE.bePath()) {
            TRACE.entering("prepareCall(String, int, int)", new Object[]{sql, new Integer(resultSetType), new Integer(resultSetConcurrency)});
        }
        try {
            this.validate();
            try {
                if (SQLTrace.isOn()) {
                    SQLTracer sqlTrace = this.getSQLTracer();
                    sqlTrace.startTimer();
                    cs = new DirectCallableStatement(this, this.nConn.prepareCall(sql, resultSetType, resultSetConcurrency), sql);
                    sqlTrace.stopTimer();
                    this.openStatements.add(cs);
                    sqlTrace.addInParam("" + resultSetType);
                    sqlTrace.addInParam("" + resultSetConcurrency);
                    sqlTrace.trace("prepareCall(String, int, int)", sql);
                } else {
                    cs = new DirectCallableStatement(this, this.nConn.prepareCall(sql, resultSetType, resultSetConcurrency), sql);
                    this.openStatements.add(cs);
                }
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "prepareCall(String, int, int)", sql);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (TRACE.bePath()) {
                TRACE.exiting(cs);
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting((Object)cs);
        }
        return cs;
    }

    public String nativeSQL(String sql) throws SQLException {
        String str = null;
        if (TRACE.bePath()) {
            TRACE.entering("nativeSQL(String)", new Object[]{sql});
        }
        try {
            this.validate();
            try {
                if (SQLTrace.isOn()) {
                    SQLTracer sqlTrace = this.getSQLTracer();
                    sqlTrace.startTimer();
                    str = this.nConn.nativeSQL(sql);
                    sqlTrace.stopTimer();
                    sqlTrace.trace("nativeSQL(String)", sql);
                } else {
                    str = this.nConn.nativeSQL(sql);
                }
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "nativeSQL(String)", sql);
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE.bePath()) {
                TRACE.exiting((Object)str);
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting((Object)str);
        }
        return str;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        block9: {
            block8: {
                if (TRACE.bePath()) {
                    TRACE.entering("setAutoCommit(boolean)", new Object[]{new Boolean(autoCommit)});
                }
                try {
                    this.validate();
                    if (autoCommit == this.connCtxt.getAutoCommit()) {
                        Object var4_2 = null;
                        break block8;
                    }
                    try {
                        if (SQLTrace.isOn()) {
                            SQLTracer sqlTrace = this.getSQLTracer();
                            sqlTrace.startTimer();
                            this.nConn.setAutoCommit(autoCommit);
                            this.connCtxt.setAutoCommit(autoCommit);
                            sqlTrace.stopTimer();
                            sqlTrace.addInParam("" + autoCommit);
                            sqlTrace.trace("setAutoCommit(boolean)", "setAutoCommit(" + autoCommit + ")");
                            break block9;
                        } else {
                            this.nConn.setAutoCommit(autoCommit);
                            this.connCtxt.setAutoCommit(autoCommit);
                        }
                        break block9;
                    }
                    catch (SQLException e) {
                        throw this.processSQLException(e, true, "setAutoCommit(boolean)", null);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (!TRACE.bePath()) throw throwable;
                    TRACE.exiting();
                    throw throwable;
                }
            }
            if (!TRACE.bePath()) return;
            TRACE.exiting();
            return;
        }
        Object var4_3 = null;
        if (!TRACE.bePath()) return;
        TRACE.exiting();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getAutoCommit() throws SQLException {
        boolean bl;
        if (TRACE.bePath()) {
            TRACE.entering("getAutoCommit()");
        }
        try {
            this.validate();
            bl = this.connCtxt.getAutoCommit();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!TRACE.bePath()) throw throwable;
            TRACE.exiting();
            throw throwable;
        }
        if (!TRACE.bePath()) return bl;
        TRACE.exiting();
        return bl;
    }

    public void commit() throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("commit()");
        }
        try {
            this.validate();
            try {
                if (SQLTrace.isOn()) {
                    SQLTracer sqlTrace = this.getSQLTracer();
                    sqlTrace.startTimer();
                    this.nConn.commit();
                    sqlTrace.stopTimer();
                    sqlTrace.trace("commit()");
                } else {
                    this.nConn.commit();
                }
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "commit()", "COMMIT");
            }
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void rollback() throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("rollback()");
        }
        try {
            this.validate();
            try {
                if (SQLTrace.isOn()) {
                    SQLTracer sqlTrace = this.getSQLTracer();
                    sqlTrace.startTimer();
                    this.nConn.rollback();
                    sqlTrace.stopTimer();
                    sqlTrace.trace("rollback()");
                } else {
                    this.nConn.rollback();
                }
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "rollback()", "ROLLBACK");
            }
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws SQLException {
        block18: {
            block16: {
                block17: {
                    if (TRACE.bePath()) {
                        TRACE.entering("close()");
                    }
                    try {
                        if (this.isClosed) {
                            Object var5_1 = null;
                            if (this.isClosed || this.connCtxt.getState() != 0) break block16;
                            break block17;
                        }
                        if (!this.connCtxt.getAutoCommit()) {
                            try {
                                this.rollback();
                            }
                            catch (SQLException ex) {
                                // empty catch block
                            }
                        }
                        this.closeStatements();
                        if (this.pConn != null) {
                            this.pConn.connectionClosed();
                            this.pConn = null;
                            break block18;
                        }
                        try {
                            try {
                                if (SQLTrace.isOn()) {
                                    SQLTracer sqlTrace = this.getSQLTracer();
                                    sqlTrace.startTimer();
                                    this.nConn.close();
                                    sqlTrace.stopTimer();
                                    sqlTrace.trace("close()");
                                } else {
                                    this.nConn.close();
                                }
                            }
                            catch (SQLException e) {
                                throw this.processSQLException(e, true, "close()", null);
                            }
                            Object var3_7 = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_8 = null;
                            DirectConnectionFactory.unregisterConnection(this);
                            throw throwable;
                        }
                        DirectConnectionFactory.unregisterConnection(this);
                        break block18;
                    }
                    catch (Throwable throwable) {
                        Object var5_3 = null;
                        if (!this.isClosed && this.connCtxt.getState() == 0) {
                            ContextFactory.closeConnectionContext(this.connCtxt);
                            this.connCtxt = null;
                            this.nConn = null;
                            this.openStatements = null;
                            this.stmtPool = null;
                            this.trc = null;
                        }
                        this.isClosed = true;
                        if (!TRACE.bePath()) throw throwable;
                        TRACE.exiting();
                        throw throwable;
                    }
                }
                ContextFactory.closeConnectionContext(this.connCtxt);
                this.connCtxt = null;
                this.nConn = null;
                this.openStatements = null;
                this.stmtPool = null;
                this.trc = null;
            }
            this.isClosed = true;
            if (!TRACE.bePath()) return;
            TRACE.exiting();
            return;
        }
        Object var5_2 = null;
        if (!this.isClosed && this.connCtxt.getState() == 0) {
            ContextFactory.closeConnectionContext(this.connCtxt);
            this.connCtxt = null;
            this.nConn = null;
            this.openStatements = null;
            this.stmtPool = null;
            this.trc = null;
        }
        this.isClosed = true;
        if (!TRACE.bePath()) return;
        TRACE.exiting();
    }

    public boolean isClosed() throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("isClosed()");
            TRACE.exiting();
        }
        return this.isClosed;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        DirectDatabaseMetaData md = null;
        if (TRACE.bePath()) {
            TRACE.entering("getMetaData()");
        }
        try {
            this.validate();
            try {
                if (SQLTrace.isOn()) {
                    SQLTracer sqlTrace = this.getSQLTracer();
                    sqlTrace.startTimer();
                    md = new DirectDatabaseMetaData(this, this.nConn.getMetaData());
                    sqlTrace.stopTimer();
                    sqlTrace.trace("getMetaData()");
                } else {
                    md = new DirectDatabaseMetaData(this, this.nConn.getMetaData());
                }
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "getMetaData()", null);
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE.bePath()) {
                TRACE.exiting(md);
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting((Object)md);
        }
        return md;
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setReadOnly(boolean)", new Object[]{new Boolean(readOnly)});
        }
        try {
            this.validate();
            try {
                if (SQLTrace.isOn()) {
                    SQLTracer sqlTrace = this.getSQLTracer();
                    sqlTrace.startTimer();
                    this.nConn.setReadOnly(readOnly);
                    sqlTrace.stopTimer();
                    sqlTrace.addInParam("" + readOnly);
                    sqlTrace.trace("setReadOnly(boolean)", "setReadOnly(" + readOnly + ")");
                } else {
                    this.nConn.setReadOnly(readOnly);
                }
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setReadOnly(boolean)", null);
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public boolean isReadOnly() throws SQLException {
        boolean b = false;
        if (TRACE.bePath()) {
            TRACE.entering("isReadOnly()");
        }
        try {
            this.validate();
            try {
                b = this.nConn.isReadOnly();
            }
            catch (SQLException e) {
                throw this.processSQLException(e);
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (TRACE.bePath()) {
                TRACE.exiting((Object)new Boolean(b));
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting((Object)new Boolean(b));
        }
        return b;
    }

    public void setCatalog(String catalog) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setCatalog(String)", new Object[]{catalog});
        }
        try {
            this.validate();
            try {
                if (SQLTrace.isOn()) {
                    SQLTracer sqlTrace = this.getSQLTracer();
                    sqlTrace.startTimer();
                    this.nConn.setCatalog(catalog);
                    sqlTrace.stopTimer();
                    sqlTrace.addInParam(catalog);
                    sqlTrace.trace("setCatalog(String)");
                } else {
                    this.nConn.setCatalog(catalog);
                }
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setCatalog(String)", null);
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public String getCatalog() throws SQLException {
        String str = null;
        if (TRACE.bePath()) {
            TRACE.entering("getCatalog()");
        }
        try {
            this.validate();
            try {
                str = this.nConn.getCatalog();
            }
            catch (SQLException e) {
                throw this.processSQLException(e);
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (TRACE.bePath()) {
                TRACE.exiting((Object)str);
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting((Object)str);
        }
        return str;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setTransactionIsolation(int level) throws SQLException {
        block9: {
            block8: {
                if (TRACE.bePath()) {
                    TRACE.entering("setTransactionIsolation(int)", new Object[]{new Integer(level)});
                }
                try {
                    this.validate();
                    if (level == this.connCtxt.getTransactionIsolation()) {
                        Object var4_2 = null;
                        break block8;
                    }
                    try {
                        if (SQLTrace.isOn()) {
                            SQLTracer sqlTrace = this.getSQLTracer();
                            sqlTrace.startTimer();
                            this.nConn.setTransactionIsolation(level);
                            sqlTrace.stopTimer();
                            sqlTrace.addInParam("" + level);
                            sqlTrace.trace("setTransactionIsolation(int)", "setTransactionIsolation(" + level + ")");
                        } else {
                            this.nConn.setTransactionIsolation(level);
                        }
                        this.connCtxt.setTransactionIsolation(level);
                        break block9;
                    }
                    catch (SQLException e) {
                        throw this.processSQLException(e, true, "setTransactionIsolation(int)", null);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (!TRACE.bePath()) throw throwable;
                    TRACE.exiting();
                    throw throwable;
                }
            }
            if (!TRACE.bePath()) return;
            TRACE.exiting();
            return;
        }
        Object var4_3 = null;
        if (!TRACE.bePath()) return;
        TRACE.exiting();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTransactionIsolation() throws SQLException {
        int n;
        if (TRACE.bePath()) {
            TRACE.entering("getTransactionIsolation()");
        }
        try {
            this.validate();
            n = this.connCtxt.getTransactionIsolation();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!TRACE.bePath()) throw throwable;
            TRACE.exiting((Object)new Integer(this.connCtxt.getTransactionIsolation()));
            throw throwable;
        }
        if (!TRACE.bePath()) return n;
        TRACE.exiting((Object)new Integer(this.connCtxt.getTransactionIsolation()));
        return n;
    }

    public SQLWarning getWarnings() throws SQLException {
        SQLWarning w = null;
        TRACE.entering("getWarnings()");
        try {
            this.validate();
            try {
                w = this.nConn.getWarnings();
            }
            catch (SQLException e) {
                throw this.processSQLException(e);
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (TRACE.bePath()) {
                TRACE.exiting((Object)w);
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting((Object)w);
        }
        return w;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearWarnings() throws SQLException {
        block7: {
            block6: {
                if (TRACE.bePath()) {
                    TRACE.entering("clearWarnings()");
                }
                try {
                    if (this.isClosed) {
                        Object var3_1 = null;
                        break block6;
                    }
                    try {
                        this.nConn.clearWarnings();
                        break block7;
                    }
                    catch (SQLException e) {
                        throw this.processSQLException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (!TRACE.bePath()) throw throwable;
                    TRACE.exiting();
                    throw throwable;
                }
            }
            if (!TRACE.bePath()) return;
            TRACE.exiting();
            return;
        }
        Object var3_2 = null;
        if (!TRACE.bePath()) return;
        TRACE.exiting();
    }

    public Map getTypeMap() throws SQLException {
        Map<String, Class<?>> m = null;
        if (TRACE.bePath()) {
            TRACE.entering("getTypeMap()");
        }
        try {
            this.validate();
            try {
                m = this.nConn.getTypeMap();
            }
            catch (SQLException e) {
                throw this.processSQLException(e);
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (TRACE.bePath()) {
                TRACE.exiting(m);
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting(m);
        }
        return m;
    }

    public void setTypeMap(Map map) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setTypeMap(Map)", new Object[]{map});
        }
        try {
            this.validate();
            try {
                if (SQLTrace.isOn()) {
                    SQLTracer sqlTrace = this.getSQLTracer();
                    sqlTrace.startTimer();
                    this.nConn.setTypeMap(map);
                    sqlTrace.stopTimer();
                    sqlTrace.addInParam("" + map);
                    sqlTrace.trace("setTypeMap(Map)");
                } else {
                    this.nConn.setTypeMap(map);
                }
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "setTypeMap(Map)", null);
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connCtxt;
    }

    public String getDbIdForTrace() {
        return this.dbIdForTrace;
    }

    public Object getServiceContext() throws SQLException {
        return this.connCtxt;
    }

    public Id[] getIds() {
        return new Id[]{new Id(this, "dconnid"), new Id(this.nConn, "physconnid")};
    }

    public Collection getOpenStatements() {
        return this.openStatements;
    }

    void invalidate() {
        this.pConn = null;
        this.nConn = null;
    }

    int analyzeSQLException(SQLException exception) {
        int exceptionCategory = this.connCtxt.getSQLExceptionAnalyzer().getCategory(exception);
        switch (exceptionCategory) {
            case 9: {
                if (null == this.pConn) break;
                this.pConn.connectionErrorOccurred(exception);
                break;
            }
            case 8: {
                break;
            }
        }
        return exceptionCategory;
    }

    void statementClosed(Statement statement) {
        this.openStatements.remove(statement);
    }

    void closeStatements() {
        Iterator iter = this.openStatements.iterator();
        while (iter.hasNext()) {
            try {
                ((DirectStatement)iter.next()).close(false);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.openStatements.clear();
    }

    private SQLException processSQLException(SQLException e) {
        SQLException ex = Syslog.logSQLException(this, e, this.connCtxt.getConnectionID());
        this.analyzeSQLException(e);
        return ex;
    }

    private SQLException processSQLException(SQLException e, boolean trace, String methodName, String sql) {
        if (trace && SQLTrace.isOn()) {
            if (sql == null) {
                sql = methodName;
            }
            this.getSQLTracer().traceException(e, methodName, sql);
        }
        SQLException ex = Syslog.logSQLException(this, e, this.connCtxt.getConnectionID(), sql);
        this.analyzeSQLException(e);
        return ex;
    }

    private void validate() throws SQLException {
        if (this.isClosed) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0004", new Object[]{this});
        }
    }

    private void setSQLTraceProps(ConnectionContext connCtxt) {
        this.dbIdForTrace = this.connCtxt.getConnectionName() + "?" + this.connCtxt.getUserName();
    }

    private SQLTracer getSQLTracer() {
        if (this.trc == null) {
            this.trc = new SQLTracer(this);
        }
        return this.trc;
    }

    private PreparedStatement wrapVendorPreparedStatement(PreparedStatement vendorPS, String sql, int resultSetType, int resultSetConcurrency) {
        if (this.stmtPool != null) {
            return new DirectPooledStatement((PhysicalConnection)((Object)(this.pConn != null ? this.pConn : this)), vendorPS, sql, resultSetType, resultSetConcurrency).getPreparedStatement();
        }
        return new DirectPreparedStatement(this, vendorPS, sql);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

