/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.dbds;

import com.sap.sql.jdbc.dbds.DBDSAccess;
import com.sap.sql.jdbc.dbds.DBDSParamDescription;
import com.sap.sql.tree.ResultDescriptor;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class DBDSResultSet
implements ResultSet {
    private DBDSParamDescription[] outParams;
    private HashMap paramMap = new HashMap(128);
    static final int CLOB_BUFFER_SIZE = 32768;
    static final int BLOB_BUFFER_SIZE = 65536;

    public void setOutputParams(Object[] resultSetColumns) {
        ResultDescriptor[] rsc = (ResultDescriptor[])resultSetColumns;
        this.outParams = new DBDSParamDescription[rsc.length];
        int i = 0;
        while (i < rsc.length) {
            this.paramMap.put(rsc[i].getName(), new Integer(i));
            this.setOutParams(i, (int)rsc[i].getSize(), rsc[i].getJdbcType());
            ++i;
        }
    }

    public boolean next() throws SQLException {
        return DBDSAccess.dbdsNext(this.outParams);
    }

    public String getString(int columnIndex) throws SQLException {
        DBDSParamDescription pd = this.outParams[--columnIndex];
        int jdbcType = pd.getJdbcType();
        switch (jdbcType) {
            case 12: 
            case 2005: {
                return pd.getStringParam();
            }
            case 5: {
                return new Short(pd.getShortParam()).toString();
            }
            case 4: {
                return new Integer(pd.getIntParam()).toString();
            }
            case -5: {
                return new Long(pd.getLongParam()).toString();
            }
            case 8: {
                return new Double(pd.getDoubleParam()).toString();
            }
        }
        return null;
    }

    public String getString(String columnName) throws SQLException {
        return this.getString((Integer)this.paramMap.get(columnName) + 1);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        DBDSParamDescription pd = this.outParams[--columnIndex];
        int jdbcType = pd.getJdbcType();
        switch (jdbcType) {
            case -3: 
            case 2004: {
                return pd.getByteParam();
            }
        }
        return null;
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes((Integer)this.paramMap.get(columnName) + 1);
    }

    public short getShort(int columnIndex) throws SQLException {
        DBDSParamDescription pd = this.outParams[--columnIndex];
        int jdbcType = pd.getJdbcType();
        switch (jdbcType) {
            case 5: {
                return pd.getShortParam();
            }
        }
        return 0;
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort((Integer)this.paramMap.get(columnName) + 1);
    }

    public int getInt(int columnIndex) throws SQLException {
        DBDSParamDescription pd = this.outParams[--columnIndex];
        int jdbcType = pd.getJdbcType();
        switch (jdbcType) {
            case 5: {
                return pd.getShortParam();
            }
            case 4: {
                return pd.getIntParam();
            }
        }
        return 0;
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt((Integer)this.paramMap.get(columnName) + 1);
    }

    public long getLong(int columnIndex) throws SQLException {
        DBDSParamDescription pd = this.outParams[--columnIndex];
        int jdbcType = pd.getJdbcType();
        switch (jdbcType) {
            case 5: {
                return pd.getShortParam();
            }
            case 4: {
                return pd.getIntParam();
            }
            case -5: {
                return pd.getLongParam();
            }
        }
        return 0L;
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong((Integer)this.paramMap.get(columnName) + 1);
    }

    public double getDouble(int columnIndex) throws SQLException {
        DBDSParamDescription pd = this.outParams[--columnIndex];
        int jdbcType = pd.getJdbcType();
        switch (jdbcType) {
            case 5: {
                return pd.getShortParam();
            }
            case 4: {
                return pd.getIntParam();
            }
            case -5: {
                return pd.getLongParam();
            }
            case 8: {
                return pd.getDoubleParam();
            }
        }
        return 0.0;
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble((Integer)this.paramMap.get(columnName) + 1);
    }

    public void close() throws SQLException {
        this.outParams = null;
        this.paramMap = null;
        DBDSAccess.dbdsClose();
    }

    public boolean wasNull() throws SQLException {
        DBDSResultSet.throwUnsupported("wasNull()");
        return false;
    }

    public float getFloat(int columnIndex) throws SQLException {
        DBDSResultSet.throwUnsupported("getFloat()");
        return 0.0f;
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        DBDSResultSet.throwUnsupported("getBoolean()");
        return false;
    }

    public byte getByte(int columnIndex) throws SQLException {
        DBDSResultSet.throwUnsupported("getByte()");
        return 0;
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        DBDSResultSet.throwUnsupported("getBigdecimal(int columnIndex, int scale)");
        return null;
    }

    public Date getDate(int columnIndex) throws SQLException {
        DBDSResultSet.throwUnsupported("getDate()");
        return null;
    }

    public Time getTime(int columnIndex) throws SQLException {
        DBDSResultSet.throwUnsupported("getTime()");
        return null;
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        DBDSResultSet.throwUnsupported("getTimestamp()");
        return null;
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        DBDSResultSet.throwUnsupported("getAsciiStream()");
        return null;
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        DBDSResultSet.throwUnsupported("getUnicodeStream()");
        return null;
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        DBDSResultSet.throwUnsupported("getBinaryStream()");
        return null;
    }

    public boolean getBoolean(String columnName) throws SQLException {
        DBDSResultSet.throwUnsupported("getBoolean()");
        return false;
    }

    public byte getByte(String columnName) throws SQLException {
        DBDSResultSet.throwUnsupported("getByte()");
        return 0;
    }

    public float getFloat(String columnName) throws SQLException {
        DBDSResultSet.throwUnsupported("getFloat()");
        return 0.0f;
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        DBDSResultSet.throwUnsupported("getBigDecimal()");
        return null;
    }

    public Date getDate(String columnName) throws SQLException {
        DBDSResultSet.throwUnsupported("getDate()");
        return null;
    }

    public Time getTime(String columnName) throws SQLException {
        DBDSResultSet.throwUnsupported("getTime()");
        return null;
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        DBDSResultSet.throwUnsupported("getTimestamp()");
        return null;
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        DBDSResultSet.throwUnsupported("getAsciiStream()");
        return null;
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        DBDSResultSet.throwUnsupported("getUnicodeStream()");
        return null;
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        DBDSResultSet.throwUnsupported("getBinaryStream()");
        return null;
    }

    public SQLWarning getWarnings() throws SQLException {
        DBDSResultSet.throwUnsupported("getWarnings()");
        return null;
    }

    public void clearWarnings() throws SQLException {
        DBDSResultSet.throwUnsupported("clearWarnings()");
    }

    public String getCursorName() throws SQLException {
        DBDSResultSet.throwUnsupported("getCursorName()");
        return null;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        DBDSResultSet.throwUnsupported("getMetaData()");
        return null;
    }

    public int findColumn(String columnName) throws SQLException {
        DBDSResultSet.throwUnsupported("findColumn()");
        return 0;
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        DBDSResultSet.throwUnsupported("getCharacterStream()");
        return null;
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        DBDSResultSet.throwUnsupported("getCharacterStream()");
        return null;
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        DBDSResultSet.throwUnsupported("getBigDecimal()");
        return null;
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        DBDSResultSet.throwUnsupported("getBigDecimal()");
        return null;
    }

    public boolean isBeforeFirst() throws SQLException {
        DBDSResultSet.throwUnsupported("isBeforeFirst()");
        return false;
    }

    public boolean isAfterLast() throws SQLException {
        DBDSResultSet.throwUnsupported("isAfterLast()");
        return false;
    }

    public boolean isFirst() throws SQLException {
        DBDSResultSet.throwUnsupported("isFirst()");
        return false;
    }

    public boolean isLast() throws SQLException {
        DBDSResultSet.throwUnsupported("isLast()");
        return false;
    }

    public void beforeFirst() throws SQLException {
        DBDSResultSet.throwUnsupported("beforeFirst()");
    }

    public void afterLast() throws SQLException {
        DBDSResultSet.throwUnsupported("afterLast()");
    }

    public boolean first() throws SQLException {
        DBDSResultSet.throwUnsupported("first()");
        return false;
    }

    public boolean last() throws SQLException {
        DBDSResultSet.throwUnsupported("last()");
        return false;
    }

    public int getRow() throws SQLException {
        DBDSResultSet.throwUnsupported("getRow()");
        return 0;
    }

    public boolean absolute(int row) throws SQLException {
        DBDSResultSet.throwUnsupported("absolute()");
        return false;
    }

    public boolean relative(int rows) throws SQLException {
        DBDSResultSet.throwUnsupported("relative()");
        return false;
    }

    public boolean previous() throws SQLException {
        DBDSResultSet.throwUnsupported("previous()");
        return false;
    }

    public void setFetchDirection(int direction) throws SQLException {
        DBDSResultSet.throwUnsupported("setFetchDirection()");
    }

    public int getFetchDirection() throws SQLException {
        DBDSResultSet.throwUnsupported("getFetchDirection()");
        return 0;
    }

    public void setFetchSize(int rows) throws SQLException {
        DBDSResultSet.throwUnsupported("setFetchSize()");
    }

    public int getFetchSize() throws SQLException {
        DBDSResultSet.throwUnsupported("getFetchSize()");
        return 0;
    }

    public int getType() throws SQLException {
        DBDSResultSet.throwUnsupported("getType()");
        return 0;
    }

    public int getConcurrency() throws SQLException {
        DBDSResultSet.throwUnsupported("getConcurrency()");
        return 0;
    }

    public boolean rowUpdated() throws SQLException {
        DBDSResultSet.throwUnsupported("rowUpdated()");
        return false;
    }

    public boolean rowInserted() throws SQLException {
        DBDSResultSet.throwUnsupported("rowInserted()");
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        DBDSResultSet.throwUnsupported("rowDeleted()");
        return false;
    }

    public void updateNull(int columnIndex) throws SQLException {
        DBDSResultSet.throwUnsupported("updateNull()");
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        DBDSResultSet.throwUnsupported("updateBoolean()");
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        DBDSResultSet.throwUnsupported("updateByte()");
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        DBDSResultSet.throwUnsupported("updateShort()");
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        DBDSResultSet.throwUnsupported("updateInt()");
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        DBDSResultSet.throwUnsupported("updateLong()");
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        DBDSResultSet.throwUnsupported("updateFloat()");
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        DBDSResultSet.throwUnsupported("updateDouble()");
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        DBDSResultSet.throwUnsupported("updateBigDecimal()");
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        DBDSResultSet.throwUnsupported("updateString()");
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        DBDSResultSet.throwUnsupported("updateBytes()");
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        DBDSResultSet.throwUnsupported("updateDate()");
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        DBDSResultSet.throwUnsupported("updateTime()");
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        DBDSResultSet.throwUnsupported("updateTimestamp()");
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        DBDSResultSet.throwUnsupported("updateAsciiStream()");
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        DBDSResultSet.throwUnsupported("updateBinaryStream()");
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        DBDSResultSet.throwUnsupported("updateCharacterStream()");
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        DBDSResultSet.throwUnsupported("updateObject()");
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        DBDSResultSet.throwUnsupported("updateObjec()");
    }

    public void updateNull(String columnName) throws SQLException {
        DBDSResultSet.throwUnsupported("updateNull()");
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        DBDSResultSet.throwUnsupported("updateBoolean()");
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        DBDSResultSet.throwUnsupported("updateByte()");
    }

    public void updateShort(String columnName, short x) throws SQLException {
        DBDSResultSet.throwUnsupported("updateShort()");
    }

    public void updateInt(String columnName, int x) throws SQLException {
        DBDSResultSet.throwUnsupported("updateInt()");
    }

    public void updateLong(String columnName, long x) throws SQLException {
        DBDSResultSet.throwUnsupported("updateLong()");
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        DBDSResultSet.throwUnsupported("updateFloat()");
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        DBDSResultSet.throwUnsupported("updateDouble()");
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        DBDSResultSet.throwUnsupported("updateBigDecimal()");
    }

    public void updateString(String columnName, String x) throws SQLException {
        DBDSResultSet.throwUnsupported("updateString()");
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        DBDSResultSet.throwUnsupported("updateBytes()");
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        DBDSResultSet.throwUnsupported("updateDate()");
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        DBDSResultSet.throwUnsupported("updateTime()");
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        DBDSResultSet.throwUnsupported("updateTimestamp()");
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        DBDSResultSet.throwUnsupported("updateAsciiStream()");
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        DBDSResultSet.throwUnsupported("updateBinaryStream()");
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        DBDSResultSet.throwUnsupported("updateCharacterStream()");
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        DBDSResultSet.throwUnsupported("updateObject()");
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        DBDSResultSet.throwUnsupported("updateObject()");
    }

    public void insertRow() throws SQLException {
        DBDSResultSet.throwUnsupported("insertRow()");
    }

    public void updateRow() throws SQLException {
        DBDSResultSet.throwUnsupported("updateRow()");
    }

    public void deleteRow() throws SQLException {
        DBDSResultSet.throwUnsupported("deleteRow()");
    }

    public void refreshRow() throws SQLException {
        DBDSResultSet.throwUnsupported("refreshRow()");
    }

    public void cancelRowUpdates() throws SQLException {
        DBDSResultSet.throwUnsupported("cancelRowUpdates()");
    }

    public void moveToInsertRow() throws SQLException {
        DBDSResultSet.throwUnsupported("moveToInsertRow()");
    }

    public void moveToCurrentRow() throws SQLException {
        DBDSResultSet.throwUnsupported("moveToCurrentRow()");
    }

    public Statement getStatement() throws SQLException {
        DBDSResultSet.throwUnsupported("getStatement()");
        return null;
    }

    public Object getObject(int i, Map map) throws SQLException {
        DBDSResultSet.throwUnsupported("getObject(int i, Map map)");
        return null;
    }

    public Ref getRef(int i) throws SQLException {
        DBDSResultSet.throwUnsupported("getRef()");
        return null;
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        DBDSResultSet.throwUnsupported("getBlob()");
        return null;
    }

    public Clob getClob(int columnIndex) throws SQLException {
        DBDSResultSet.throwUnsupported("getClob()");
        return null;
    }

    public Array getArray(int i) throws SQLException {
        DBDSResultSet.throwUnsupported("getArray()");
        return null;
    }

    public Object getObject(int columnIndex) throws SQLException {
        DBDSResultSet.throwUnsupported("getObject()");
        return null;
    }

    public Object getObject(String columnName) throws SQLException {
        DBDSResultSet.throwUnsupported("getObject()");
        return null;
    }

    public Object getObject(String colName, Map map) throws SQLException {
        DBDSResultSet.throwUnsupported("getObject()");
        return null;
    }

    public Ref getRef(String colName) throws SQLException {
        DBDSResultSet.throwUnsupported("getRef()");
        return null;
    }

    public Blob getBlob(String colName) throws SQLException {
        DBDSResultSet.throwUnsupported("getBlob()");
        return null;
    }

    public Clob getClob(String colName) throws SQLException {
        DBDSResultSet.throwUnsupported("getClob()");
        return null;
    }

    public Array getArray(String colName) throws SQLException {
        DBDSResultSet.throwUnsupported("getArray()");
        return null;
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        DBDSResultSet.throwUnsupported("getDate(int columnIndex, Calendar cal)");
        return null;
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        DBDSResultSet.throwUnsupported("getDate()");
        return null;
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        DBDSResultSet.throwUnsupported("getTime(int columnIndex, Calendar cal)");
        return null;
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        DBDSResultSet.throwUnsupported("getTime()");
        return null;
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        DBDSResultSet.throwUnsupported("getTimestamp(int columnIndex, Calendar cal)");
        return null;
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        DBDSResultSet.throwUnsupported("getTimestamp()");
        return null;
    }

    private void setOutParams(int position, int lng, int jdbcType) {
        String str = null;
        byte[] ba = null;
        int length = lng;
        DBDSParamDescription pd = new DBDSParamDescription(jdbcType);
        switch (jdbcType) {
            case 12: 
            case 2005: {
                if (jdbcType == 2005) {
                    length = 32768;
                }
                StringBuffer strBuf = new StringBuffer(length);
                int i = 0;
                while (i < length) {
                    strBuf.insert(i, ' ');
                    ++i;
                }
                str = new String(strBuf);
                pd.setStringParam(str);
                break;
            }
            case -3: 
            case 2004: {
                if (jdbcType == 2004) {
                    length = 65536;
                }
                ba = new byte[length];
                pd.setByteParam(ba);
                break;
            }
            case 5: {
                pd.setShortParam((short)0);
                break;
            }
            case 4: {
                pd.setIntParam(0);
                break;
            }
            case -5: {
                pd.setLongParam(0L);
                break;
            }
            case 8: {
                pd.setDoubleParam(0.0);
                break;
            }
        }
        this.outParams[position] = pd;
    }

    private static void throwUnsupported(String method) {
        throw new UnsupportedOperationException("Method " + method + " not supported by DBDS JDBC");
    }
}

