/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.dbds;

import com.sap.sql.jdbc.ExtendedPreparedStatement;
import com.sap.sql.jdbc.dbds.DBDSAccess;
import com.sap.sql.jdbc.dbds.DBDSParamDescription;
import com.sap.sql.jdbc.dbds.DBDSResultSet;
import com.sap.sql.jdbc.dbds.DBDSStatement;
import com.sap.sql.trace.TraceContext;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;

public class DBDSPreparedStatement
extends DBDSStatement
implements ExtendedPreparedStatement {
    private String sql;
    private DBDSParamDescription[] inParams;

    public DBDSPreparedStatement(Connection conn, String sql) throws SQLException {
        super(conn);
        this.sql = sql;
        int[] markerPos = this.getMarkerPos(sql);
        this.inParams = new DBDSParamDescription[markerPos.length];
        DBDSAccess.dbdsPrepare(sql, markerPos);
    }

    public ResultSet executeQuery() throws SQLException {
        DBDSAccess.dbdsExecuteQuery(this.inParams);
        this.rs = new DBDSResultSet();
        return this.rs;
    }

    public int executeUpdate() throws SQLException {
        this.updCount = DBDSAccess.dbdsExecuteUpdate(this.inParams);
        return this.updCount;
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        DBDSParamDescription pd = new DBDSParamDescription(12);
        pd.setStringParam(x);
        this.inParams[parameterIndex - 1] = pd;
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        DBDSParamDescription pd = new DBDSParamDescription(-3);
        pd.setByteParam(x);
        this.inParams[parameterIndex - 1] = pd;
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        DBDSParamDescription pd = new DBDSParamDescription(5);
        pd.setShortParam(x);
        this.inParams[parameterIndex - 1] = pd;
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        DBDSParamDescription pd = new DBDSParamDescription(4);
        pd.setIntParam(x);
        this.inParams[parameterIndex - 1] = pd;
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        DBDSParamDescription pd = new DBDSParamDescription(-5);
        pd.setLongParam(x);
        this.inParams[parameterIndex - 1] = pd;
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        DBDSParamDescription pd = new DBDSParamDescription(8);
        pd.setDoubleParam(x);
        this.inParams[parameterIndex - 1] = pd;
    }

    public void close() throws SQLException {
        super.close();
        this.sql = null;
        this.inParams = null;
    }

    public boolean execute(TraceContext traceContext) throws SQLException {
        DBDSStatement.throwUnsupported("execute(TraceContext)");
        return false;
    }

    public ResultSet executeQuery(TraceContext traceContext) throws SQLException {
        return this.executeQuery();
    }

    public int executeUpdate(TraceContext traceContext) throws SQLException {
        return this.executeUpdate();
    }

    public int[] executeBatch(TraceContext traceContext) throws SQLException {
        DBDSStatement.throwUnsupported("executeBatch(TraceContext)");
        return null;
    }

    public boolean execute() throws SQLException {
        DBDSStatement.throwUnsupported("execute");
        return false;
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        DBDSStatement.throwUnsupported("setByte");
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        DBDSStatement.throwUnsupported("setFloat");
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        DBDSStatement.throwUnsupported("setBigDecimal");
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        DBDSStatement.throwUnsupported("setNull");
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        DBDSStatement.throwUnsupported("setBoolean");
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        DBDSStatement.throwUnsupported("setBinaryStream");
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        DBDSStatement.throwUnsupported("setCharacterStream");
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        DBDSStatement.throwUnsupported("setDate");
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        DBDSStatement.throwUnsupported("setTime");
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        DBDSStatement.throwUnsupported("setTimestamp");
    }

    public void setBlob(int i, Blob x) throws SQLException {
        DBDSStatement.throwUnsupported("setBlob");
    }

    public void setClob(int i, Clob x) throws SQLException {
        DBDSStatement.throwUnsupported("setClob");
    }

    public void clearParameters() throws SQLException {
        DBDSStatement.throwUnsupported("clearParameters");
    }

    public void addBatch() throws SQLException {
        DBDSStatement.throwUnsupported("addBatch");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        DBDSStatement.throwUnsupported("getMetaData");
        return null;
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        DBDSStatement.throwUnsupported("setAsciiStream");
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        DBDSStatement.throwUnsupported("setUnicodeStream");
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        DBDSStatement.throwUnsupported("setObject");
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        DBDSStatement.throwUnsupported("setObject");
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        DBDSStatement.throwUnsupported("setObject");
    }

    public void setRef(int i, Ref x) throws SQLException {
        DBDSStatement.throwUnsupported("setRef");
    }

    public void setArray(int i, Array x) throws SQLException {
        DBDSStatement.throwUnsupported("setArray");
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        DBDSStatement.throwUnsupported("setDate");
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        DBDSStatement.throwUnsupported("setTime");
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        DBDSStatement.throwUnsupported("setTimestamp");
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        DBDSStatement.throwUnsupported("setNull");
    }

    private int[] getMarkerPos(String sql) throws SQLException {
        ArrayList<Integer> alist = new ArrayList<Integer>();
        char[] c_arr = sql.toCharArray();
        int i = 0;
        while (i < sql.length()) {
            if (c_arr[i] == '?') {
                alist.add(new Integer(i));
            }
            ++i;
        }
        int[] marker_arr = new int[alist.size()];
        int i2 = 0;
        while (i2 < alist.size()) {
            marker_arr[i2] = (Integer)alist.get(i2);
            ++i2;
        }
        return marker_arr;
    }
}

