/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.dbds;

import com.sap.sql.jdbc.ConnectionContext;
import com.sap.sql.jdbc.ConnectionWrapper;
import com.sap.sql.jdbc.ContextFactory;
import com.sap.sql.jdbc.DataSourceContext;
import com.sap.sql.jdbc.ExtendedConnection;
import com.sap.sql.jdbc.dbds.DBDSAccess;
import com.sap.sql.jdbc.dbds.DBDSDatabaseMetaData;
import com.sap.sql.jdbc.dbds.DBDSPreparedStatement;
import com.sap.sql.jdbc.dbds.DBDSStatement;
import com.sap.sql.trace.TraceContext;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;

public class DBDSConnection
implements Connection,
ConnectionWrapper,
ExtendedConnection {
    private boolean connected = false;
    private ConnectionContext connCtx;

    public DBDSConnection(String connectionName) throws SQLException {
        if (!this.connected) {
            DBDSAccess.dbdsConnect();
            this.connected = true;
            ContextFactory factory = new ContextFactory();
            DataSourceContext dsCtx = ContextFactory.createDataSourceContext(connectionName, null, null, null, 5, "ORACLE", 3);
            this.connCtx = factory.createConnectionContext(dsCtx);
            factory.setConnection(this);
            factory.setWrappedConnection(null);
            factory.setConnectionID(connectionName + "?SAPR3");
            factory.setProperties(null);
            factory.setAutoCommit(false);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connCtx;
    }

    public Statement createStatement() throws SQLException {
        return new DBDSStatement(this);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new DBDSPreparedStatement(this, sql);
    }

    public PreparedStatement prepareStatement(String sql, TraceContext traceContext) throws SQLException {
        return this.prepareStatement(sql);
    }

    public void commit() throws SQLException {
        DBDSAccess.dbdsCommit();
    }

    public void rollback() throws SQLException {
        DBDSAccess.dbdsRollback();
    }

    public void close() throws SQLException {
        if (this.connected) {
            DBDSAccess.dbdsDisconnect();
        }
        this.connected = false;
    }

    public boolean isClosed() throws SQLException {
        return this.connected;
    }

    public boolean getAutoCommit() throws SQLException {
        return this.connCtx.getAutoCommit();
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return new DBDSDatabaseMetaData();
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        DBDSConnection.throwUnsupported("prepareCall");
        return null;
    }

    public String nativeSQL(String sql) throws SQLException {
        DBDSConnection.throwUnsupported("nativeSQL");
        return null;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        DBDSConnection.throwUnsupported("setAutoCommit");
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        DBDSConnection.throwUnsupported("setReadOnly");
    }

    public void setCatalog(String catalog) throws SQLException {
        DBDSConnection.throwUnsupported("setCatalog");
    }

    public String getCatalog() throws SQLException {
        DBDSConnection.throwUnsupported("getCatalog");
        return null;
    }

    public void setTransactionIsolation(int level) throws SQLException {
        DBDSConnection.throwUnsupported("setTransactionIsolation");
    }

    public int getTransactionIsolation() throws SQLException {
        DBDSConnection.throwUnsupported("getTransactionIsolation");
        return 0;
    }

    public SQLWarning getWarnings() throws SQLException {
        DBDSConnection.throwUnsupported("getWarnings");
        return null;
    }

    public void clearWarnings() throws SQLException {
        DBDSConnection.throwUnsupported("clearWarnings");
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        DBDSConnection.throwUnsupported("createStatement");
        return null;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        DBDSConnection.throwUnsupported("prepareStatement");
        return null;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        DBDSConnection.throwUnsupported("prepareCall");
        return null;
    }

    public Map getTypeMap() throws SQLException {
        DBDSConnection.throwUnsupported("getTypeMap");
        return null;
    }

    public void setTypeMap(Map map) throws SQLException {
        DBDSConnection.throwUnsupported("setTypeMap");
    }

    private static void throwUnsupported(String method) {
        throw new UnsupportedOperationException("Method " + method + "() not supported by DBDS JDBC");
    }
}

