/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.db6;

import com.sap.sql.jdbc.basic.BasicDbPortingServices;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;

public class Db6PortingServices
extends BasicDbPortingServices {
    private PreparedStatement utcTimeStmt = null;

    public Db6PortingServices(Connection con) {
        super(con);
    }

    public String getConnectionID() throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        String conid = null;
        stmt = this.connection.createStatement();
        rs = stmt.executeQuery("SELECT RTRIM( CHAR( CURRENT SERVER ) ) || '-' || RTRIM( CHAR( CURRENT SCHEMA ) ) || '-' || SUBSTR( CHAR( CREATE_TIME ) , 9 , 17 ) FROM SYSCAT.TABLES WHERE TABSCHEMA = 'SYSCAT' AND TABNAME = 'TRIGGERS' ");
        rs.next();
        conid = rs.getString(1);
        rs.close();
        stmt.close();
        return conid;
    }

    public Timestamp getUTCTimestamp() throws SQLException {
        ResultSet rs;
        if (this.utcTimeStmt == null) {
            this.utcTimeStmt = this.connection.prepareStatement("VALUES(CURRENT TIMESTAMP - CURRENT TIMEZONE)");
        }
        if (!(rs = this.utcTimeStmt.executeQuery()).next()) {
            throw new SQLException("Failed to get UTC timestamp on DB server");
        }
        Timestamp ts = rs.getTimestamp(1, this.utcCalendar);
        rs.close();
        return ts;
    }

    public String getDatabaseProductName() throws SQLException {
        return this.connection.getMetaData().getDatabaseProductName();
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.connection.getMetaData().getDatabaseProductVersion();
    }

    public String getUserName() throws SQLException {
        Statement stmt = null;
        String userName = null;
        stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery("values( RTRIM( USER ) )");
        if (rs.next()) {
            userName = rs.getString(1);
        }
        rs.close();
        stmt.close();
        return userName;
    }

    public String getSchemaName() throws SQLException {
        Statement stmt = null;
        String schemaName = null;
        stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery("values( RTRIM( CURRENT SCHEMA ) )");
        if (rs.next()) {
            schemaName = rs.getString(1);
        }
        rs.close();
        stmt.close();
        return schemaName;
    }

    public String getDatabaseName() throws SQLException {
        Statement stmt = null;
        String dbName = null;
        stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery("values( RTRIM( CURRENT SERVER ) )");
        if (rs.next()) {
            dbName = rs.getString(1);
        }
        rs.close();
        stmt.close();
        return dbName;
    }

    public String getDatabaseHost() throws SQLException {
        String dbHost = null;
        String url = this.connection.getMetaData().getURL();
        if (url != null && url.startsWith("jdbc:db2://") && url.substring(11).indexOf(58) != -1) {
            dbHost = url.substring(11, url.substring(11).indexOf(58) + 11);
        }
        return dbHost;
    }

    public int getVendorID() {
        return 0;
    }

    public Boolean isDatabaseKernel64Bit() throws SQLException {
        String product = this.connection.getMetaData().getDatabaseProductName();
        if (product.startsWith("DB2")) {
            if (product.indexOf("64") > 0) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    public boolean selectAllocatesResources(int transactionIsolationLevel) {
        return true;
    }
}

