/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.db4;

import com.sap.sql.jdbc.basic.BasicJdbcObjectFactory;
import com.sap.sql.jdbc.basic.BasicResultSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class Db4ResultSet
extends BasicResultSet {
    public Db4ResultSet(BasicJdbcObjectFactory aFactory, Statement statement, ResultSet resultSet) throws SQLException {
        super(aFactory, statement, resultSet);
    }

    public Db4ResultSet(BasicJdbcObjectFactory aFactory, ResultSet resultSet) throws SQLException {
        this(aFactory, null, resultSet);
    }

    public byte getByte(int columnIndex) throws SQLException {
        long longResult = super.getLong(columnIndex);
        if (longResult <= 127L && longResult >= -128L) {
            return (byte)longResult;
        }
        throw new SQLException("Db4ResultSet.getByte: Data truncation. Value " + longResult + " out of range.", "SAP_DB4_NUMERIC_OVERFLOW", -99998);
    }

    public short getShort(int columnIndex) throws SQLException {
        long longResult = super.getLong(columnIndex);
        if (longResult <= 32767L && longResult >= -32768L) {
            return (short)longResult;
        }
        throw new SQLException("Db4ResultSet.getShort: Data truncation. Value " + longResult + " out of range.", "SAP_DB4_NUMERIC_OVERFLOW", -99998);
    }

    public int getInt(int columnIndex) throws SQLException {
        long longResult = super.getLong(columnIndex);
        if (longResult <= Integer.MAX_VALUE && longResult >= Integer.MIN_VALUE) {
            return (int)longResult;
        }
        throw new SQLException("Db4ResultSet.getInt: Data truncation. Value " + longResult + " out of range.", "SAP_DB4_NUMERIC_OVERFLOW", -99998);
    }

    public byte getByte(String columnName) throws SQLException {
        long longResult = super.getLong(columnName);
        if (longResult <= 127L && longResult >= -128L) {
            return (byte)longResult;
        }
        throw new SQLException("Db4ResultSet.getByte: Data truncation. Value " + longResult + " out of range.", "SAP_DB4_NUMERIC_OVERFLOW", -99998);
    }

    public short getShort(String columnName) throws SQLException {
        long longResult = super.getLong(columnName);
        if (longResult <= 32767L && longResult >= -32768L) {
            return (short)longResult;
        }
        throw new SQLException("Db4ResultSet.getShort: Data truncation. Value " + longResult + " out of range.", "SAP_DB4_NUMERIC_OVERFLOW", -99998);
    }

    public int getInt(String columnName) throws SQLException {
        long longResult = super.getLong(columnName);
        if (longResult <= Integer.MAX_VALUE && longResult >= Integer.MIN_VALUE) {
            return (int)longResult;
        }
        throw new SQLException("Db4ResultSet.getInt: Data truncation. Value " + longResult + " out of range.", "SAP_DB4_NUMERIC_OVERFLOW", -99998);
    }
}

