/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.db4;

import com.sap.sql.jdbc.basic.BasicDbPortingServices;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;

public abstract class Db4PortingServices
extends BasicDbPortingServices {
    private PreparedStatement utcTimeStmt = null;

    public Db4PortingServices(Connection connection) {
        super(connection);
    }

    public String getConnectionID() throws SQLException {
        String dbHostName = this.getDatabaseHost();
        String dbName = this.getDatabaseName();
        String dbSchemaName = this.getSchemaName();
        String conId = dbHostName + "?" + dbName + "?" + dbSchemaName;
        if (dbHostName == null || dbName == null || dbSchemaName == null) {
            throw new SQLException("Db4PortingServices: Failed to determine connection ID.  - Maybe current library is not an sql collection.(" + conId + ")", "SAP_DB4_DB_ADMINISTRATOR_REQUIRED", -99998);
        }
        return conId;
    }

    public Timestamp getUTCTimestamp() throws SQLException {
        ResultSet rs;
        if (this.utcTimeStmt == null) {
            this.utcTimeStmt = this.connection.prepareStatement("SELECT CURRENT TIMESTAMP - CURRENT TIMEZONE FROM SYSTABLES");
        }
        if (!(rs = this.utcTimeStmt.executeQuery()).next()) {
            throw new SQLException("Db4PortingServices: Failed to get UTC timestamp on DB server - Maybe current library is not an sql collection.", "SAP_DB4_DB_ADMINISTRATOR_REQUIRED", -99998);
        }
        Timestamp ts = rs.getTimestamp(1, this.utcCalendar);
        rs.close();
        return ts;
    }

    public String getDatabaseProductName() throws SQLException {
        return "DB2 UDB for AS/400";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getUserName() throws SQLException {
        Statement stmt;
        String userName;
        block9: {
            userName = null;
            stmt = null;
            ResultSet rs = null;
            String stmtStr = "SELECT USER FROM SYSTABLES";
            try {
                try {
                    stmt = this.connection.createStatement();
                    rs = stmt.executeQuery(stmtStr);
                    if (rs.next()) {
                        userName = rs.getString(1).trim();
                    }
                }
                catch (SQLException e) {
                    if (e.getErrorCode() != -204) {
                        throw e;
                    }
                    Object var7_6 = null;
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt == null) return userName;
                    stmt.close();
                    return userName;
                }
                Object var7_5 = null;
                if (rs == null) break block9;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (rs != null) {
                    rs.close();
                }
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            rs.close();
        }
        if (stmt == null) return userName;
        stmt.close();
        return userName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getSchemaName() throws SQLException {
        Statement stmt;
        String dbSchema;
        block9: {
            dbSchema = null;
            stmt = null;
            ResultSet rs = null;
            String stmtStr = "SELECT TABLE_SCHEMA FROM SYSVIEWS WHERE TABLE_NAME = 'SYSTABLES'";
            try {
                try {
                    stmt = this.connection.createStatement();
                    rs = stmt.executeQuery(stmtStr);
                    if (rs.next()) {
                        dbSchema = rs.getString(1).trim();
                    }
                }
                catch (SQLException e) {
                    if (e.getErrorCode() != -204) {
                        throw e;
                    }
                    Object var7_6 = null;
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt == null) return dbSchema;
                    stmt.close();
                    return dbSchema;
                }
                Object var7_5 = null;
                if (rs == null) break block9;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (rs != null) {
                    rs.close();
                }
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            rs.close();
        }
        if (stmt == null) return dbSchema;
        stmt.close();
        return dbSchema;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDatabaseName() throws SQLException {
        PreparedStatement ps;
        String databaseName;
        block18: {
            ResultSet rs;
            int iaspNum;
            block16: {
                Statement stmt;
                block17: {
                    databaseName = null;
                    iaspNum = -1;
                    String stmtStr1 = "SELECT IASP_NUMBER FROM SYSVIEWS WHERE TABLE_NAME = 'SYSTABLES'";
                    stmt = null;
                    rs = null;
                    try {
                        block15: {
                            try {
                                stmt = this.connection.createStatement();
                                rs = stmt.executeQuery(stmtStr1);
                                if (!rs.next()) break block15;
                                iaspNum = rs.getInt(1);
                            }
                            catch (SQLException e) {
                                if (e.getErrorCode() != -204) {
                                    if (e.getErrorCode() != -206) throw e;
                                    iaspNum = 0;
                                }
                                Object var8_7 = null;
                                if (rs != null) {
                                    rs.close();
                                }
                                if (stmt != null) {
                                    stmt.close();
                                }
                                break block16;
                            }
                        }
                        Object var8_6 = null;
                        if (rs == null) break block17;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt == null) throw throwable;
                        stmt.close();
                        throw throwable;
                    }
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            String stmtStr2 = "SELECT CATALOG_ASPGRP FROM QSYS2.LOCATIONS WHERE CATALOG_ASPNUM = ?";
            ps = null;
            if (iaspNum == -1) {
                return null;
            }
            if (iaspNum == 0) {
                return "*SYSBAS";
            }
            try {
                ps = this.connection.prepareStatement(stmtStr2);
                ps.setInt(1, iaspNum);
                rs = ps.executeQuery();
                if (rs.next()) {
                    databaseName = rs.getString(1).trim();
                }
                Object var10_13 = null;
                if (rs == null) break block18;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                if (rs != null) {
                    rs.close();
                }
                if (ps == null) throw throwable;
                ps.close();
                throw throwable;
            }
            rs.close();
        }
        if (ps == null) return databaseName;
        ps.close();
        return databaseName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDatabaseHost() throws SQLException {
        Statement stmt;
        String dbHostName;
        block12: {
            dbHostName = null;
            stmt = null;
            ResultSet rs = null;
            String stmtStr = "SELECT CATALOG_NAME FROM QSYS2.LOCATIONS  WHERE CATALOG_ASPNUM IS NULL AND CATALOG_TYPE = 'LOCAL'";
            String fallbackStmtStr = "SELECT CURRENT SERVER FROM SYSTABLES";
            try {
                try {
                    stmt = this.connection.createStatement();
                    rs = stmt.executeQuery(stmtStr);
                    if (rs.next()) {
                        dbHostName = rs.getString(1).trim();
                    }
                }
                catch (SQLException e) {
                    block11: {
                        if (e.getErrorCode() != -204) throw e;
                        try {
                            rs = stmt.executeQuery(fallbackStmtStr);
                            if (rs.next()) {
                                dbHostName = rs.getString(1).trim();
                            }
                        }
                        catch (SQLException sqle) {
                            if (sqle.getErrorCode() == -204) break block11;
                            throw e;
                        }
                    }
                    Object var9_7 = null;
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt == null) return dbHostName;
                    stmt.close();
                    return dbHostName;
                }
                Object var9_6 = null;
                if (rs == null) break block12;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                if (rs != null) {
                    rs.close();
                }
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            rs.close();
        }
        if (stmt == null) return dbHostName;
        stmt.close();
        return dbHostName;
    }

    public int getVendorID() {
        return 1;
    }

    public Boolean isDatabaseKernel64Bit() throws SQLException {
        return Boolean.TRUE;
    }

    public boolean selectAllocatesResources(int transactionIsolationLevel) {
        return true;
    }
}

