/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.db2;

import com.sap.sql.jdbc.basic.SQLExceptionAnalyzer;
import java.sql.Connection;
import java.sql.SQLException;

public class Db2SQLExceptionAnalyzer
extends SQLExceptionAnalyzer {
    public Db2SQLExceptionAnalyzer(Connection con) {
        super(con);
    }

    public int getCategory(SQLException exception) {
        if (exception == null) {
            return 7;
        }
        int category = 0;
        SQLException ex = exception;
        while (ex != null) {
            int dbcode = ex.getErrorCode();
            switch (dbcode) {
                case -30082: 
                case -30081: 
                case -30080: 
                case -30041: 
                case -30040: 
                case -30030: 
                case -30021: 
                case -30020: 
                case -30000: 
                case -924: 
                case -923: {
                    return 9;
                }
                case -904: 
                case -677: 
                case -670: 
                case -647: 
                case -626: 
                case -621: 
                case -619: 
                case -327: 
                case 162: 
                case 610: {
                    category = 8;
                    break;
                }
                case -601: {
                    if (category >= 5) break;
                    category = 5;
                    break;
                }
                case -204: {
                    if (category >= 4) break;
                    category = 4;
                    break;
                }
                case -206: 
                case -205: {
                    if (category >= 3) break;
                    category = 3;
                    break;
                }
                case -803: {
                    if (category >= 1) break;
                    category = 1;
                    break;
                }
                case -913: {
                    if (category >= 6) break;
                    category = 6;
                    break;
                }
                case -802: {
                    if (category >= 2) break;
                    category = 2;
                    break;
                }
                case -99999: {
                    String msg = ex.getMessage();
                    if (null != msg && msg.startsWith("Invalid data conversion:Requested conversion would result in a loss of precision")) {
                        if (category >= 2) break;
                        category = 2;
                        break;
                    }
                    if (category >= 7) break;
                    category = 7;
                    break;
                }
                default: {
                    if (dbcode >= 0 || category != 0) break;
                    category = 7;
                }
            }
            ex = ex.getNextException();
        }
        return category;
    }
}

