/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.db2;

import com.sap.sql.jdbc.basic.BasicDbPortingServices;
import com.sap.sql.jdbc.basic.DbPortingFactory;
import com.sap.sql.jdbc.basic.SQLExceptionAnalyzer;
import com.sap.sql.jdbc.db2.Db2Connection;
import com.sap.sql.jdbc.db2.Db2PortingServices;
import com.sap.sql.jdbc.db2.Db2SQLExceptionAnalyzer;
import java.sql.Connection;
import java.sql.SQLException;

public class Db2PortingFactory
implements DbPortingFactory {
    public boolean isJdbcDriverSupported(Connection connection) throws SQLException {
        return connection.getMetaData().getDriverName().equals("IBM DB2 JDBC Universal Driver Architecture");
    }

    public Connection createPortedConnection(Connection connection) throws SQLException {
        return new Db2Connection(connection);
    }

    public BasicDbPortingServices createDbPortingServices(Connection connection) throws SQLException {
        return new Db2PortingServices(connection);
    }

    public SQLExceptionAnalyzer createSQLExceptionAnalyzer(Connection connection) throws SQLException {
        return new Db2SQLExceptionAnalyzer(connection);
    }
}

