/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.common;

import com.sap.exception.standard.SAPIllegalArgumentException;
import com.sap.sql.jdbc.common.CommonBlob;
import com.sap.sql.log.Syslog;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;

public class CommonWrappedBlob
extends CommonBlob {
    private Blob wrappedBlob;

    CommonWrappedBlob(Blob aBlob, Connection aConnection) {
        super(aConnection);
        if (null == aBlob) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0001", new Object[]{"aBlob"});
        }
        this.wrappedBlob = aBlob;
    }

    public long length() throws SQLException {
        return this.wrappedBlob.length();
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        if (!this.used) {
            this.used = true;
            return this.wrappedBlob.getBytes(pos, length);
        }
        throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1120", new Object[]{"BLOB"});
    }

    public InputStream getBinaryStream() throws SQLException {
        if (!this.used) {
            this.used = true;
            return this.wrappedBlob.getBinaryStream();
        }
        throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1120", new Object[]{"BLOB"});
    }
}

