/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.common;

import com.sap.sql.jdbc.common.CommonClientPreparedStatement;
import com.sap.sql.jdbc.common.CommonClientStatementImpl;
import com.sap.sql.jdbc.common.CommonConnectionContext;
import com.sap.sql.jdbc.common.CommonConnectionImpl;
import com.sap.sql.jdbc.common.CommonDatabaseMetaData;
import com.sap.sql.sqlparser.CommonClientSQLStatement;
import com.sap.sql.sqlparser.CommonSQLParserException;
import com.sap.sql.trace.SQLTraceContext;
import com.sap.sql.tree.SQLStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class CommonClientConnectionImpl
extends CommonConnectionImpl {
    public CommonClientConnectionImpl(CommonConnectionContext connectionContext) throws SQLException {
        super(connectionContext);
    }

    public Statement createStatement() throws SQLException {
        return new CommonClientStatementImpl(this.connectionContext);
    }

    public SQLStatement preprepareStatement(String sql) throws SQLException {
        CommonClientSQLStatement css;
        try {
            css = new CommonClientSQLStatement(sql);
            css.checkSemantics(this.connectionContext.getCatalogReader());
        }
        catch (CommonSQLParserException e) {
            throw new SQLException(e.getMessage());
        }
        return css.getSQLStatement();
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        CommonClientPreparedStatement stmt = new CommonClientPreparedStatement(this.connectionContext, sql, new SQLTraceContext());
        return stmt;
    }

    public PreparedStatement prepareStatement(SQLStatement tree) throws SQLException {
        CommonClientPreparedStatement stmt = new CommonClientPreparedStatement(this.connectionContext, tree);
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql, String source, int line, long timestamp) throws SQLException {
        return new CommonClientPreparedStatement(this.connectionContext, sql, new SQLTraceContext(timestamp, source, line));
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return new CommonDatabaseMetaData(this);
    }
}

