/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.common;

import com.sap.sql.jdbc.ExtendedStatement;
import com.sap.sql.jdbc.common.CommonConnectionContext;
import com.sap.sql.jdbc.common.CommonConnectionImpl;
import com.sap.sql.jdbc.common.CommonResultSet;
import com.sap.sql.jdbc.common.CommonResultSetForUpdate;
import com.sap.sql.jdbc.common.CommonResultSetMetaData;
import com.sap.sql.log.Syslog;
import com.sap.sql.services.core.CoreServices;
import com.sap.sql.tablebuffer.BufferManager;
import com.sap.sql.tabstat.TableStatistics;
import com.sap.sql.tree.DeleteStatement;
import com.sap.sql.tree.GeneralSelectStatement;
import com.sap.sql.tree.InsertStatement;
import com.sap.sql.tree.Query;
import com.sap.sql.tree.QuerySpecification;
import com.sap.sql.tree.SQLStatement;
import com.sap.sql.tree.TableReference;
import com.sap.sql.tree.UpdateStatement;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public abstract class AbstractCommonStatement
implements Statement {
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$jdbc$common$AbstractCommonStatement == null ? (class$com$sap$sql$jdbc$common$AbstractCommonStatement = AbstractCommonStatement.class$("com.sap.sql.jdbc.common.AbstractCommonStatement")) : class$com$sap$sql$jdbc$common$AbstractCommonStatement));
    protected CommonConnectionContext connectionContext;
    protected CommonConnectionImpl commonConnection;
    protected BufferManager bufferManager;
    protected boolean pedanticTypeChecking = false;
    protected ExtendedStatement wrappedDbStmt = null;
    protected ExtendedStatement wrappedBufStmt = null;
    protected SQLStatement stmtTree = null;
    protected ResultSet resultSet = null;
    protected int updateCount = -1;
    private String stmtString = null;
    private boolean isClosed = false;
    private int maxRows = 0;
    static /* synthetic */ Class class$com$sap$sql$jdbc$common$AbstractCommonStatement;

    protected AbstractCommonStatement(CommonConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.commonConnection = (CommonConnectionImpl)connectionContext.getConnection();
        this.bufferManager = connectionContext.getBufferManager();
        this.pedanticTypeChecking = connectionContext.getCatalogReader().isLogicalCatalogReader();
    }

    public final void close() throws SQLException {
        this.close(true);
    }

    public final void cancel() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "cancel()");
    }

    public final int getMaxFieldSize() throws SQLException {
        this.validate();
        return 0;
    }

    public final void setMaxFieldSize(int max) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "setMaxFieldSize(int)");
    }

    public final int getMaxRows() throws SQLException {
        this.validate();
        if (this.maxRows == -1) {
            this.maxRows = this.getDbStmt(-1).getMaxRows();
        }
        return this.maxRows;
    }

    public final void setMaxRows(int max) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setMaxRows()", new Object[]{new Integer(max)});
        }
        try {
            this.validate();
            this.maxRows = max;
            if (this.wrappedDbStmt != null) {
                this.wrappedDbStmt.setMaxRows(this.maxRows);
            }
            if (this.wrappedBufStmt != null) {
                this.wrappedBufStmt.setMaxRows(this.maxRows);
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public final void setEscapeProcessing(boolean enable) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "setEscapeProcessing(boolean)");
    }

    public final int getQueryTimeout() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "getQueryTimeout()");
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "setQueryTimeout(int)");
    }

    public final SQLWarning getWarnings() throws SQLException {
        return this.wrappedDbStmt != null ? this.wrappedDbStmt.getWarnings() : null;
    }

    public final void clearWarnings() throws SQLException {
        if (this.wrappedDbStmt != null) {
            this.wrappedDbStmt.clearWarnings();
        }
    }

    public final void setCursorName(String name) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "setCursorName(String)");
    }

    public final ResultSet getResultSet() throws SQLException {
        this.validate();
        return this.resultSet;
    }

    public final int getUpdateCount() throws SQLException {
        this.validate();
        return this.updateCount;
    }

    public final boolean getMoreResults() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "getMoreResults()");
    }

    public final int getFetchDirection() throws SQLException {
        this.validate();
        return 1000;
    }

    public final void setFetchDirection(int direction) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "setFetchDirection(int)");
    }

    public final int getFetchSize() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "getFetchSize()");
    }

    public final void setFetchSize(int rows) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "setFetchSize(int)");
    }

    public final int getResultSetConcurrency() throws SQLException {
        this.validate();
        return 1007;
    }

    public final int getResultSetType() throws SQLException {
        this.validate();
        return 1003;
    }

    public final Connection getConnection() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "getConnection()");
    }

    public String getStatementString() {
        if (this.stmtString == null && this.stmtTree != null) {
            this.stmtString = this.stmtTree.toSqlString(this.connectionContext.getVendorID());
        }
        return this.stmtString;
    }

    public abstract ExtendedStatement getDbStmt(int var1) throws SQLException;

    protected CommonResultSetMetaData createMetaData(GeneralSelectStatement selectTree) throws SQLException {
        return new CommonResultSetMetaData(selectTree);
    }

    protected ResultSet createResultSet(Statement stmt, ResultSet rs, CommonResultSetMetaData md, boolean pedantic, SQLStatement tree) throws SQLException {
        boolean isSelectAsterisk = ((GeneralSelectStatement)tree).isSelectAsterisk();
        return tree.getStatementType() == 32 ? new CommonResultSetForUpdate(this.connectionContext, stmt, rs, md, pedantic, isSelectAsterisk) : new CommonResultSet(this.connectionContext, stmt, rs, md, pedantic, isSelectAsterisk);
    }

    protected void initStmt(Statement stmt) throws SQLException {
        if (this.maxRows > 0) {
            stmt.setMaxRows(this.maxRows);
        }
    }

    protected void gatherTableStatistics(SQLStatement stmtTree, long cnt) {
        switch (stmtTree.getStatementType()) {
            case 2: 
            case 32: {
                Query q = ((GeneralSelectStatement)stmtTree).getQuery();
                if (!(q instanceof QuerySpecification)) break;
                Query[] qArray = ((QuerySpecification)q).getFromClause();
                int i = 0;
                while (i < qArray.length) {
                    if (qArray[i] instanceof TableReference) {
                        TableStatistics.addSelectOp(((TableReference)qArray[i]).getTableName());
                    }
                    ++i;
                }
                break;
            }
            case 4: {
                TableStatistics.addInsertOp(((InsertStatement)stmtTree).getTable().getTableName(), cnt);
                break;
            }
            case 8: {
                TableStatistics.addUpdateOp(((UpdateStatement)stmtTree).getTable().getTableName(), cnt);
                break;
            }
            case 16: {
                TableStatistics.addDeleteOp(((DeleteStatement)stmtTree).getTable().getTableName(), cnt);
                break;
            }
        }
    }

    protected boolean isDuplicateKeyException(SQLException exception) {
        return CoreServices.isDuplicateKeyException(this.connectionContext, exception);
    }

    protected void validate() throws SQLException {
        if (this.isClosed) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0005", new Object[]{this});
        }
    }

    protected abstract void invalidate();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void close(boolean notify) throws SQLException {
        block13: {
            block12: {
                if (TRACE.bePath()) {
                    TRACE.entering("close()");
                }
                try {
                    if (this.isClosed) {
                        Object var4_2 = null;
                        if (!this.isClosed && this.connectionContext.getState() == 0) {
                            this.bufferManager = null;
                            this.commonConnection = null;
                            this.connectionContext = null;
                            this.resultSet = null;
                            this.wrappedBufStmt = null;
                            this.wrappedDbStmt = null;
                            this.stmtTree = null;
                            this.stmtString = null;
                            this.updateCount = -1;
                            this.invalidate();
                        }
                        this.isClosed = true;
                        break block12;
                    }
                    if (notify) {
                        this.commonConnection.statementClosed(this);
                    }
                    try {
                        this.closeResultSet();
                    }
                    catch (SQLException ex) {
                        Syslog.logSQLException(this, ex, this.connectionContext.getConnectionID(), "ResultSet.close()");
                    }
                    if (this.wrappedBufStmt != null) {
                        this.wrappedBufStmt.close();
                    }
                    if (this.wrappedDbStmt != null) {
                        this.wrappedDbStmt.close();
                    }
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (!this.isClosed && this.connectionContext.getState() == 0) {
                        this.bufferManager = null;
                        this.commonConnection = null;
                        this.connectionContext = null;
                        this.resultSet = null;
                        this.wrappedBufStmt = null;
                        this.wrappedDbStmt = null;
                        this.stmtTree = null;
                        this.stmtString = null;
                        this.updateCount = -1;
                        this.invalidate();
                    }
                    this.isClosed = true;
                    if (!TRACE.bePath()) throw throwable;
                    TRACE.exiting();
                    throw throwable;
                }
            }
            if (!TRACE.bePath()) return;
            TRACE.exiting();
            return;
        }
        Object var4_3 = null;
        if (!this.isClosed && this.connectionContext.getState() == 0) {
            this.bufferManager = null;
            this.commonConnection = null;
            this.connectionContext = null;
            this.resultSet = null;
            this.wrappedBufStmt = null;
            this.wrappedDbStmt = null;
            this.stmtTree = null;
            this.stmtString = null;
            this.updateCount = -1;
            this.invalidate();
        }
        this.isClosed = true;
        if (!TRACE.bePath()) return;
        TRACE.exiting();
    }

    void closeResultSet() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
    }

    void setStatement(SQLStatement stmtTree) {
        this.stmtTree = stmtTree;
        this.stmtString = null;
    }

    public abstract int[] executeBatch() throws SQLException;

    public abstract void clearBatch() throws SQLException;

    public abstract void addBatch(String var1) throws SQLException;

    public abstract boolean execute(String var1) throws SQLException;

    public abstract int executeUpdate(String var1) throws SQLException;

    public abstract ResultSet executeQuery(String var1) throws SQLException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

