/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.basic;

import com.sap.sql.jdbc.basic.BasicJdbcObjectFactory;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;

public class BasicConnection
implements Connection {
    protected Connection wrappedConnection;
    protected BasicJdbcObjectFactory factory;

    public BasicConnection(Connection aConnection) {
        this.wrappedConnection = aConnection;
        this.factory = new BasicJdbcObjectFactory(aConnection);
    }

    public String nativeSQL(String sql) throws SQLException {
        return this.wrappedConnection.nativeSQL(sql);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.wrappedConnection.setAutoCommit(autoCommit);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.wrappedConnection.getAutoCommit();
    }

    public void commit() throws SQLException {
        this.wrappedConnection.commit();
    }

    public void rollback() throws SQLException {
        this.wrappedConnection.rollback();
    }

    public void close() throws SQLException {
        this.wrappedConnection.close();
    }

    public boolean isClosed() throws SQLException {
        return this.wrappedConnection.isClosed();
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.wrappedConnection.setReadOnly(readOnly);
    }

    public boolean isReadOnly() throws SQLException {
        return this.wrappedConnection.isReadOnly();
    }

    public void setCatalog(String catalog) throws SQLException {
        this.wrappedConnection.setCatalog(catalog);
    }

    public String getCatalog() throws SQLException {
        return this.wrappedConnection.getCatalog();
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.wrappedConnection.setTransactionIsolation(level);
    }

    public int getTransactionIsolation() throws SQLException {
        return this.wrappedConnection.getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.wrappedConnection.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.wrappedConnection.clearWarnings();
    }

    public Map getTypeMap() throws SQLException {
        return this.wrappedConnection.getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.wrappedConnection.setTypeMap(map);
    }

    public Statement createStatement() throws SQLException {
        return this.factory.createStatement(this, this.wrappedConnection.createStatement());
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.factory.createStatement(this, this.wrappedConnection.createStatement(resultSetType, resultSetConcurrency));
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.factory.createPreparedStatement(this, this.wrappedConnection.prepareStatement(sql), sql);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.factory.createPreparedStatement(this, this.wrappedConnection.prepareStatement(sql, resultSetType, resultSetConcurrency), sql);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.factory.createCallableStatement(this, this.wrappedConnection.prepareCall(sql), sql);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.factory.createCallableStatement(this, this.wrappedConnection.prepareCall(sql, resultSetType, resultSetConcurrency), sql);
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.factory.createDatabaseMetaData(this, this.wrappedConnection.getMetaData());
    }
}

