/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc;

import com.sap.sql.jdbc.ContextFactory;
import com.sap.sql.log.Syslog;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class NativeConnectionFactory {
    static /* synthetic */ Class class$com$sap$sql$jdbc$NativeConnectionFactory;

    private NativeConnectionFactory() {
    }

    public static Connection createNativeConnection(String url, Properties info) throws SQLException {
        String className = null;
        String vendorUrl = null;
        Properties props = ContextFactory.mergeProperties(null);
        try {
            String driverClassProp;
            StringTokenizer token = new StringTokenizer(url, ":");
            String jdbc = token.nextToken();
            if (!jdbc.equalsIgnoreCase("jdbc")) {
                throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$jdbc$NativeConnectionFactory == null ? (class$com$sap$sql$jdbc$NativeConnectionFactory = NativeConnectionFactory.class$("com.sap.sql.jdbc.NativeConnectionFactory")) : class$com$sap$sql$jdbc$NativeConnectionFactory, "com.sap.sql_0015", new Object[]{"url", url});
            }
            String vendor = token.nextToken();
            if (vendor.equalsIgnoreCase("sap")) {
                vendor = token.nextToken();
            }
            if ((className = props.getProperty(driverClassProp = "com.sap.sql.jdbc.driver.classname." + vendor)) == null) {
                throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$jdbc$NativeConnectionFactory == null ? (class$com$sap$sql$jdbc$NativeConnectionFactory = NativeConnectionFactory.class$("com.sap.sql.jdbc.NativeConnectionFactory")) : class$com$sap$sql$jdbc$NativeConnectionFactory, "com.sap.sql_0013", new Object[]{driverClassProp});
            }
            vendorUrl = "jdbc:" + vendor + token.nextToken("");
            Class.forName(className);
        }
        catch (NoSuchElementException ex) {
            throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$jdbc$NativeConnectionFactory == null ? (class$com$sap$sql$jdbc$NativeConnectionFactory = NativeConnectionFactory.class$("com.sap.sql.jdbc.NativeConnectionFactory")) : class$com$sap$sql$jdbc$NativeConnectionFactory, "com.sap.sql_0015", new Object[]{"url", url}, (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$jdbc$NativeConnectionFactory == null ? (class$com$sap$sql$jdbc$NativeConnectionFactory = NativeConnectionFactory.class$("com.sap.sql.jdbc.NativeConnectionFactory")) : class$com$sap$sql$jdbc$NativeConnectionFactory, "com.sap.sql_0006", new Object[]{className}, (Throwable)ex);
        }
        try {
            Driver driver = DriverManager.getDriver(vendorUrl);
            return driver.connect(vendorUrl, info);
        }
        catch (SQLException ex) {
            throw Syslog.logSQLException(class$com$sap$sql$jdbc$NativeConnectionFactory == null ? (class$com$sap$sql$jdbc$NativeConnectionFactory = NativeConnectionFactory.class$("com.sap.sql.jdbc.NativeConnectionFactory")) : class$com$sap$sql$jdbc$NativeConnectionFactory, ex, vendorUrl);
        }
    }

    public static Connection createNativeConnection(String driverClassName, String url, String user, String password) throws SQLException {
        try {
            Class.forName(driverClassName);
        }
        catch (NoSuchElementException ex) {
            throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$jdbc$NativeConnectionFactory == null ? (class$com$sap$sql$jdbc$NativeConnectionFactory = NativeConnectionFactory.class$("com.sap.sql.jdbc.NativeConnectionFactory")) : class$com$sap$sql$jdbc$NativeConnectionFactory, "com.sap.sql_0015", new Object[]{"url", url}, (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$jdbc$NativeConnectionFactory == null ? (class$com$sap$sql$jdbc$NativeConnectionFactory = NativeConnectionFactory.class$("com.sap.sql.jdbc.NativeConnectionFactory")) : class$com$sap$sql$jdbc$NativeConnectionFactory, "com.sap.sql_0006", new Object[]{driverClassName}, (Throwable)ex);
        }
        try {
            Driver driver;
            Vector<Driver> accepts = new Vector<Driver>();
            Enumeration<Driver> enumeration = DriverManager.getDrivers();
            while (enumeration.hasMoreElements()) {
                driver = enumeration.nextElement();
                if (!driver.acceptsURL(url)) continue;
                accepts.add(driver);
            }
            switch (accepts.size()) {
                case 0: {
                    throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$jdbc$NativeConnectionFactory == null ? (class$com$sap$sql$jdbc$NativeConnectionFactory = NativeConnectionFactory.class$("com.sap.sql.jdbc.NativeConnectionFactory")) : class$com$sap$sql$jdbc$NativeConnectionFactory, "com.sap.sql.jdbc_1281", new Object[]{url});
                }
                case 1: {
                    driver = (Driver)accepts.get(0);
                    break;
                }
                default: {
                    driver = null;
                    int i = 0;
                    while (i < accepts.size()) {
                        Object obj = accepts.get(i);
                        if (obj.getClass().getName().equals(driverClassName)) {
                            driver = (Driver)obj;
                            break;
                        }
                        ++i;
                    }
                    if (driver != null) break;
                    StringBuffer buffer = new StringBuffer();
                    int i2 = 0;
                    while (i2 < accepts.size()) {
                        buffer.append(accepts.get(i2).getClass().getName());
                        buffer.append(" ");
                        ++i2;
                    }
                    throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$jdbc$NativeConnectionFactory == null ? (class$com$sap$sql$jdbc$NativeConnectionFactory = NativeConnectionFactory.class$("com.sap.sql.jdbc.NativeConnectionFactory")) : class$com$sap$sql$jdbc$NativeConnectionFactory, "com.sap.sql.jdbc_1282", new Object[]{driverClassName, url, buffer.toString()});
                }
            }
            Properties info = new Properties();
            info.setProperty("user", user);
            info.setProperty("password", password);
            return driver.connect(url, info);
        }
        catch (SQLException ex) {
            throw Syslog.logSQLException(class$com$sap$sql$jdbc$NativeConnectionFactory == null ? (class$com$sap$sql$jdbc$NativeConnectionFactory = NativeConnectionFactory.class$("com.sap.sql.jdbc.NativeConnectionFactory")) : class$com$sap$sql$jdbc$NativeConnectionFactory, ex, url);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

