/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc;

import com.sap.sql.jdbc.ConnectionWrapper;
import com.sap.sql.log.Syslog;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

public class DatabaseVendor {
    public static final int VENDOR_UNKNOWN = -1;
    public static final int VENDOR_DB2_UDB = 0;
    public static final int VENDOR_DB2_UDB_AS400 = 1;
    public static final int VENDOR_DB2_UDB_OS390 = 2;
    public static final int VENDOR_INFORMIX = 3;
    public static final int VENDOR_MS_SQL_SERVER = 4;
    public static final int VENDOR_ORACLE = 5;
    public static final int VENDOR_SAPDB = 6;
    private static final String[] productNames = new String[]{"DB2/", "DB2 UDB FOR AS/400", "DB2", "INFORMIX", "MICROSOFT SQL SERVER", "ORACLE", "SAP DB"};
    private static final String[] vendors = new String[]{"DB2_UDB", "DB2_UDB_AS400", "DB2_UDB_OS390", "INFORMIX", "MS_SQL_SERVER", "ORACLE", "SAPDB"};
    static /* synthetic */ Class class$com$sap$sql$jdbc$DatabaseVendor;

    private DatabaseVendor() {
    }

    public static int getVendorID(String productName) {
        if (productName != null) {
            int i = 0;
            while (i < vendors.length) {
                if (productName.equals(vendors[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int getVendorID(Connection connection) {
        int vendorID;
        if (connection instanceof ConnectionWrapper && (vendorID = ((ConnectionWrapper)((Object)connection)).getConnectionContext().getVendorID()) != -1) {
            return vendorID;
        }
        try {
            DatabaseMetaData meta = connection.getMetaData();
            String product = meta.getDatabaseProductName().toUpperCase();
            int i = 0;
            while (i < productNames.length) {
                if (product.indexOf(productNames[i]) != -1) {
                    return i;
                }
                ++i;
            }
        }
        catch (SQLException ex) {
            Syslog.logSQLException(class$com$sap$sql$jdbc$DatabaseVendor == null ? (class$com$sap$sql$jdbc$DatabaseVendor = DatabaseVendor.class$("com.sap.sql.jdbc.DatabaseVendor")) : class$com$sap$sql$jdbc$DatabaseVendor, ex);
        }
        return -1;
    }

    public static String getVendorName(int vendorID) {
        return vendorID < 0 || vendorID >= vendors.length ? "VENDOR_UNKNOWN" : vendors[vendorID];
    }

    public static String getVendorName(Connection connection) {
        return DatabaseVendor.getVendorName(DatabaseVendor.getVendorID(connection));
    }

    public static String[] getVendorNames() {
        return vendors;
    }

    public static String getVendorTitle(int vendorID) {
        String title;
        switch (vendorID) {
            case 0: {
                title = "DB2 UDB";
                break;
            }
            case 1: {
                title = "DB2 UDB for iSeries";
                break;
            }
            case 2: {
                title = "DB2 UDB for z/OS";
                break;
            }
            case 3: {
                title = "Informix";
                break;
            }
            case 5: {
                title = "Oracle";
                break;
            }
            case 6: {
                title = "MySQL MaxDB";
                break;
            }
            case 4: {
                title = "Microsoft SQL Server";
                break;
            }
            default: {
                title = "";
            }
        }
        return title;
    }

    public static String getVendorTitle(Connection connection) {
        return DatabaseVendor.getVendorTitle(DatabaseVendor.getVendorID(connection));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

