/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.dbcatalog;

import com.sap.sql.dbcatalog.DbCatalogExpert;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class OraCatalogExpert
implements DbCatalogExpert {
    private Connection conn = null;
    private DatabaseMetaData md = null;
    private String userSchema = null;
    private boolean varcharAsUtf8 = false;
    private boolean ncharAsUtf8 = false;

    OraCatalogExpert(Connection conn, DatabaseMetaData md) throws SQLException {
        this.conn = conn;
        this.md = md;
        PreparedStatement pstmt = this.conn.prepareStatement("SELECT VALUE FROM V$NLS_PARAMETERS WHERE PARAMETER = ?");
        pstmt.setString(1, "NLS_CHARACTERSET");
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            this.varcharAsUtf8 = rs.getString(1).equals("UTF8");
        }
        rs.close();
        pstmt.setString(1, "NLS_NCHAR_CHARACTERSET");
        rs = pstmt.executeQuery();
        if (rs.next()) {
            this.ncharAsUtf8 = rs.getString(1).equals("UTF8");
        }
        rs.close();
        pstmt.close();
    }

    public String identifyUserSchema() throws SQLException {
        if (this.userSchema == null) {
            this.userSchema = this.md.getUserName().toUpperCase();
        }
        return this.userSchema;
    }

    public int identifyTableType(String schemaName, String tableName) throws SQLException {
        int tableType = 0;
        ResultSet rs = this.md.getTables(null, schemaName, tableName, null);
        if (rs.next()) {
            String tableTypeStr = rs.getString("TABLE_TYPE");
            if (tableTypeStr.compareTo("TABLE") == 0) {
                tableType = 1;
            } else if (tableTypeStr.compareTo("VIEW") == 0) {
                tableType = 2;
            }
        }
        rs.close();
        return tableType;
    }

    public HashMap identifyPrimaryKeys(String schemaName, String tableName) throws SQLException {
        HashMap<String, Integer> pKeysMap = new HashMap<String, Integer>(20);
        if (schemaName == null) {
            throw new SQLException("schemaName == null");
        }
        PreparedStatement ps = this.conn.prepareStatement("SELECT column_name FROM all_ind_columns WHERE (index_owner, index_name) IN       (SELECT owner, index_name FROM all_indexes        WHERE table_owner = ? AND table_name = ?        AND index_name like 'SYS%'        AND uniqueness = 'UNIQUE' AND rownum <= 1) ORDER BY column_position");
        ps.setString(1, schemaName);
        ps.setString(2, tableName);
        ResultSet rs = ps.executeQuery();
        int i = 1;
        while (rs.next()) {
            pKeysMap.put(rs.getString(1), new Integer(i));
            ++i;
        }
        rs.close();
        ps.close();
        if (i == 1) {
            ps = this.conn.prepareStatement("SELECT column_name FROM all_ind_columns WHERE (index_owner, index_name) IN       (SELECT owner, index_name FROM all_indexes        WHERE table_owner = ? AND table_name = ?        AND uniqueness = 'UNIQUE' AND rownum <= 1) ORDER BY column_position");
            ps.setString(1, schemaName);
            ps.setString(2, tableName);
            rs = ps.executeQuery();
            i = 1;
            while (rs.next()) {
                pKeysMap.put(rs.getString(1), new Integer(i));
                ++i;
            }
            rs.close();
            ps.close();
        }
        return pKeysMap;
    }

    public ResultSet identifyColumns(String schemaName, String tableName) throws SQLException {
        return this.md.getColumns(null, schemaName, tableName, null);
    }

    public int identifyJdbcType(int origJdbcType, String typeName, String schemaName, String tableName, String columnName) throws SQLException {
        if (origJdbcType == 1111) {
            if (typeName.equals("BLOB")) {
                return 2004;
            }
            if (typeName.equals("CLOB")) {
                return 2005;
            }
            if (typeName.equals("FLOAT")) {
                return 8;
            }
            if (typeName.equals("NVARCHAR2")) {
                return 12;
            }
            if (typeName.equals("NCHAR")) {
                return 1;
            }
            if (typeName.startsWith("TIMESTAMP")) {
                return 93;
            }
        }
        return origJdbcType;
    }

    public long identifySize(int jdbcType, String typeName, long origSize) {
        if (this.varcharAsUtf8 && (typeName.equals("VARCHAR") || typeName.equals("VARCHAR2")) || this.ncharAsUtf8 && (typeName.equals("NCHAR") || typeName.equals("NVARCHAR2"))) {
            return origSize / 3L;
        }
        if (jdbcType == 2004 || jdbcType == 2005) {
            return 0L;
        }
        if (jdbcType == 8) {
            return 38L;
        }
        return origSize;
    }

    public int identifyDecimals(int jdbcType, int origDecimals) {
        if (jdbcType == 93) {
            return 0;
        }
        return origDecimals;
    }

    public boolean identifyRemoveLastColumn() {
        return false;
    }
}

