/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.dbcatalog;

import com.sap.sql.catalog.Column;
import com.sap.sql.catalog.ColumnIterator;
import com.sap.sql.catalog.Table;
import com.sap.sql.dbcatalog.DbCatalogColumn;
import com.sap.sql.dbcatalog.DbCatalogColumnIterator;
import java.util.ArrayList;
import java.util.HashMap;

public class DbCatalogTable
implements Table {
    private String tableName;
    private String schemaName;
    private int tableType = 1;
    private int columnCnt = 0;
    private int primaryKeyCnt = 0;
    private int bufferKeyCnt = -1;
    private boolean buffered = false;
    private boolean clientDependent = false;
    private int clientColumnIndex = -1;
    private HashMap columNameIndex = new HashMap(256);
    private HashMap primaryKeyIndex = new HashMap(20);
    ArrayList columns = new ArrayList();

    DbCatalogTable(String schemaName, String tableName, int tableType, boolean buffered, boolean clientDependent) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.tableType = tableType;
        this.buffered = buffered;
        this.clientDependent = clientDependent;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getName() {
        return this.tableName;
    }

    public int getColumnCnt() {
        return this.columnCnt;
    }

    public int getPrimaryKeyCnt() {
        return this.primaryKeyCnt;
    }

    public int getBufferKeyCnt() {
        return this.bufferKeyCnt;
    }

    public Column getColumn(String columnName) {
        Integer indexInteger = (Integer)this.columNameIndex.get(columnName);
        if (indexInteger != null) {
            return (Column)this.columns.get(indexInteger);
        }
        return null;
    }

    public Column getColumn(int position) {
        if (position <= 0 || position > this.columnCnt) {
            return null;
        }
        return (Column)this.columns.get(position - 1);
    }

    public ColumnIterator getColumns() {
        return new DbCatalogColumnIterator(this);
    }

    public Column getPrimaryKeyColumn(int position) {
        if (position <= 0 || position > this.primaryKeyCnt) {
            return null;
        }
        Integer indexInteger = (Integer)this.primaryKeyIndex.get(new Integer(position));
        if (indexInteger != null) {
            return (Column)this.columns.get(indexInteger);
        }
        return null;
    }

    public int getTableType() {
        return this.tableType;
    }

    public boolean isClientDependent() {
        return this.clientDependent;
    }

    public Column getClientColumn() {
        return this.clientColumnIndex >= 0 ? this.getColumn(this.clientColumnIndex + 1) : null;
    }

    void addColumn(String columnName, boolean pKey, Integer pKeyPos, int jdbcType, String typeName, long size, int decimals, boolean nullable, Object defaultObj) {
        Integer actualIndex = new Integer(this.columnCnt);
        if (pKey) {
            ++this.primaryKeyCnt;
            this.primaryKeyIndex.put(pKeyPos, actualIndex);
        }
        this.columNameIndex.put(columnName, actualIndex);
        if ((columnName.equals("MANDT") || columnName.equals("CLIENT")) && size == 3L) {
            this.clientDependent = true;
            this.clientColumnIndex = actualIndex;
        }
        ++this.columnCnt;
        DbCatalogColumn col = new DbCatalogColumn(this, columnName, this.columnCnt, pKey, pKey ? pKeyPos : 0, jdbcType, typeName, size, decimals, nullable, defaultObj);
        this.columns.add(col);
    }

    void removeLastColumn() {
        this.columns.remove(this.columnCnt - 1);
        --this.columnCnt;
    }
}

