/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.connect.port;

import com.sap.sql.connect.port.DataSourceInfo;
import java.sql.SQLException;
import java.util.Properties;

public class Db4DataSourceInfo
extends DataSourceInfo {
    private static final String SAP_DB4_TOOLBOX_DS_STANDARD = "com.ibm.as400.access.AS400JDBCDataSource";
    private static final String SAP_DB4_TOOLBOX_DS_POOL = "com.ibm.as400.access.AS400JDBCConnectionPoolDataSource";
    private static final String SAP_DB4_TOOLBOX_DS_XA = "com.ibm.as400.access.AS400JDBCXADataSource";
    private static final String SAP_DB4_NATIVE_DS_STANDARD = "com.ibm.db2.jdbc.app.UDBDataSource";
    private static final String SAP_DB4_NATIVE_DS_POOL = "com.ibm.db2.jdbc.app.UDBConnectionPoolDataSource";
    private static final String SAP_DB4_NATIVE_DS_XA = "com.ibm.db2.jdbc.app.UDBXADataSource";
    private static DataSourceInfo instance = new Db4DataSourceInfo();

    private Db4DataSourceInfo() {
    }

    static DataSourceInfo getInstance() {
        return instance;
    }

    public String getDefaultDataSourceClassName(int type) throws SQLException {
        switch (type) {
            case 1: {
                return SAP_DB4_TOOLBOX_DS_STANDARD;
            }
            case 2: {
                return SAP_DB4_TOOLBOX_DS_POOL;
            }
            case 3: {
                throw new SQLException("XA not supported");
            }
        }
        throw new IllegalArgumentException("Illegal data source type");
    }

    public Properties getMandatoryDataSourceProperties(int type, String className) throws SQLException {
        Properties props = new Properties();
        if (className.equals(SAP_DB4_TOOLBOX_DS_STANDARD) || className.equals(SAP_DB4_TOOLBOX_DS_POOL)) {
            props.setProperty("TransactionIsolation", "read uncommitted");
            props.setProperty("DataTruncation", "true");
            props.setProperty("DateFormat", "jis");
            props.setProperty("TimeFormat", "jis");
            props.setProperty("Sort", "hex");
            props.setProperty("Prompt", "false");
            props.setProperty("CursorHold", "false");
            props.setProperty("HoldInputLocators", "true");
            props.setProperty("HoldStatements", "true");
            props.setProperty("TrueAutocommit", "true");
        } else if (className.equals(SAP_DB4_NATIVE_DS_STANDARD) || className.equals(SAP_DB4_NATIVE_DS_POOL) || className.equals(SAP_DB4_NATIVE_DS_XA)) {
            props.setProperty("TransactionIsolationLevel", "read uncommitted");
            props.setProperty("DataTruncation", "true");
            props.setProperty("DateFormat", "jis");
            props.setProperty("TimeFormat", "jis");
            props.setProperty("BehaviorOverride", "2");
            props.setProperty("CursorHold", "false");
        } else {
            throw new SQLException("Data source type not supported.");
        }
        return props;
    }
}

