/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.connect;

import com.sap.sql.connect.CommonFactoryCore;
import com.sap.sql.connect.CommonFactoryLib;
import com.sap.sql.connect.OpenSQLConfiguration;
import com.sap.sql.connect.OpenSQLDataSourceImpl;
import com.sap.sql.jdbc.ContextFactory;
import com.sap.sql.jdbc.common.CommonConnectionFactory;
import com.sap.sql.jdbc.direct.DirectConnectionFactory;
import com.sap.sql.services.OpenSQLServices;
import com.sap.sql.services.OpenSQLServicesImpl;
import com.sap.sql.sync.SyncReaderFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;

public class OpenSQLConnectionFactory {
    public static final String CONNECTION_NAME = "jndiName";
    public static final String CATALOG_READER_URI = "com.sap.sql.catalog.reader.uri";
    public static final int STATE_STARTING = 1;
    public static final int STATE_STARTED = 2;
    public static final int STATE_STOPPING = 3;
    public static final int STATE_STOPPED = 4;

    private OpenSQLConnectionFactory() {
    }

    public static Connection createCommonConnection(Connection basicConnection, Properties properties) throws SQLException {
        if (null == basicConnection) {
            throw new IllegalArgumentException("basicConnection must not be null");
        }
        return CommonConnectionFactory.createCommonConnection(basicConnection, properties);
    }

    public static PooledConnection createCommonPooledConnection(Connection basicConnection, Properties properties) throws SQLException {
        return CommonConnectionFactory.createCommonPooledConnection(basicConnection, properties);
    }

    public static PooledConnection createCommonPooledConnection(PooledConnection basicPooledConnection, Properties properties) throws SQLException {
        return CommonConnectionFactory.createCommonPooledConnection(basicPooledConnection, properties);
    }

    public static XAConnection createCommonXAConnection(XAConnection basicXAConnection, Properties properties) throws SQLException {
        return CommonConnectionFactory.createCommonXAConnection(basicXAConnection, properties);
    }

    public static Connection createDirectConnection(Connection basicConnection, Properties properties) throws SQLException {
        if (null == basicConnection) {
            throw new IllegalArgumentException("basicConnection must not be null");
        }
        return DirectConnectionFactory.createDirectConnection(basicConnection, properties);
    }

    public static PooledConnection createDirectPooledConnection(Connection basicConnection, Properties properties) throws SQLException {
        return DirectConnectionFactory.createDirectPooledConnection(basicConnection, properties);
    }

    public static PooledConnection createDirectPooledConnection(PooledConnection basicPooledConnection, Properties properties) throws SQLException {
        return DirectConnectionFactory.createDirectPooledConnection(basicPooledConnection, properties);
    }

    public static XAConnection createDirectXAConnection(XAConnection basicXAConnection, Properties properties) throws SQLException {
        return DirectConnectionFactory.createDirectXAConnection(basicXAConnection, properties);
    }

    public static void dataSourceStateChanged(String dataSourceName, boolean isCommonSQL, int state) {
        switch (state) {
            case 1: {
                try {
                    OpenSQLConfiguration.getInstance().addDataSource(dataSourceName);
                }
                catch (SQLException ex) {}
                break;
            }
            case 2: {
                if (!isCommonSQL) break;
                try {
                    SyncReaderFactory.startSyncReader(dataSourceName);
                }
                catch (SQLException sQLException) {}
                break;
            }
            case 3: {
                if (!isCommonSQL) break;
                SyncReaderFactory.stopSyncReader(dataSourceName);
            }
        }
    }

    public static void jdbcConnectorStateChanged(int state) {
        switch (state) {
            case 1: {
                OpenSQLServices.setServices(new OpenSQLServicesImpl());
                OpenSQLDataSourceImpl.setCommonFactory(CommonFactoryLib.getInstance());
                break;
            }
            case 3: {
                OpenSQLServices.setServices(null);
                OpenSQLDataSourceImpl.setCommonFactory(CommonFactoryCore.getInstance());
                ContextFactory.setConfigurationManager(null);
            }
        }
    }
}

