/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.connect;

import com.sap.exception.standard.SAPIllegalArgumentException;
import com.sap.security.core.server.secstorefs.SecStoreFS;
import com.sap.security.core.server.secstorefs.SecStoreFSException;
import com.sap.sql.connect.OpenSQLDataSource;
import com.sap.sql.connect.port.DataSourceInfo;
import com.sap.sql.log.Syslog;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;

public class OpenSQLConnectInfo {
    public static final int VENDOR_DB2_UDB = 0;
    public static final int VENDOR_DB2_UDB_AS400 = 1;
    public static final int VENDOR_DB2_UDB_OS390 = 2;
    public static final int VENDOR_MS_SQL_SERVER = 4;
    public static final int VENDOR_ORACLE = 5;
    public static final int VENDOR_SAPDB = 6;
    public static final int DS_TYPE_STANDARD = 1;
    public static final int DS_TYPE_POOL = 2;
    public static final int DS_TYPE_XA = 3;
    public static final int DS_TYPE_DRIVER = 4;
    private static final int DS_TYPE_DATASOURCE = 0;
    private static final String CLASSNAME_TOKEN = "ClassName";
    private static final String URL_TOKEN = "Url";
    private static final String USER_TOKEN = "User";
    private static final String PASSWORD_TOKEN = "Password";
    private static final ArrayList generalPropNames;
    private static final Properties generalProps;
    private int dsVendor = -1;
    private int dsType = -1;
    private String dsClassName = null;
    private Properties dsProps = null;
    private String dsName = null;
    private String driverClassName = null;
    private String url = null;
    private String user = null;
    private String password = null;
    private static final Location LOCATION;
    static /* synthetic */ Class class$com$sap$sql$connect$OpenSQLConnectInfo;

    public OpenSQLConnectInfo(int vendor, int type) {
        OpenSQLConnectInfo.checkParams(vendor, type);
        this.dsVendor = vendor;
        this.dsType = type;
        try {
            this.dsClassName = OpenSQLConnectInfo.getDefaultDataSourceClassName(this.dsVendor, this.dsType);
        }
        catch (SQLException ex) {
            this.dsClassName = null;
        }
    }

    public OpenSQLConnectInfo(String driver, String url, String user, String password) {
        this.setDriverProperties(driver, url, user, password);
    }

    public OpenSQLConnectInfo(String name) {
        this.dsName = name;
    }

    public static String getDefaultDataSourceClassName(int vendor, int type) throws SQLException {
        OpenSQLConnectInfo.checkParams(vendor, type);
        return DataSourceInfo.getInstance(vendor).getDefaultDataSourceClassName(type);
    }

    public static List getCommonMandatoryDataSourcePropertyNames() {
        return generalPropNames;
    }

    public static List getVendorMandatoryDataSourcePropertyNames(int vendor, int type, String className, boolean includeCommon) throws SQLException {
        OpenSQLConnectInfo.checkParams(vendor, type);
        Properties props = OpenSQLConnectInfo.getMandatoryDataSourceProperties(vendor, type, className, false);
        ArrayList names = new ArrayList();
        if (includeCommon) {
            names.addAll(generalPropNames);
        }
        names.addAll(((Hashtable)props).keySet());
        return names;
    }

    public int getDataSourceType() {
        return this.dsType;
    }

    public void setDataSourceDefaults(int vendor, int type) throws SQLException {
        OpenSQLConnectInfo.checkParams(vendor, type);
        this.dsVendor = vendor;
        this.dsType = type;
        this.dsProps = null;
        this.dsClassName = OpenSQLConnectInfo.getDefaultDataSourceClassName(this.dsVendor, this.dsType);
    }

    public String getDataSourceClassName() {
        return this.dsClassName;
    }

    public void setDataSourceClassName(String className) {
        if (className == null) {
            throw new SAPIllegalArgumentException(LOCATION, "com.sap.exception.standard_0001", new Object[]{"className"});
        }
        this.dsType = 0;
        this.dsClassName = className;
    }

    public Properties getDataSourceProperties() throws SQLException {
        if (this.dsProps == null) {
            OpenSQLConnectInfo.checkParams(this.dsVendor, this.dsType);
            this.dsProps = OpenSQLConnectInfo.getMandatoryDataSourceProperties(this.dsVendor, this.dsType, this.dsClassName, true);
        }
        return this.dsProps;
    }

    public void setDataSourceProperties(Properties properties) {
        if (properties == null) {
            throw new SAPIllegalArgumentException(LOCATION, "com.sap.exception.standard_0001", new Object[]{"properties"});
        }
        this.dsType = 0;
        this.dsProps = properties;
    }

    public void setDriverProperties(String driver, String url, String user, String password) {
        if (driver == null) {
            throw new SAPIllegalArgumentException(LOCATION, "com.sap.exception.standard_0001", new Object[]{"driver"});
        }
        if (url == null) {
            throw new SAPIllegalArgumentException(LOCATION, "com.sap.exception.standard_0001", new Object[]{"url"});
        }
        if (user == null) {
            throw new SAPIllegalArgumentException(LOCATION, "com.sap.exception.standard_0001", new Object[]{"user"});
        }
        if (password == null) {
            throw new SAPIllegalArgumentException(LOCATION, "com.sap.exception.standard_0001", new Object[]{"password"});
        }
        this.driverClassName = driver;
        this.url = url;
        this.user = user;
        this.password = password;
        this.dsType = 4;
        this.dsProps = this.getDriverProperties(this.driverClassName, url, user, password);
    }

    public String getDataSourceName() {
        return this.dsName;
    }

    public void setDataSourceName(String name) {
        if (name == null) {
            throw new SAPIllegalArgumentException(LOCATION, "com.sap.exception.standard_0001", new Object[]{"name"});
        }
        this.dsName = name;
    }

    public void lookup() throws SQLException, SecStoreFSException {
        this.lookup(null);
    }

    public void lookup(String keyPhrase) throws SQLException, SecStoreFSException {
        if (this.dsName == null) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0013", new Object[]{"data source name"});
        }
        String propString = OpenSQLConnectInfo.getStore(keyPhrase).getStringValue(this.dsName);
        OpenSQLDataSource ds = OpenSQLDataSource.newInstance();
        ds.setDataSourceProperties(propString);
        this.dsType = ds.getDataSourceType();
        this.dsProps = ds.getDataSourceProperties();
        if (this.dsType == 4) {
            this.driverClassName = this.dsProps.getProperty(CLASSNAME_TOKEN);
            this.url = this.dsProps.getProperty(URL_TOKEN);
            this.user = this.dsProps.getProperty(USER_TOKEN);
            this.password = this.dsProps.getProperty(PASSWORD_TOKEN);
        } else {
            this.dsClassName = ds.getDataSourceClassName();
        }
    }

    public void bind() throws SQLException, SecStoreFSException {
        this.bind(null);
    }

    public void bind(String keyPhrase) throws SQLException, SecStoreFSException {
        if (this.dsName == null) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0013", new Object[]{"data source name"});
        }
        OpenSQLDataSource ds = this.checkConnectInfo(false);
        OpenSQLConnectInfo.getStore(keyPhrase).insertPair(this.dsName, ds.getDataSourcePropertiesString());
    }

    public void rebind() throws SQLException, SecStoreFSException {
        this.rebind(null);
    }

    public void rebind(String keyPhrase) throws SQLException, SecStoreFSException {
        if (this.dsName == null) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0013", new Object[]{"data source name"});
        }
        OpenSQLDataSource ds = this.checkConnectInfo(false);
        OpenSQLConnectInfo.getStore(keyPhrase).updatePair(this.dsName, ds.getDataSourcePropertiesString());
    }

    public void unbind() throws SQLException, SecStoreFSException {
        this.unbind(null);
    }

    public void unbind(String keyPhrase) throws SQLException, SecStoreFSException {
        if (this.dsName == null) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0013", new Object[]{"data source name"});
        }
        if (this.dsName != null) {
            OpenSQLConnectInfo.getStore(keyPhrase).deletePair(this.dsName);
        }
    }

    static String lookup(String key, String keyPhrase) throws SecStoreFSException {
        return OpenSQLConnectInfo.getStore(keyPhrase).getStringValue(key);
    }

    private Properties getDriverProperties(String driver, String url, String user, String password) {
        Properties props = new Properties();
        props.setProperty(CLASSNAME_TOKEN, driver);
        props.setProperty(URL_TOKEN, url);
        props.setProperty(USER_TOKEN, user);
        props.setProperty(PASSWORD_TOKEN, password);
        return props;
    }

    private static SecStoreFS getStore(String keyPhrase) throws SecStoreFSException {
        SecStoreFS store = new SecStoreFS();
        if (keyPhrase != null) {
            store.openExistingStore(keyPhrase);
        } else {
            store.openExistingStore();
        }
        return store;
    }

    private static Properties getMandatoryDataSourceProperties(int vendor, int type, String className, boolean merge) throws SQLException {
        String name;
        DataSourceInfo info = DataSourceInfo.getInstance(vendor);
        Properties props = info.getMandatoryDataSourceProperties(type, name = className != null ? className : info.getDefaultDataSourceClassName(type));
        if (props == null) {
            props = new Properties();
        }
        if (merge) {
            ((Hashtable)props).putAll(generalProps);
        }
        return props;
    }

    private OpenSQLDataSource checkConnectInfo(boolean connect) throws SQLException {
        if (this.dsType == 4) {
            OpenSQLDataSource ds = OpenSQLDataSource.newInstance();
            ds.setConnectionType(3);
            ds.setDriverProperties(this.driverClassName, this.url, this.user, this.password);
            if (connect) {
                Connection conn = ds.getConnection();
                conn.close();
            }
            return ds;
        }
        return this.checkDataSource(connect);
    }

    private OpenSQLDataSource checkDataSource(boolean connect) throws SQLException {
        if (this.dsClassName == null) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0013", new Object[]{"data source name"});
        }
        Iterator iter = ((Hashtable)this.dsProps).entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value != null && value.length() != 0) continue;
            throw new SQLException("Value for property " + key + " not set");
        }
        OpenSQLDataSource ds = OpenSQLDataSource.newInstance();
        ds.setConnectionType(3);
        ds.setDataSourceProperties(this.dsClassName, this.dsProps);
        if (connect) {
            switch (ds.getDataSourceType()) {
                case 1: {
                    Connection conn = ds.getConnection();
                    conn.close();
                    break;
                }
                case 2: {
                    PooledConnection poolConn = ds.getPooledConnection();
                    poolConn.close();
                    break;
                }
                case 3: {
                    XAConnection xaConn = ds.getXAConnection();
                    xaConn.close();
                }
            }
        }
        return ds;
    }

    private static void checkParams(int vendor, int type) {
        if (vendor < 0 || vendor > 6) {
            throw new SAPIllegalArgumentException(LOCATION, "com.sap.exception.standard_0007", new Object[]{"vendor", new Integer(vendor), "0..6"});
        }
        if (type < 1 || type > 3) {
            throw new SAPIllegalArgumentException(LOCATION, "com.sap.exception.standard_0007", new Object[]{"type", new Integer(type), "1..3"});
        }
    }

    private static int convertVendor(String vendor) {
        if (vendor.equalsIgnoreCase("db2_udb")) {
            return 0;
        }
        if (vendor.equalsIgnoreCase("db2_udb_as400")) {
            return 1;
        }
        if (vendor.equalsIgnoreCase("db2_udb_os390")) {
            return 2;
        }
        if (vendor.equalsIgnoreCase("ms_sql_server")) {
            return 4;
        }
        if (vendor.equalsIgnoreCase("oracle")) {
            return 5;
        }
        if (vendor.equalsIgnoreCase("sapdb")) {
            return 6;
        }
        OpenSQLConnectInfo.showUsage("Illegal argument for <vendor>");
        return -1;
    }

    private static int convertType(String type) {
        if (type.equalsIgnoreCase("standard")) {
            return 1;
        }
        if (type.equalsIgnoreCase("pool")) {
            return 2;
        }
        if (type.equalsIgnoreCase("xa")) {
            return 3;
        }
        OpenSQLConnectInfo.showUsage("Illegal argument for <type>");
        return -1;
    }

    private static String convertList(List list) {
        StringBuffer buffer = new StringBuffer().append("[");
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String value = (String)iter.next();
            buffer.append("\"").append(value).append("\",");
        }
        int length = buffer.length();
        buffer.replace(length - 1, length, "]");
        return buffer.toString();
    }

    private static String convertProperties(Properties props) {
        StringBuffer buffer = new StringBuffer().append("{");
        Iterator iter = ((Hashtable)props).entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            buffer.append(key).append(":\"").append(value).append("\",");
        }
        int length = buffer.length();
        buffer.replace(length - 1, length, "}");
        return buffer.toString();
    }

    private static void showUsage(String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        System.out.println("\nUsage:\n");
        System.out.println("OpenSQLConnectInfo classname  <vendor> <type>");
        System.out.println("OpenSQLConnectInfo propnames  <vendor> <type> <classname>");
        System.out.println("OpenSQLConnectInfo propvalues <vendor> <type> <classname>");
        System.out.println("OpenSQLConnectInfo create_ds  <name>   <classname> <sid> <data filename> <key filename> [<propKey>=<propValue>]*");
        System.out.println("OpenSQLConnectInfo create_dr  <name>   <classname> <url> <user> <password> <sid> <data filename> <key filename>\n");
        System.out.println("<vendor> = db2_udb | db2_udb_as400 | db2_udb_os390 | ms_sql_server | oracle | sapdb");
        System.out.println("<type>   = standard | pool | xa");
        System.exit(1);
    }

    private static void execClassName(String[] args) {
        if (args.length != 3) {
            OpenSQLConnectInfo.showUsage("Illegal function call syntax");
        }
        int vendor = OpenSQLConnectInfo.convertVendor(args[1]);
        int type = OpenSQLConnectInfo.convertType(args[2]);
        try {
            System.out.println(OpenSQLConnectInfo.getDefaultDataSourceClassName(vendor, type));
        }
        catch (Exception ex) {
            OpenSQLConnectInfo.showUsage(ex.getMessage());
        }
    }

    private static void execPropNames(String[] args) {
        if (args.length != 4) {
            OpenSQLConnectInfo.showUsage("Illegal function call syntax");
        }
        int vendor = OpenSQLConnectInfo.convertVendor(args[1]);
        int type = OpenSQLConnectInfo.convertType(args[2]);
        String className = args[3];
        try {
            List list = OpenSQLConnectInfo.getVendorMandatoryDataSourcePropertyNames(vendor, type, className, true);
            System.out.println(OpenSQLConnectInfo.convertList(list));
        }
        catch (Exception ex) {
            OpenSQLConnectInfo.showUsage(ex.getMessage());
        }
    }

    private static void execPropValues(String[] args) {
        if (args.length != 4) {
            OpenSQLConnectInfo.showUsage("Illegal function call syntax");
        }
        int vendor = OpenSQLConnectInfo.convertVendor(args[1]);
        int type = OpenSQLConnectInfo.convertType(args[2]);
        String className = args[3];
        try {
            OpenSQLConnectInfo info = new OpenSQLConnectInfo(vendor, type);
            info.setDataSourceClassName(className);
            Properties props = info.getDataSourceProperties();
            System.out.println(OpenSQLConnectInfo.convertProperties(props));
        }
        catch (Exception ex) {
            OpenSQLConnectInfo.showUsage(ex.getMessage());
        }
    }

    private static void execCreateDataSource(String[] args) {
        if (args.length < 6) {
            OpenSQLConnectInfo.showUsage("Illegal function call syntax");
        }
        String name = args[1];
        String className = args[2];
        try {
            OpenSQLConnectInfo.setSecStore(args, 3);
            Properties props = new Properties();
            int i = 6;
            while (i < args.length) {
                String pair = args[i];
                int index = pair.indexOf(61);
                if (index == -1) {
                    System.out.println("Illegal property arguments");
                    System.exit(1);
                }
                String key = pair.substring(0, index);
                String value = pair.substring(index + 1);
                props.setProperty(key, value);
                ++i;
            }
            OpenSQLConnectInfo info = new OpenSQLConnectInfo(name);
            info.setDataSourceClassName(className);
            info.setDataSourceProperties(props);
            info.bind();
            System.out.println("Data source successfully created");
        }
        catch (Exception ex) {
            OpenSQLConnectInfo.showUsage(ex.getMessage());
        }
    }

    private static void execCreateDriver(String[] args) {
        if (args.length != 9) {
            OpenSQLConnectInfo.showUsage("Illegal function call syntax");
        }
        String name = args[1];
        String className = args[2];
        String url = args[3];
        String user = args[4];
        String password = args[5];
        try {
            OpenSQLConnectInfo.setSecStore(args, 6);
            OpenSQLConnectInfo info = new OpenSQLConnectInfo(className, url, user, password);
            info.setDataSourceName(name);
            info.bind();
            System.out.println("Driver successfully created");
        }
        catch (Exception ex) {
            OpenSQLConnectInfo.showUsage(ex.getMessage());
        }
    }

    private static void setSecStore(String[] args, int idx) throws SecStoreFSException {
        SecStoreFS.setSID((String)args[idx]);
        SecStoreFS.setDefaultFilenames((String)args[idx + 1], (String)args[idx + 2]);
    }

    public static void main(String[] args) {
        String function;
        if (args.length < 1) {
            OpenSQLConnectInfo.showUsage(null);
        }
        if ((function = args[0]).equalsIgnoreCase("classname")) {
            OpenSQLConnectInfo.execClassName(args);
        } else if (function.equalsIgnoreCase("propnames")) {
            OpenSQLConnectInfo.execPropNames(args);
        } else if (function.equalsIgnoreCase("propvalues")) {
            OpenSQLConnectInfo.execPropValues(args);
        } else if (function.equalsIgnoreCase("create_ds")) {
            OpenSQLConnectInfo.execCreateDataSource(args);
        } else if (function.equalsIgnoreCase("create_dr")) {
            OpenSQLConnectInfo.execCreateDriver(args);
        } else {
            OpenSQLConnectInfo.showUsage("Illegal function " + function);
        }
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        LOCATION = Location.getLocation((Class)(class$com$sap$sql$connect$OpenSQLConnectInfo == null ? (class$com$sap$sql$connect$OpenSQLConnectInfo = OpenSQLConnectInfo.class$("com.sap.sql.connect.OpenSQLConnectInfo")) : class$com$sap$sql$connect$OpenSQLConnectInfo));
        generalPropNames = new ArrayList();
        generalPropNames.add("DatabaseName");
        generalPropNames.add("ServerName");
        generalPropNames.add(USER_TOKEN);
        generalPropNames.add(PASSWORD_TOKEN);
        generalProps = new Properties();
        int i = 0;
        while (i < generalPropNames.size()) {
            generalProps.setProperty((String)generalPropNames.get(i), "");
            ++i;
        }
    }
}

