/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.connect;

import com.sap.engine.frame.ServiceContext;
import com.sap.engine.frame.core.CoreContext;
import com.sap.engine.frame.core.configuration.ConfigMetaData;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import com.sap.sql.jdbc.ConfigurationManager;
import com.sap.sql.jdbc.ContextFactory;
import com.sap.sql.log.Syslog;
import com.sap.tc.logging.Location;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class OpenSQLConfiguration
implements ConfigurationManager {
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$connect$OpenSQLConfiguration == null ? (class$com$sap$sql$connect$OpenSQLConfiguration = OpenSQLConfiguration.class$("com.sap.sql.connect.OpenSQLConfiguration")) : class$com$sap$sql$connect$OpenSQLConfiguration));
    private static final int READ = 0;
    private static final int WRITE = 1;
    private static final int STANDARD = 0;
    private static final int PROP_GENERAL = 0;
    private static final int PROP_SCHEMA = 1;
    private static final int PROP_DATASOURCE = 2;
    private static final String rootClassName = "com.sap.engine.services.dbpool.PoolFrame";
    private static final String rootClassMethodName = "getAppContext";
    private static final String rootConfigName = "OpenSQL";
    private static final char CONFIG_MANAGER_ILLEGAL_CHAR_1 = '%';
    private static final char CONFIG_MANAGER_ILLEGAL_CHAR_2 = '[';
    private static final char CONFIG_MANAGER_ILLEGAL_CHAR_3 = ']';
    private static final char CONFIG_MANAGER_ILLEGAL_CHAR_4 = '#';
    private static final char CONFIG_MANAGER_ILLEGAL_CHAR_5 = '/';
    private static final char CONFIG_MANAGER_REPLACE_CHAR_1 = ':';
    private static final char CONFIG_MANAGER_REPLACE_CHAR_2 = '(';
    private static final char CONFIG_MANAGER_REPLACE_CHAR_3 = ')';
    private static final char CONFIG_MANAGER_REPLACE_CHAR_4 = '*';
    private static final char CONFIG_MANAGER_REPLACE_CHAR_5 = '|';
    private static final char CONFIG_MANAGER_ESCAPE_CHAR = '~';
    private static OpenSQLConfiguration instance = null;
    private Map generalSheets = new Hashtable();
    private Map schemaSheets = new Hashtable();
    private Map dataSourceSheets = new Hashtable();
    private Map[] sheets = new Map[]{this.generalSheets, this.schemaSheets, this.dataSourceSheets};
    private Properties defaultProps;
    private Properties defaultSchemaProps = new Properties();
    private Properties defaultDataSourceProps = new Properties();
    private ConfigurationHandler configHandler = null;
    static /* synthetic */ Class class$com$sap$sql$connect$OpenSQLConfiguration;
    static /* synthetic */ Class class$com$sap$sql$connect$OpenSQLConnectionFactory;

    private OpenSQLConfiguration() throws SQLException {
        this.defaultProps = ContextFactory.mergeProperties(null);
        this.addGeneralProperty("SQLTrace", "MaxFileNumber", "com.sap.sql.trace.j2ee.cnt", "Maximum number of SQL trace files per sql trace.");
        this.addGeneralProperty("SQLTrace", "MaxFileSize", "com.sap.sql.trace.j2ee.limit", "Maximum size of single SQL trace file.");
        this.addGeneralProperty("BufferSynchronization", "SynchronizationActive", "com.sap.sql.sync.writer.active", "Enables/Disables buffer synchronization requests. For performance reasons it is recommended to disable buffer synchronization for single node server installations. For multi node server installations it must be enabled.");
        this.addSchemaProperty("BufferSynchronization", "SynchronizationInterval", "com.sap.sql.sync.reader.period", "Time in seconds between two buffer synchronization events. Recommended value range is 30 to 240.");
        this.addSchemaProperty("Catalog", "ReaderSchema", "com.sap.sql.catalog.reader.schema", "Unique string identifying catalog reader type.");
        this.addSchemaProperty("Catalog", "BufferEntryCount", "com.sap.sql.catalog.buffer.entrycount", "Maximum number of stored objects in catalog buffer.");
        this.addDataSourceProperty("StatementPool", "Capacity", "com.sap.sql.jdbc.stmtpool.capacity", "Capacity of a statement pool instance. Each physical database connection has assigned a statement pool. Setting this value to 0 disables statement pooling.");
        this.addSchemaProperty("TableBuffer", "BufferSizeKB", "com.sap.sql.buffer.buffersize_kb", "Maximum buffer size in KB.");
        this.addSchemaProperty("TableBuffer", "MaxRecordSize", "com.sap.sql.buffer.maxrecordsize", "Maximum record size in bytes.");
        this.addSchemaProperty("TableBuffer", "MaxLobSize", "com.sap.sql.buffer.maxlobsize", "Maximum LOB size in bytes.");
        this.addSchemaProperty("TableBuffer", "ReloadDelay", "com.sap.sql.buffer.reloaddelay", "Number of read accesses before invalidated buffer objects  are reloaded.");
        this.addSchemaProperty("TableBuffer", "DisplacementActive", "com.sap.sql.buffer.displacement.active", "Enables/Disables displacement of buffer objects.");
        this.addDataSourceProperty("TableBuffer", "BufferActive", "com.sap.sql.tablebuffer.manager.active", "Enables/Disables table buffering.");
        this.syncRootProperties();
    }

    public static synchronized OpenSQLConfiguration getInstance() throws SQLException {
        if (instance == null) {
            instance = new OpenSQLConfiguration();
            ContextFactory.setConfigurationManager(instance);
        }
        return instance;
    }

    public synchronized void addDataSource(String dataSourceName) {
        ContextFactory.addDataSource(dataSourceName);
        TRACE.debugT("OpenSQLConfiguration", "Data source " + dataSourceName + " registered");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Properties syncSchema(String schemaName) throws SQLException {
        Properties properties;
        ConfigurationHandler handler;
        block7: {
            Properties properties2;
            block6: {
                Configuration schema = null;
                String name = "OpenSQL/" + this.replaceIllegalChars(schemaName);
                handler = this.getConfigurationHandler();
                try {
                    try {
                        schema = this.getConfiguration(handler, name);
                        if (schema == null) {
                            TRACE.debugT("OpenSQLConfiguration", "syncSchema: Default properties returned for schema " + schemaName);
                            Properties properties3 = this.defaultSchemaProps;
                            Object var8_8 = null;
                            this.closeAllConfigurations(handler);
                            return properties3;
                        }
                        Properties props = this.syncProperties(handler, schema, name, 1);
                        if (props == null) {
                            TRACE.debugT("OpenSQLConfiguration", "syncSchema: Default properties returned for schema " + schemaName);
                            properties2 = this.defaultSchemaProps;
                            break block6;
                        }
                        TRACE.debugT("OpenSQLConfiguration", "syncSchema: Properties returned for schema " + schemaName);
                        properties = props;
                        break block7;
                    }
                    catch (ConfigurationException ex) {
                        throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.connect_1227", new Object[]{ex.getMessage()}, (Throwable)ex);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    this.closeAllConfigurations(handler);
                    throw throwable;
                }
            }
            Object var8_9 = null;
            this.closeAllConfigurations(handler);
            return properties2;
        }
        Object var8_10 = null;
        this.closeAllConfigurations(handler);
        return properties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Properties syncDataSource(String schemaName, String dataSourceName) throws SQLException {
        Properties properties;
        ConfigurationHandler handler;
        block7: {
            Properties properties2;
            block6: {
                Configuration dataSource = null;
                String name = "OpenSQL/" + this.replaceIllegalChars(schemaName) + "/" + this.replaceIllegalChars(dataSourceName);
                handler = this.getConfigurationHandler();
                try {
                    try {
                        dataSource = this.getConfiguration(handler, name);
                        if (dataSource == null) {
                            TRACE.debugT("OpenSQLConfiguration", "syncDataSource: Default properties returned for " + schemaName + "/" + dataSourceName);
                            Properties properties3 = this.defaultDataSourceProps;
                            Object var9_9 = null;
                            this.closeAllConfigurations(handler);
                            return properties3;
                        }
                        Properties props = this.syncProperties(handler, dataSource, name, 2);
                        if (props == null) {
                            TRACE.debugT("OpenSQLConfiguration", "syncDataSource: Default properties returned for " + schemaName + "/" + dataSourceName);
                            properties2 = this.defaultDataSourceProps;
                            break block6;
                        }
                        TRACE.debugT("OpenSQLConfiguration", "syncDataSource: Properties returned for " + schemaName + "/" + dataSourceName);
                        properties = props;
                        break block7;
                    }
                    catch (ConfigurationException ex) {
                        throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.connect_1227", new Object[]{ex.getMessage()}, (Throwable)ex);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    this.closeAllConfigurations(handler);
                    throw throwable;
                }
            }
            Object var9_10 = null;
            this.closeAllConfigurations(handler);
            return properties2;
        }
        Object var9_11 = null;
        this.closeAllConfigurations(handler);
        return properties;
    }

    private void syncRootProperties() throws SQLException {
        Configuration root = null;
        Properties props = null;
        ConfigurationHandler handler = this.getConfigurationHandler();
        try {
            try {
                try {
                    root = handler.openConfiguration(rootConfigName, 0);
                }
                catch (NameNotFoundException notFoundEx) {
                    TRACE.debugT("OpenSQLConfiguration", "syncRootProperties: Root configuration not available, try to create it");
                    try {
                        root = handler.createRootConfiguration(rootConfigName);
                        handler.commit();
                    }
                    catch (NameAlreadyExistsException existEx) {
                        TRACE.debugT("OpenSQLConfiguration", "syncRootProperties: Root configuration does already exists");
                        Object var8_7 = null;
                        this.closeAllConfigurations(handler);
                        return;
                    }
                    catch (ConfigurationLockedException lockedEx) {
                        TRACE.debugT("OpenSQLConfiguration", "syncRootProperties: Root configuration is already locked");
                        Object var8_8 = null;
                        this.closeAllConfigurations(handler);
                        return;
                    }
                    this.storeProperties(0, root);
                    handler.commit();
                    TRACE.debugT("OpenSQLConfiguration", "syncRootProperties: Initial Root configuration created");
                    Object var8_9 = null;
                    this.closeAllConfigurations(handler);
                    return;
                }
                props = this.syncProperties(handler, root, rootConfigName, 0);
                ContextFactory.setGeneralProperties(props);
                TRACE.debugT("OpenSQLConfiguration", "syncRootProperties: General properties of root configuration synced");
                handler.closeAllConfigurations();
                this.syncConnProperties(handler);
                TRACE.debugT("OpenSQLConfiguration", "syncRootProperties: Connection properties synced");
            }
            catch (ConfigurationException ex) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.connect_1227", new Object[]{ex.getMessage()}, (Throwable)ex);
            }
            Object var8_10 = null;
            this.closeAllConfigurations(handler);
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.closeAllConfigurations(handler);
            throw throwable;
        }
    }

    private void syncConnProperties(ConfigurationHandler handler) throws ConfigurationException, SQLException {
        Configuration root = handler.openConfiguration(rootConfigName, 0);
        Iterator schemaIter = root.getAllSubConfigurations().values().iterator();
        while (schemaIter.hasNext()) {
            Configuration schema = (Configuration)schemaIter.next();
            ConfigMetaData meta = schema.getMetaData();
            if (meta.getConfigurationType() != 0) continue;
            String schemaName = this.undoReplaceChars(meta.getName());
            try {
                Properties schemaProps = this.loadProperties(1, schema);
                ContextFactory.setSchemaProperties(schemaName, schemaProps);
                TRACE.debugT("OpenSQLConfiguration", "syncConnProperties: Properties for schema " + schemaName + " read");
                Iterator dsIter = schema.getAllSubConfigurations().values().iterator();
                while (dsIter.hasNext()) {
                    Configuration ds = (Configuration)dsIter.next();
                    ConfigMetaData dsMeta = ds.getMetaData();
                    if (dsMeta.getConfigurationType() != 0) continue;
                    String dsName = this.undoReplaceChars(dsMeta.getName());
                    try {
                        Properties dsProps = this.loadProperties(2, ds);
                        ContextFactory.setDataSourceProperties(schemaName, dsName, dsProps);
                        TRACE.debugT("OpenSQLConfiguration", "syncConnProperties: Properties for " + schemaName + "/" + dsName + " read");
                    }
                    catch (ConfigurationException ex) {
                        // empty catch block
                    }
                }
            }
            catch (ConfigurationException ex) {
                // empty catch block
            }
        }
    }

    private Configuration getConfiguration(ConfigurationHandler handler, String configName) throws ConfigurationException {
        Configuration config = null;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 15000L) {
            try {
                return handler.openConfiguration(configName, 0);
            }
            catch (NameNotFoundException notFoundEx) {
                TRACE.debugT("OpenSQLConfiguration", "getConfiguration: configuration " + configName + " not available, " + "try to create it");
                try {
                    config = handler.createSubConfiguration(configName);
                    handler.commit();
                    return config;
                }
                catch (NameAlreadyExistsException existEx) {
                    TRACE.debugT("OpenSQLConfiguration", "getConfiguration: configuration " + configName + " does " + "already exist");
                    return null;
                }
                catch (ConfigurationLockedException lockedEx) {
                    TRACE.debugT("OpenSQLConfiguration", "getConfiguration: configuration " + configName + " is already " + "locked, wait and try once more");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
            }
        }
        TRACE.debugT("OpenSQLConfiguration", "getConfiguration: time out on configuration " + configName);
        return null;
    }

    private Properties syncProperties(ConfigurationHandler handler, Configuration config, String configName, int propType) throws ConfigurationException {
        Properties props = null;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 15000L) {
            try {
                return this.loadProperties(propType, config);
            }
            catch (NameNotFoundException notFoundEx) {
                TRACE.debugT("OpenSQLConfiguration", "syncProperties: property sheets in configuration " + configName + " are missing, try to create them");
                handler.closeAllConfigurations();
                try {
                    config = handler.openConfiguration(configName, 1);
                    props = this.storeProperties(propType, config);
                    handler.commit();
                    return props;
                }
                catch (ConfigurationLockedException lockedEx) {
                    TRACE.debugT("OpenSQLConfiguration", "syncProperties: configuration " + configName + " is already " + "locked, wait and try once more");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    config = handler.openConfiguration(configName, 0);
                }
            }
            catch (InconsistentReadException ex) {
                TRACE.debugT("OpenSQLConfiguration", "syncProperties: inconsistent read on configuration " + configName + ", wait and try once more");
                handler.closeAllConfigurations();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                config = handler.openConfiguration(configName, 0);
            }
        }
        TRACE.debugT("OpenSQLConfiguration", "syncProperties: time out on configuration " + configName);
        return null;
    }

    private void closeAllConfigurations(ConfigurationHandler handler) {
        if (handler != null) {
            try {
                handler.closeAllConfigurations();
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
    }

    private Properties loadProperties(int propType, Configuration config) throws NameNotFoundException, InconsistentReadException, ConfigurationException {
        Properties props = new Properties();
        Map sheetMap = this.sheets[propType];
        Iterator sheetIter = sheetMap.entrySet().iterator();
        while (sheetIter.hasNext()) {
            Map.Entry entry = sheetIter.next();
            String sheetName = (String)entry.getKey();
            List sheetEntries = (List)entry.getValue();
            PropertySheet propSheet = config.getSubConfiguration(sheetName).getPropertySheetInterface();
            Iterator entryIter = sheetEntries.iterator();
            while (entryIter.hasNext()) {
                SheetEntry sheetEntry = (SheetEntry)entryIter.next();
                String value = (String)propSheet.getPropertyEntry(sheetEntry.entryName).getValue();
                props.setProperty(sheetEntry.propName, value);
            }
        }
        Map entries = config.getAllConfigEntries();
        Iterator iter = entries.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            props.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return props;
    }

    private Properties storeProperties(int propType, Configuration config) throws ConfigurationException {
        Properties props = new Properties();
        Map sheetMap = this.sheets[propType];
        Iterator sheetIter = sheetMap.entrySet().iterator();
        while (sheetIter.hasNext()) {
            Map.Entry entry = sheetIter.next();
            String sheetName = (String)entry.getKey();
            List sheetEntries = (List)entry.getValue();
            PropertySheet propSheet = this.getSubConfiguration(config, sheetName).getPropertySheetInterface();
            Iterator entryIter = sheetEntries.iterator();
            while (entryIter.hasNext()) {
                SheetEntry sheetEntry = (SheetEntry)entryIter.next();
                try {
                    String value = (String)propSheet.getPropertyEntry(sheetEntry.entryName).getValue();
                    props.setProperty(sheetEntry.propName, value);
                }
                catch (NameNotFoundException ex) {
                    propSheet.createPropertyEntry(sheetEntry.entryName, (Object)sheetEntry.defaultValue, sheetEntry.description);
                    props.setProperty(sheetEntry.propName, sheetEntry.defaultValue);
                }
            }
        }
        Map entries = config.getAllConfigEntries();
        Iterator iter = entries.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            props.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return props;
    }

    private Configuration getSubConfiguration(Configuration parent, String subConfigName) throws ConfigurationException {
        Configuration config;
        try {
            config = parent.getSubConfiguration(subConfigName);
        }
        catch (NameNotFoundException ex) {
            config = parent.createSubConfiguration(subConfigName, 1);
        }
        return config;
    }

    private ConfigurationHandler getConfigurationHandler() throws SQLException {
        if (this.configHandler != null) {
            return this.configHandler;
        }
        try {
            Class<?> clazz = (class$com$sap$sql$connect$OpenSQLConnectionFactory == null ? (class$com$sap$sql$connect$OpenSQLConnectionFactory = OpenSQLConfiguration.class$("com.sap.sql.connect.OpenSQLConnectionFactory")) : class$com$sap$sql$connect$OpenSQLConnectionFactory).getClassLoader().loadClass(rootClassName);
            ServiceContext context = (ServiceContext)clazz.getMethod(rootClassMethodName, null).invoke(null, null);
            if (context == null) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.connect_1228", new Object[]{"ApplicationServiceContext"});
            }
            CoreContext coreContext = context.getCoreContext();
            if (coreContext == null) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.connect_1228", new Object[]{"CoreContext"});
            }
            ConfigurationHandlerFactory factory = coreContext.getConfigurationHandlerFactory();
            if (factory == null) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.connect_1228", new Object[]{"ConfigurationHandlerFactory"});
            }
            ConfigurationHandler handler = factory.getConfigurationHandler();
            if (handler == null) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.connect_1228", new Object[]{"ConfigurationHandler"});
            }
            this.configHandler = handler;
            return handler;
        }
        catch (ClassNotFoundException ex) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0006", new Object[]{rootClassName});
        }
        catch (NoSuchMethodException ex) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0007", new Object[]{rootClassName}, (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0007", new Object[]{rootClassName}, (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0007", new Object[]{rootClassName}, ex.getTargetException());
        }
        catch (ConfigurationException ex) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.connect_1227", new Object[]{ex.getMessage()}, (Throwable)ex);
        }
    }

    private void addGeneralProperty(String sheetName, String entryName, String propName, String description) {
        String defaultValue = this.defaultProps.getProperty(propName);
        this.addProperty(this.generalSheets, sheetName, entryName, propName, defaultValue, description);
    }

    private void addSchemaProperty(String sheetName, String entryName, String propName, String description) {
        String defaultValue = this.defaultProps.getProperty(propName);
        this.defaultSchemaProps.setProperty(propName, defaultValue);
        this.addProperty(this.schemaSheets, sheetName, entryName, propName, defaultValue, description);
    }

    private void addDataSourceProperty(String sheetName, String entryName, String propName, String description) {
        String defaultValue = this.defaultProps.getProperty(propName);
        this.defaultDataSourceProps.setProperty(propName, defaultValue);
        this.addProperty(this.dataSourceSheets, sheetName, entryName, propName, defaultValue, description);
    }

    private void addProperty(Map sheets, String sheetName, String entryName, String propName, String defaultValue, String description) {
        Vector<SheetEntry> sheet = (Vector<SheetEntry>)sheets.get(sheetName);
        if (sheet == null) {
            sheet = new Vector<SheetEntry>();
            sheets.put(sheetName, sheet);
        }
        sheet.add(new SheetEntry(entryName, propName, defaultValue, description));
    }

    private String replaceIllegalChars(String name) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < name.length()) {
            char ch = name.charAt(i);
            switch (ch) {
                case '%': {
                    sb.append('~').append(':');
                    break;
                }
                case '[': {
                    sb.append('~').append('(');
                    break;
                }
                case ']': {
                    sb.append('~').append(')');
                    break;
                }
                case '#': {
                    sb.append('~').append('*');
                    break;
                }
                case '/': {
                    sb.append('~').append('|');
                    break;
                }
                case '~': {
                    sb.append('~').append('~');
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private String undoReplaceChars(String name) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < name.length()) {
            char ch = name.charAt(i);
            if (ch == '~') {
                switch (name.charAt(++i)) {
                    case ':': {
                        sb.append('%');
                        break;
                    }
                    case '(': {
                        sb.append('[');
                        break;
                    }
                    case ')': {
                        sb.append(']');
                        break;
                    }
                    case '*': {
                        sb.append('#');
                        break;
                    }
                    case '|': {
                        sb.append('/');
                        break;
                    }
                    case '~': {
                        sb.append('~');
                    }
                }
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SheetEntry {
        private String entryName;
        private String propName;
        private String defaultValue;
        private String description;

        public SheetEntry(String entryName, String propName, String defaultValue, String description) {
            this.entryName = entryName;
            this.propName = propName;
            this.defaultValue = defaultValue;
            this.description = description;
        }
    }
}

