/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.catalog.impl;

import com.sap.sql.catalog.Table;
import com.sap.sql.catalog.impl.CatalogBufferSynchronizer;
import com.sap.sql.sync.SyncManager;
import com.sap.tc.logging.Location;
import java.util.Hashtable;
import java.util.Random;
import java.util.Set;

class CatalogBuffer {
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$catalog$impl$CatalogBuffer == null ? (class$com$sap$sql$catalog$impl$CatalogBuffer = CatalogBuffer.class$("com.sap.sql.catalog.impl.CatalogBuffer")) : class$com$sap$sql$catalog$impl$CatalogBuffer));
    private String id;
    private long entryCount;
    private long displacementCount;
    private Random randomGenerator;
    private static final int NO_DISPLACEMENT = 0;
    private CatalogBufferSynchronizer synchronizer = null;
    private String syncId = null;
    private int referenceCount = 0;
    private Hashtable tableBuffer;
    private Hashtable existBuffer;
    static /* synthetic */ Class class$com$sap$sql$catalog$impl$CatalogBuffer;

    CatalogBuffer(String id, int entryCount) {
        this.id = id;
        this.entryCount = entryCount;
        this.displacementCount = 0L;
        this.randomGenerator = null;
        this.tableBuffer = new Hashtable();
        this.existBuffer = new Hashtable();
        TRACE.debugT("CatalogBuffer", "catalog buffer created (id = " + this.id + ", " + (this.entryCount == 0L ? "no displacement" : "entryCount = " + this.entryCount) + ").");
    }

    Table getTable(String schemaName, String tableName) {
        String qualifiedName = schemaName != null ? schemaName + "." + tableName : tableName;
        return (Table)this.tableBuffer.get(qualifiedName);
    }

    void setTable(String schemaName, String tableName, Table table) {
        String qualifiedName;
        String string = qualifiedName = schemaName != null ? schemaName + "." + tableName : tableName;
        if (this.entryCount > 0L && (long)this.tableBuffer.size() >= this.entryCount) {
            if (this.randomGenerator == null) {
                this.randomGenerator = new Random();
            }
            Set keySet = this.tableBuffer.keySet();
            Object[] keyArray = keySet.toArray();
            int random = this.randomGenerator.nextInt(keyArray.length);
            String key = (String)keyArray[random];
            this.tableBuffer.remove(key);
            ++this.displacementCount;
            TRACE.debugT("setTable", key + " displaced.");
        }
        TRACE.debugT("setTable", "set " + qualifiedName + ".");
        this.tableBuffer.put(qualifiedName, table);
    }

    Boolean getTableExistence(String schemaName, String tableName) {
        String qualifiedName = schemaName != null ? schemaName + "." + tableName : tableName;
        return (Boolean)this.existBuffer.get(qualifiedName);
    }

    void setTableExistence(String schemaName, String tableName, Boolean exists) {
        String qualifiedName = schemaName != null ? schemaName + "." + tableName : tableName;
        TRACE.debugT("setTableExistence", "set " + qualifiedName + ".");
        this.existBuffer.put(qualifiedName, exists);
    }

    String getId() {
        return this.id;
    }

    void setSyncId(String syncId) {
        this.syncId = syncId;
    }

    String getSyncId() {
        return this.syncId;
    }

    void setSynchronizer(CatalogBufferSynchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    void increaseReferenceCount() {
        ++this.referenceCount;
    }

    void decreaseReferenceCount() {
        --this.referenceCount;
    }

    int getReferenceCount() {
        return this.referenceCount;
    }

    long getEntryCount() {
        return this.entryCount;
    }

    long getDispalcementCount() {
        return this.displacementCount;
    }

    long getNumberOfEntries() {
        return this.tableBuffer.size();
    }

    long getNumberOfExistenceEntries() {
        return this.existBuffer.size();
    }

    Hashtable getTableBufferCollection() {
        return this.tableBuffer;
    }

    void invalidateTable(String schemaName, String tableName) {
        String qualifiedName = schemaName != null ? schemaName + "." + tableName : tableName;
        TRACE.debugT("invalidateTable", "remove " + qualifiedName + ".");
        CatalogBuffer catalogBuffer = this;
        synchronized (catalogBuffer) {
            this.tableBuffer.remove(qualifiedName);
            this.existBuffer.remove(qualifiedName);
        }
    }

    void resetBuffer() {
        TRACE.debugT("resetBuffer", "reset catalog buffer (id = " + this.id + ").");
        CatalogBuffer catalogBuffer = this;
        synchronized (catalogBuffer) {
            this.tableBuffer.clear();
            this.existBuffer.clear();
        }
    }

    void close() {
        this.resetBuffer();
        this.tableBuffer = null;
        this.existBuffer = null;
        SyncManager.getInstance().deregisterSender(this.syncId);
        SyncManager.getInstance().deregisterReceiver(this.syncId);
        if (this.synchronizer != null) {
            this.synchronizer.close();
            this.synchronizer = null;
        }
        this.syncId = null;
        TRACE.debugT("close", "catalog buffer (id = " + this.id + ") closed.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

