/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.catalog.data;

import com.sap.sql.catalog.Column;
import com.sap.sql.catalog.ColumnIterator;
import com.sap.sql.catalog.Table;
import com.sap.sql.catalog.data.ColumnData;
import com.sap.sql.catalog.data.ColumnDataIterator;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.util.HashMap;
import java.util.Map;

public final class TableData
implements Table,
Cloneable,
Comparable,
Externalizable {
    public static final int SERIAL_FORMAT_630a = 1;
    public static final int SERIAL_FORMAT_NONE = 0;
    public static final int SERIAL_FORMAT_DFLT = 1;
    private static final int FLAG_NOARGS_CONSTRUCTOR = 1;
    private static final int FLAG_VIEW = 2;
    private String m_schemaName;
    private String m_tableName;
    private ColumnData[] m_column;
    private transient ColumnData[] m_keyColumn;
    private transient Map m_columnMap;
    private int m_flags;
    private transient int m_primaryKeyCount;
    private int m_bufferKeyCount;
    private int m_clientColumnIdx;
    private transient boolean m_mutable;

    public TableData() {
        this.m_mutable = true;
        this.m_flags = 1;
        this.m_primaryKeyCount = 9999;
    }

    public TableData(String schemaName, String tableName, int tableType, int columnCount) {
        if (null == tableName || 0 == tableName.length()) {
            throw new IllegalArgumentException("given table name is null");
        }
        if (0 >= columnCount) {
            throw new IllegalArgumentException("table " + tableName + ": invalid column count");
        }
        if (1 != tableType && 2 != tableType) {
            throw new IllegalArgumentException("table " + tableName + ": invalid table type " + tableType);
        }
        this.m_schemaName = schemaName;
        this.m_tableName = tableName;
        this.m_flags = 2 == tableType ? 2 : 0;
        this.m_column = new ColumnData[columnCount];
        this.m_mutable = true;
        this.m_bufferKeyCount = -1;
        this.m_clientColumnIdx = -1;
        this.m_primaryKeyCount = 9999;
    }

    public TableData(Table srcTbl, boolean mutable) {
        this(srcTbl.getSchemaName(), srcTbl.getName(), srcTbl.getTableType(), srcTbl.getColumnCnt());
        ColumnIterator iter = srcTbl.getColumns();
        while (iter.hasNext()) {
            Column srcColumn = iter.next();
            new ColumnData(this, srcColumn.getName(), srcColumn.getPosition(), srcColumn.getPrimaryKeyPosition(), srcColumn.getJdbcType(), srcColumn.getTypeName(), srcColumn.getSize(), srcColumn.getDecimals(), srcColumn.isNullable(), srcColumn.getDefault());
        }
        this.setBufferKeyCount(srcTbl.getBufferKeyCnt());
        Column clientColumn = srcTbl.getClientColumn();
        if (null != clientColumn) {
            this.setClientColumnPosition(clientColumn.getPosition());
        }
        if (!mutable) {
            this.setImmutable();
        }
    }

    public void setImmutable() {
        if (!this.m_mutable) {
            this.immutableStateError();
        }
        if (0 != (this.m_flags & 1)) {
            throw new IllegalStateException("no-argument constructor must not be used");
        }
        this.m_columnMap = new HashMap(this.m_column.length * 4 / 3, 1.0f);
        int lastKeyIdx = 0;
        this.m_primaryKeyCount = 0;
        int i = 0;
        while (i < this.m_column.length) {
            ColumnData col = this.m_column[i];
            if (null == col) {
                throw new IllegalStateException("column at position " + (i + 1) + " has not been initialized");
            }
            int pkPos = col.getPrimaryKeyPosition();
            if (0 < pkPos) {
                lastKeyIdx = i;
                if (pkPos > this.m_primaryKeyCount) {
                    this.m_primaryKeyCount = pkPos;
                }
            }
            this.m_columnMap.put(col.getName(), col);
            ++i;
        }
        if (0 < this.m_primaryKeyCount) {
            this.m_keyColumn = new ColumnData[this.m_primaryKeyCount];
            int i2 = 0;
            while (i2 <= lastKeyIdx) {
                ColumnData col = this.m_column[i2];
                int pkIdx = col.getPrimaryKeyPosition() - 1;
                if (0 <= pkIdx) {
                    if (null != this.m_keyColumn[pkIdx]) {
                        throw new IllegalStateException("key column at position " + (pkIdx + 1) + " defined ambiguously");
                    }
                    this.m_keyColumn[pkIdx] = col;
                }
                ++i2;
            }
            int i3 = 0;
            while (i3 < this.m_primaryKeyCount) {
                if (null == this.m_keyColumn[i3]) {
                    throw new IllegalStateException("key column at position " + (i3 + 1) + " has not been initialized");
                }
                ++i3;
            }
        }
        this.m_mutable = false;
    }

    private void immutableStateError() {
        throw new IllegalStateException("table descriptor " + this.m_tableName + " is immutable");
    }

    private void mutableStateError() {
        throw new IllegalStateException("table descriptor " + this.m_tableName + " is mutable");
    }

    public void setBufferKeyCount(int bufferKeyCount) {
        if (!this.m_mutable) {
            this.immutableStateError();
        }
        if (-1 > bufferKeyCount || bufferKeyCount > this.m_column.length) {
            throw new IllegalArgumentException("table " + this.m_tableName + ": invalid buffer key count");
        }
        this.m_bufferKeyCount = bufferKeyCount;
    }

    public void setClientColumnPosition(int clientPosition) {
        if (!this.m_mutable) {
            this.immutableStateError();
        }
        if (0 > clientPosition || clientPosition > this.m_column.length) {
            throw new IllegalArgumentException("table " + this.m_tableName + ": invalid client column position");
        }
        if (0 == clientPosition) {
            this.m_clientColumnIdx = -1;
        } else if (null != this.m_column[clientPosition - 1]) {
            this.m_clientColumnIdx = clientPosition - 1;
        } else {
            throw new IllegalArgumentException("table " + this.m_tableName + ": column at position is not yet defined");
        }
    }

    void setColumn(ColumnData dependentColumn, int position) {
        if (!this.m_mutable) {
            this.immutableStateError();
        }
        if (0 >= position || position > this.m_column.length) {
            throw new IllegalArgumentException("table " + this.m_tableName + "." + dependentColumn.getName() + ": invalid position");
        }
        this.m_column[position - 1] = dependentColumn;
    }

    public String getSchemaName() {
        if (this.m_mutable) {
            this.mutableStateError();
        }
        return this.m_schemaName;
    }

    public String getName() {
        return this.m_tableName;
    }

    public int getColumnCnt() {
        return this.m_column.length;
    }

    public int getPrimaryKeyCnt() {
        return this.m_primaryKeyCount;
    }

    public int getBufferKeyCnt() {
        if (this.m_mutable) {
            this.mutableStateError();
        }
        return this.m_bufferKeyCount;
    }

    public Column getColumn(String columnName) {
        if (this.m_mutable) {
            this.mutableStateError();
        }
        return (Column)this.m_columnMap.get(columnName);
    }

    public Column getColumn(int position) {
        if (this.m_mutable) {
            this.mutableStateError();
        }
        return 0 > position || position > this.m_column.length ? null : this.m_column[position - 1];
    }

    public ColumnIterator getColumns() {
        if (this.m_mutable) {
            this.mutableStateError();
        }
        return new ColumnDataIterator(this);
    }

    public Column getPrimaryKeyColumn(int position) {
        if (this.m_mutable) {
            this.mutableStateError();
        }
        return 0 >= position || position > this.m_primaryKeyCount ? null : this.m_keyColumn[position - 1];
    }

    public int getTableType() {
        if (this.m_mutable) {
            this.mutableStateError();
        }
        return 0 != (this.m_flags & 2) ? 2 : 1;
    }

    public boolean isClientDependent() {
        if (this.m_mutable) {
            this.mutableStateError();
        }
        return 0 <= this.m_clientColumnIdx;
    }

    public Column getClientColumn() {
        if (this.m_mutable) {
            this.mutableStateError();
        }
        return 0 > this.m_clientColumnIdx ? null : this.m_column[this.m_clientColumnIdx];
    }

    public Object clone() {
        TableData rslt;
        if (this.m_mutable) {
            this.mutableStateError();
        }
        try {
            rslt = (TableData)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException("clone() should be allowed");
        }
        rslt.m_mutable = true;
        rslt.m_column = new ColumnData[this.m_column.length];
        int i = this.m_column.length;
        while (0 <= --i) {
            rslt.m_column[i] = new ColumnData(this.m_column[i], rslt, false);
        }
        rslt.m_columnMap = null;
        rslt.m_keyColumn = null;
        rslt.m_primaryKeyCount = 9999;
        return rslt;
    }

    public int compareTo(Object o) {
        if (this.m_mutable) {
            this.mutableStateError();
        }
        TableData aTable = (TableData)o;
        if (this.m_schemaName == aTable.m_schemaName) {
            return this.m_tableName.compareTo(aTable.m_tableName);
        }
        if (null == this.m_schemaName) {
            return -1;
        }
        if (null == aTable.m_schemaName) {
            return 1;
        }
        return this.m_schemaName.compareTo(aTable.m_schemaName);
    }

    public boolean equals(Object o) {
        if (this.m_mutable) {
            this.mutableStateError();
        }
        TableData aTable = (TableData)o;
        if (this.m_schemaName == aTable.m_schemaName) {
            return this.m_tableName.equals(aTable.m_tableName);
        }
        if (null == this.m_schemaName || null == aTable.m_schemaName) {
            return false;
        }
        return this.m_schemaName.equals(aTable.m_schemaName);
    }

    public int hashCode() {
        if (this.m_mutable) {
            this.mutableStateError();
        }
        return this.m_tableName.hashCode();
    }

    public void readExternal(ObjectInput in) throws IOException {
        if (!this.m_mutable) {
            this.immutableStateError();
        }
        if (0 == (this.m_flags & 1)) {
            throw new IllegalStateException("object can not be re-initialized using de-serialization");
        }
        TableData.readExternal(this, in);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal(out, 1);
    }

    public static boolean serialFormatWritable(int fmtVersion) {
        return 1 == fmtVersion;
    }

    public static boolean serialFormatReadable(int fmtVersion) {
        return 1 == fmtVersion;
    }

    public TableData(ObjectInput in) throws IOException {
        this();
        TableData.readExternal(this, in);
    }

    private static void readExternal(TableData dest, ObjectInput in) throws IOException {
        int fmtVersion = in.readInt();
        if (1 != fmtVersion) {
            throw new StreamCorruptedException("serialization format version #" + fmtVersion + " can not be read");
        }
        dest.m_schemaName = in.readBoolean() ? in.readUTF() : null;
        dest.m_tableName = in.readUTF();
        dest.m_flags = in.readInt();
        dest.m_bufferKeyCount = in.readInt();
        dest.m_clientColumnIdx = in.readInt();
        dest.m_column = new ColumnData[in.readInt()];
        int i = 0;
        while (i < dest.m_column.length) {
            dest.m_column[i] = new ColumnData(in, dest, fmtVersion);
            ++i;
        }
        dest.setImmutable();
    }

    public void writeExternal(ObjectOutput out, int fmtVersion) throws IOException {
        if (this.m_mutable) {
            this.mutableStateError();
        }
        if (1 != fmtVersion) {
            throw new NotActiveException("requested external format not supported: " + fmtVersion);
        }
        out.writeInt(1);
        if (null == this.m_schemaName || 0 == this.m_schemaName.length()) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.m_schemaName);
        }
        out.writeUTF(this.m_tableName);
        out.writeInt(this.m_flags);
        out.writeInt(this.m_bufferKeyCount);
        out.writeInt(this.m_clientColumnIdx);
        out.writeInt(this.m_column.length);
        int i = 0;
        while (i < this.m_column.length) {
            this.m_column[i].writeExternal(out, fmtVersion);
            ++i;
        }
    }
}

