/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.buffer;

import com.sap.sql.buffer.TBJBuffer;
import com.sap.sql.buffer.TBJBufferObject;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class TBJBufferTransactionHandling {
    static final int TX_SIZE = 48;
    static final int TX_ENTRY_SIZE = 52;
    static final int TX_MOD_SIZE = 16;
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$buffer$TBJBufferTransactionHandling == null ? (class$com$sap$sql$buffer$TBJBufferTransactionHandling = TBJBufferTransactionHandling.class$("com.sap.sql.buffer.TBJBufferTransactionHandling")) : class$com$sap$sql$buffer$TBJBufferTransactionHandling));
    private Map modifications = new HashMap();
    private long modCount = 0L;
    static /* synthetic */ Class class$com$sap$sql$buffer$TBJBufferTransactionHandling;

    TBJBufferTransactionHandling(TBJBuffer buffer) {
        buffer.reduceFreeBytes(48L);
    }

    void clear(TBJBuffer buffer) {
        Iterator iter = this.modifications.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Set objects = (Set)entry.getValue();
            buffer.reduceFreeBytes(52 + 16 * objects.size());
            objects.clear();
        }
        this.modifications.clear();
        this.modCount = 0L;
    }

    void setModification(TBJBuffer buffer, Object transaction, TBJBufferObject object) {
        if (transaction == null) {
            return;
        }
        HashSet<TBJBufferObject> objects = (HashSet<TBJBufferObject>)this.modifications.get(transaction);
        if (objects == null) {
            objects = new HashSet<TBJBufferObject>();
            this.modifications.put(transaction, objects);
            buffer.reduceFreeBytes(52L);
        }
        if (objects.add(object)) {
            object.incrementFixingCounter();
            ++this.modCount;
            buffer.reduceFreeBytes(16L);
        }
    }

    Set getModifiedObjects(Object transaction) {
        return (Set)this.modifications.get(transaction);
    }

    void clearModification(TBJBuffer buffer, Object transaction, TBJBufferObject object) {
        if (transaction == null) {
            return;
        }
        Set objects = (Set)this.modifications.get(transaction);
        if (objects != null) {
            if (objects.remove(object)) {
                --this.modCount;
                buffer.incrementFreeBytes(16L);
            }
            if (objects.isEmpty()) {
                this.modifications.remove(transaction);
                buffer.incrementFreeBytes(52L);
            }
        }
    }

    void clearTransaction(TBJBuffer buffer, Object transaction) {
        Set objects;
        if (transaction != null && (objects = (Set)this.modifications.get(transaction)) != null) {
            buffer.incrementFreeBytes(52 + 16 * objects.size());
            this.modCount -= (long)objects.size();
            objects.clear();
            this.modifications.remove(transaction);
        }
    }

    void clearModifications(TBJBuffer buffer, TBJBufferObject object) {
        ArrayList allTransactions = new ArrayList(this.modifications.keySet());
        int i = 0;
        while (i < allTransactions.size()) {
            Object transaction = allTransactions.get(i);
            this.clearModification(buffer, transaction, object);
            ++i;
        }
    }

    int getTxCount() {
        return this.modifications.size();
    }

    long getModCount() {
        return this.modCount;
    }

    int checkTxHandling(TBJBuffer buffer, TBJBufferObject[] tempDir) {
        long mods = 0L;
        int errorCode = 0;
        int i = 0;
        while (i < tempDir.length) {
            TBJBufferObject object = tempDir[i];
            mods += (long)object.getFixingCounter();
            ++i;
        }
        if (mods != this.modCount) {
            errorCode = 1;
            if (buffer.isDebugOn()) {
                buffer.trace(100, TRACE, "Check-Error(" + errorCode + "): ModCount is false");
            }
        }
        return errorCode;
    }

    long size() {
        long sum = (long)(48 + this.getTxCount() * 52) + this.modCount * 16L;
        return sum;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

