/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.buffer;

import com.sap.sql.buffer.IllegalArgumentException;
import com.sap.sql.buffer.TBJBuffer;
import com.sap.sql.buffer.TBJBufferDate;
import com.sap.sql.buffer.TBJBufferRecordAbstract;
import com.sap.sql.buffer.TBJBufferTime;
import com.sap.sql.buffer.TypeMismatchException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

class TBJBufferRecord
extends TBJBufferRecordAbstract {
    static final TBJBufferRecord NOT_FOUND_RECORD = new TBJBufferRecord(0);
    private static final int BASIC_SIZE = 16;
    private long size = 16L;

    TBJBufferRecord(int size) {
        this.columns = new Object[size];
        int i = 0;
        while (i < size) {
            this.columns[i] = TBJBufferRecordAbstract.UNDEFINED;
            ++i;
        }
        this.size += (long)(4 * size);
    }

    TBJBufferRecord(Object[] cols) {
        this.columns = cols;
        this.size += (long)(4 * cols.length);
    }

    public void setString(int index, String value) throws IllegalArgumentException {
        super.setString(index, value);
        this.size += value == null ? 0L : (long)(24 + value.length() * 2);
    }

    public void setInteger(int index, Integer value) throws IllegalArgumentException {
        super.setInteger(index, value);
        this.size += 16L;
    }

    public void setShort(int index, Short value) throws IllegalArgumentException {
        super.setShort(index, value);
        this.size += 16L;
    }

    public void setLong(int index, Long value) throws IllegalArgumentException {
        super.setLong(index, value);
        this.size += 16L;
    }

    public void setFloat(int index, Float value) throws IllegalArgumentException {
        super.setFloat(index, value);
        this.size += 16L;
    }

    public void setDouble(int index, Double value) throws IllegalArgumentException {
        super.setDouble(index, value);
        this.size += 16L;
    }

    public void setBigInteger(int index, BigInteger value) throws IllegalArgumentException {
        super.setBigInteger(index, value);
        this.size += value == null ? 0L : (long)(48 + value.bitLength() / 8);
    }

    public void setBigDecimal(int index, BigDecimal value) throws IllegalArgumentException {
        super.setBigDecimal(index, value);
        this.size += value == null ? 0L : (long)(48 + value.toBigInteger().bitLength() / 8);
    }

    public void setBoolean(int index, Boolean value) throws IllegalArgumentException {
        super.setBoolean(index, value);
        this.size += 16L;
    }

    public void setByte(int index, Byte value) throws IllegalArgumentException {
        super.setByte(index, value);
        this.size += 16L;
    }

    public void setByteArray(int index, byte[] value) throws IllegalArgumentException {
        super.setByteArray(index, value);
        this.size += value == null ? 0L : (long)(8 + value.length);
    }

    public void setCharArray(int index, char[] value) throws IllegalArgumentException {
        super.setCharArray(index, value);
        this.size += value == null ? 0L : (long)(8 + value.length * 2);
    }

    public void setCharacter(int index, Character value) throws IllegalArgumentException {
        super.setCharacter(index, value);
        this.size += 2L;
    }

    public void setDate(int index, Date value) throws IllegalArgumentException {
        super.setDate(index, value);
        this.size += value == null ? 0L : 96L;
    }

    public void setTime(int index, Time value) throws IllegalArgumentException {
        super.setTime(index, value);
        this.size += value == null ? 0L : 96L;
    }

    public void setTimestamp(int index, Timestamp value) throws IllegalArgumentException {
        super.setTimestamp(index, value);
        this.size += value == null ? 0L : 24L;
    }

    long size() {
        return this.size;
    }

    void update(TBJBuffer buffer, TBJBufferRecord template) throws TypeMismatchException {
        int i = 0;
        while (i < this.columns.length) {
            if (this.columns[i] == TBJBufferRecordAbstract.UNDEFINED) {
                Object value;
                this.columns[i] = value = template.columns[i];
                if (value instanceof String) {
                    this.size += (long)(24 + ((String)value).length() * 2);
                } else if (value instanceof Integer) {
                    this.size += 16L;
                } else if (value instanceof Short) {
                    this.size += 16L;
                } else if (value instanceof Long) {
                    this.size += 16L;
                } else if (value instanceof Float) {
                    this.size += 16L;
                } else if (value instanceof Double) {
                    this.size += 16L;
                } else if (value instanceof Byte) {
                    this.size += 16L;
                } else if (value instanceof TBJBufferDate) {
                    this.size += 96L;
                } else if (value instanceof TBJBufferTime) {
                    this.size += 96L;
                } else if (value instanceof Timestamp) {
                    this.size += 24L;
                } else if (value instanceof byte[]) {
                    this.size += (long)(8 + ((byte[])value).length);
                } else if (value instanceof BigDecimal) {
                    this.size += (long)(48 + ((BigDecimal)value).toBigInteger().bitLength() / 8);
                } else if (value instanceof char[]) {
                    this.size += (long)(8 + ((char[])value).length * 2);
                } else if (value instanceof Character) {
                    this.size += 2L;
                } else if (value instanceof BigInteger) {
                    this.size += (long)(48 + ((BigInteger)value).bitLength() / 8);
                } else if (value instanceof Boolean) {
                    this.size += 16L;
                } else if (value != null) {
                    throw (TypeMismatchException)buffer.getAndLogBufferException(14, this.getClass(), "update", new Object[]{"column class of old record " + value.getClass().toString() + " is not supported"});
                }
            }
            ++i;
        }
    }
}

