/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.buffer;

import com.sap.sql.buffer.BufferObjectInfo;
import com.sap.sql.buffer.BufferRecord;
import com.sap.sql.buffer.TBJBufferData;
import com.sap.sql.buffer.TBJBufferStatus;
import com.sap.sql.buffer.TBJBufferTable;
import com.sap.sql.buffer.monitor.BufferMonitorObjectInfo;
import java.text.DecimalFormat;
import java.text.FieldPosition;

public class TBJBufferObjectInfo
extends BufferObjectInfo
implements BufferMonitorObjectInfo {
    private static DecimalFormat formatter = new DecimalFormat("###,###,###,###,###,###,###");
    private static FieldPosition pos = new FieldPosition(0);
    private String bufType;
    private boolean isDummy;
    private long recordCount;
    private long notFounds;
    private long genKeyCount;
    private long keyCount;
    private long columnCount;
    private long successfulReads;
    private long missedReads;
    private long invalidations;
    private long successfulModifications;
    private long missedModifications;
    private long dataSize;
    private long totalSize;
    private long reloadCounter;
    private long fixingCounter;
    private long hotObjectLocks;
    private long openCursors;
    private long usedCounter;
    private boolean dataIsNull;
    private int reachable;
    private String status;

    public TBJBufferObjectInfo(String name, BufferRecord genericKey, int bufType, boolean isDummy, int recordCount, int notFounds, int keyCount, int genKeyCount, int columnCount, long successfulReads, long missedReads, long invalidations, long successfulModifications, long missedModifications, long dataSize, long totalSize, int reloadCounter, int fixingCounter, int hotObjectLocks, int openCursors, int usedCounter, boolean dataIsNull, int reachable, int status) {
        super(name, genericKey);
        this.bufType = TBJBufferTable.printType(bufType);
        this.isDummy = isDummy;
        this.recordCount = recordCount;
        this.notFounds = notFounds;
        this.keyCount = keyCount;
        this.genKeyCount = genKeyCount;
        this.columnCount = columnCount;
        this.successfulReads = successfulReads;
        this.missedReads = missedReads;
        this.invalidations = invalidations;
        this.successfulModifications = successfulModifications;
        this.missedModifications = missedModifications;
        this.dataSize = dataSize;
        this.totalSize = totalSize;
        this.reloadCounter = reloadCounter;
        this.fixingCounter = fixingCounter;
        this.hotObjectLocks = hotObjectLocks;
        this.openCursors = openCursors;
        this.usedCounter = usedCounter;
        this.dataIsNull = dataIsNull;
        this.reachable = reachable;
        this.status = TBJBufferStatus.printStatus(status);
    }

    public String getObjectName() {
        return this.name + (this.genericKey != null ? "; " + this.getKey() : "");
    }

    public String getTableName() {
        return this.getName();
    }

    public String getKey() {
        BufferRecord genKey = this.getGenericKey();
        return genKey == null ? "" : genKey.toString();
    }

    public String getBufType() {
        return this.bufType;
    }

    public boolean isDummy() {
        return this.isDummy;
    }

    public long getRecordCount() {
        return this.recordCount;
    }

    public long getNotFounds() {
        return this.notFounds;
    }

    public long getGenKeyCount() {
        return this.genKeyCount;
    }

    public long getKeyCount() {
        return this.keyCount;
    }

    public long getColumnCount() {
        return this.columnCount;
    }

    public long getSuccessfulReads() {
        return this.successfulReads;
    }

    public long getMissedReads() {
        return this.missedReads;
    }

    public long getSuccessfulModifications() {
        return this.successfulModifications;
    }

    public long getMissedModifications() {
        return this.missedModifications;
    }

    public long getInvalidations() {
        return this.invalidations;
    }

    public long getUsedCounter() {
        return this.usedCounter;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public long getReloadCounter() {
        return this.reloadCounter;
    }

    public long getFixingCounter() {
        return this.fixingCounter;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isDataNull() {
        return this.dataIsNull;
    }

    public long getHotObjectLocks() {
        return this.hotObjectLocks;
    }

    public long getOpenCursors() {
        return this.openCursors;
    }

    public String getReachability() {
        return TBJBufferData.printReachability(this.reachable);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Table= " + this.name);
        buf.append(", GenKey= ");
        if (this.genericKey == null) {
            buf.append("null");
        } else {
            buf.append(this.genericKey.toString());
        }
        buf.append(", Type= " + this.bufType);
        if (this.isDummy) {
            buf.append(" DUMMY ");
        }
        buf.append(", Status= " + this.status);
        buf.append(", reachable= " + TBJBufferData.printReachability(this.reachable));
        buf.append(", #Records= " + this.recordCount);
        buf.append(", #NotFounds= " + this.notFounds);
        buf.append(", Hot= " + this.hotObjectLocks);
        buf.append(", Open= " + this.openCursors);
        buf.append(", Fix= " + this.fixingCounter);
        buf.append(", Reload= " + this.reloadCounter);
        buf.append(", DataSize= " + this.dataSize);
        buf.append(", TotalSize= " + this.totalSize);
        buf.append(", Used= " + this.usedCounter);
        buf.append(", Read+= " + this.successfulReads);
        buf.append(", Read-= " + this.missedReads);
        buf.append(", Inval= " + this.invalidations);
        buf.append(", Mod+= " + this.successfulModifications);
        buf.append(", Mod-= " + this.missedModifications);
        buf.append(", Keys= " + this.keyCount);
        buf.append(", GenKeys= " + this.genKeyCount);
        buf.append(", Columns= " + this.columnCount);
        return buf.toString();
    }

    public String getHtmlHeader() {
        StringBuffer header = new StringBuffer();
        header.append("<tr>");
        header.append("<th>Table</th>");
        header.append("<th>Generic Key</th>");
        header.append("<th>Type</th>");
        header.append("<th>Status</th>");
        header.append("<th>#Records</th>");
        header.append("<th>#NotFounds</th>");
        header.append("<th>DataSize</th>");
        header.append("<th>TotalSize</th>");
        header.append("<th>ReloadCounter</th>");
        header.append("<th>FixingCounter</th>");
        header.append("<th>HotObjectLocks</th>");
        header.append("<th>OpenCursors</th>");
        header.append("<th>Used</th>");
        header.append("<th>Read+</th>");
        header.append("<th>Read-</th>");
        header.append("<th>Inval</th>");
        header.append("<th>Mod+</th>");
        header.append("<th>Mod-</th>");
        header.append("<th>Is Dummy</th>");
        header.append("<th>Reachable</th>");
        header.append("<th>#Keys</th>");
        header.append("<th>#GenKeys</th>");
        header.append("<th>#Columns</th>");
        header.append("</tr>");
        return header.toString();
    }

    public String getHtmlRow() {
        StringBuffer row = new StringBuffer();
        row.append("<tr>");
        row.append("<td>" + this.name + "</td>");
        row.append("<td>" + (this.genericKey == null ? "null" : this.genericKey.toString()) + "</td>");
        row.append("<td>" + this.bufType + "</td>");
        row.append("<td>" + this.status + "</td><td>");
        formatter.format(this.recordCount, row, pos);
        row.append("</td><td>");
        formatter.format(this.notFounds, row, pos);
        row.append("</td><td>");
        formatter.format(this.dataSize, row, pos);
        row.append("</td><td>");
        formatter.format(this.totalSize, row, pos);
        row.append("</td>");
        row.append("<td>" + this.reloadCounter + "</td>");
        row.append("<td>" + this.fixingCounter + "</td>");
        row.append("<td>" + this.hotObjectLocks + "</td>");
        row.append("<td>" + this.openCursors + "</td><td>");
        formatter.format(this.usedCounter, row, pos);
        row.append("</td><td>");
        formatter.format(this.successfulReads, row, pos);
        row.append("</td><td>");
        formatter.format(this.missedReads, row, pos);
        row.append("</td><td>");
        formatter.format(this.invalidations, row, pos);
        row.append("</td><td>");
        formatter.format(this.successfulModifications, row, pos);
        row.append("</td><td>");
        formatter.format(this.missedModifications, row, pos);
        row.append("</td>");
        row.append("<td>" + this.isDummy + "</td>");
        row.append("<td>" + TBJBufferData.printReachability(this.reachable) + "</td>");
        row.append("<td>" + this.keyCount + "</td>");
        row.append("<td>" + this.genKeyCount + "</td>");
        row.append("<td>" + this.columnCount + "</td>");
        row.append("</tr>");
        return row.toString();
    }
}

