/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.buffer;

import com.sap.sql.buffer.TBJBuffer;
import com.sap.sql.buffer.TBJBufferDirectoryIterator;
import com.sap.sql.buffer.TBJBufferKey;
import com.sap.sql.buffer.TBJBufferObject;
import com.sap.sql.buffer.TBJBufferTable;
import com.sap.sql.buffer.TypeMismatchException;
import com.sap.tc.logging.Location;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

class TBJBufferGenericDirectory {
    static final int GENDIR_SIZE = 8;
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$buffer$TBJBufferGenericDirectory == null ? (class$com$sap$sql$buffer$TBJBufferGenericDirectory = TBJBufferGenericDirectory.class$("com.sap.sql.buffer.TBJBufferGenericDirectory")) : class$com$sap$sql$buffer$TBJBufferGenericDirectory));
    private TBJBufferTable table;
    private SortedMap genericRegions = new TreeMap();
    static /* synthetic */ Class class$com$sap$sql$buffer$TBJBufferGenericDirectory;

    TBJBufferGenericDirectory(TBJBuffer buffer, TBJBufferTable table) {
        this.table = table;
        buffer.reduceFreeBytes(36L);
    }

    TBJBufferObject getObject(TBJBuffer buffer, TBJBufferKey genKey) throws TypeMismatchException {
        if (genKey == null) {
            genKey = new TBJBufferKey();
        }
        try {
            return (TBJBufferObject)this.genericRegions.get(genKey);
        }
        catch (ClassCastException ex) {
            throw (TypeMismatchException)buffer.getAndLogBufferException(14, this.getClass(), "getObject", new Object[]{"while searching generic region with key \"" + genKey.toString() + "\" of object \"" + this.table.getTableName() + "\""}, ex);
        }
    }

    TBJBufferDirectoryIterator getObjects() {
        TBJBufferKey genKey = new TBJBufferKey();
        return new TBJBufferDirectoryIterator(this.genericRegions.tailMap(genKey));
    }

    TBJBufferDirectoryIterator getObjects(TBJBuffer buffer, TBJBufferKey key) throws TypeMismatchException {
        try {
            if (this.genericRegions.containsKey(key)) {
                return new TBJBufferDirectoryIterator((TBJBufferObject)this.genericRegions.get(key));
            }
            return new TBJBufferDirectoryIterator(this.genericRegions.tailMap(key));
        }
        catch (ClassCastException ex) {
            throw (TypeMismatchException)buffer.getAndLogBufferException(14, this.getClass(), "getObjects", new Object[]{"while iterating over generic regions with key \"" + key.toString() + "\""}, ex);
        }
    }

    SortedMap getGenericRegions() {
        return this.genericRegions;
    }

    SortedMap getGenericRegions(TBJBuffer buffer, TBJBufferKey key) throws TypeMismatchException {
        try {
            return this.genericRegions.tailMap(key);
        }
        catch (ClassCastException ex) {
            throw (TypeMismatchException)buffer.getAndLogBufferException(14, this.getClass(), "getGenericRegions", new Object[]{"while searching generic region with key= \"" + key.toString() + "\" of object \"" + this.table.getTableName() + "\""}, ex);
        }
    }

    TBJBufferObject checkDummies(TBJBuffer buffer, TBJBufferKey key) throws TypeMismatchException {
        int givenKeyCount = key.getValueCount();
        int i = 0;
        while (i < givenKeyCount) {
            TBJBufferKey genKey = key.getKey(i, null);
            TBJBufferObject dummy = this.getObject(buffer, genKey);
            if (dummy != null && dummy.isDummy()) {
                return dummy;
            }
            ++i;
        }
        return null;
    }

    TBJBufferObject addObject(TBJBuffer buffer, TBJBufferKey genKey, boolean isDummy) throws TypeMismatchException {
        TBJBufferObject object = new TBJBufferObject(buffer, this.table, genKey, isDummy);
        try {
            this.genericRegions.put(genKey, object);
            buffer.reduceFreeBytes(16L);
        }
        catch (ClassCastException ex) {
            throw (TypeMismatchException)buffer.getAndLogBufferException(14, this.getClass(), "addObject", new Object[]{"while adding object \"" + this.table.getTableName() + "\" with generic key \"" + genKey + "\""}, ex);
        }
        return object;
    }

    boolean delObject(TBJBuffer buffer, TBJBufferKey genKey) throws TypeMismatchException {
        Object removedObject;
        if (this.genericRegions == null) {
            return false;
        }
        try {
            removedObject = this.genericRegions.remove(genKey);
            buffer.incrementFreeBytes(16L);
        }
        catch (ClassCastException ex) {
            throw (TypeMismatchException)buffer.getAndLogBufferException(14, this.getClass(), "delObject", new Object[]{"while deleting object \"" + this.table.getTableName() + "\" with generic key \"" + genKey.toString() + "\""}, ex);
        }
        return removedObject != null;
    }

    int clear(TBJBuffer buffer) {
        int clearedObjects = 0;
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "---> TableBufferGenericDirectory.clear");
        }
        if (this.genericRegions != null) {
            Iterator iter = this.genericRegions.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                TBJBufferObject object = (TBJBufferObject)entry.getValue();
                object.clear(buffer);
                ++clearedObjects;
            }
            this.genericRegions.clear();
        }
        this.genericRegions = null;
        buffer.incrementFreeBytes(36 + 16 * clearedObjects);
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "<--- TableBufferGenericDirectory.clear");
        }
        return clearedObjects;
    }

    void invalidate(TBJBuffer buffer, boolean txRuns) {
        Set entries = this.genericRegions.entrySet();
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            TBJBufferObject object = (TBJBufferObject)entry.getValue();
            object.beginModification();
            object.invalidate(buffer, txRuns);
            object.endModification();
        }
    }

    int getGenericRegionCount() {
        return this.genericRegions == null ? 0 : this.genericRegions.size();
    }

    long size() {
        long sum = 36L;
        Set entrySet = this.genericRegions.entrySet();
        Iterator iter = entrySet.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            TBJBufferObject object = (TBJBufferObject)entry.getValue();
            sum += object.size() + 16L;
        }
        return sum;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

