/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql;

import java.util.GregorianCalendar;

public final class DateTimeNormalizer {
    private static final ThreadLocal LOCAL_CALENDAR = new ThreadLocal(){

        protected Object initialValue() {
            return new SpecialCalendar();
        }
    };

    private DateTimeNormalizer() {
    }

    public static final long normalizeSqlDateMillies(long milliSeconds) {
        SpecialCalendar cal = (SpecialCalendar)LOCAL_CALENDAR.get();
        cal.setTimeInMillis(milliSeconds);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public static final long normalizeSqlTimeMillies(long milliSeconds) {
        SpecialCalendar cal = (SpecialCalendar)LOCAL_CALENDAR.get();
        cal.setTimeInMillis(milliSeconds);
        cal.set(6, 1);
        cal.set(1, 1970);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    private static final class SpecialCalendar
    extends GregorianCalendar {
        private SpecialCalendar() {
        }

        public long getTimeInMillis() {
            return super.getTimeInMillis();
        }

        public void setTimeInMillis(long millis) {
            super.setTimeInMillis(millis);
        }
    }
}

