/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.is.stringxml.impl;

import com.sap.sdm.is.stringxml.StringXMLizer;
import com.sap.sdm.util.xml.XMLFilter;
import java.util.Stack;

class StringXMLizerImpl
implements StringXMLizer {
    private static final String TAGSTART = "<";
    private static final String TAGEND = ">";
    private static final String ENDTAGSTART = "</";
    private static final String XMLHEADER = "<?xml version=\"1.0\"?>";
    private static final String XMLCDATABEGIN = "<![CDATA[";
    private static final String XMLCDATAEND = "]]>";
    private String rootElemName = null;
    private String currentElemName = null;
    private StringBuffer buffer = null;
    private Stack startedElems = null;

    StringXMLizerImpl(String rootElemName) {
        this(rootElemName, new String[0], new String[0]);
    }

    StringXMLizerImpl(String rootElemName, String rootAttrName, String rootAttrValue) {
        this(rootElemName, new String[]{rootAttrName}, new String[]{rootAttrValue});
    }

    StringXMLizerImpl(String rootElemName, String[] rootAttrNames, String[] rootAttrValues) {
        this.checkElemName(rootElemName);
        this.checkAttrNames(rootAttrNames);
        this.checkAttrValues(rootAttrValues);
        this.checkLength(rootAttrNames, rootAttrValues);
        this.rootElemName = rootElemName;
        this.currentElemName = rootElemName;
        this.buffer = new StringBuffer(XMLHEADER);
        this.startedElems = new Stack();
        this.buffer.append(TAGSTART);
        this.buffer.append(rootElemName);
        int i = 0;
        while (i < rootAttrNames.length) {
            this.buffer.append(" ");
            this.buffer.append(rootAttrNames[i]);
            this.buffer.append("=\"");
            this.buffer.append(XMLFilter.checkAndFilterOutput(rootAttrValues[i]));
            this.buffer.append("\"");
            ++i;
        }
        this.buffer.append(TAGEND);
    }

    public void addElemWithContent(String name, String content) {
        this.addElemWithAttrsAndContent(name, new String[0], new String[0], content);
    }

    public void addElemWithContentCDATA(String name, String content) {
        StringBuffer dummy = new StringBuffer(XMLCDATABEGIN);
        dummy.append(content);
        dummy.append(XMLCDATAEND);
        this.addElemWithAttrsAndContent(name, new String[0], new String[0], dummy.toString());
    }

    public void addElemWithAttrAndContent(String name, String attrName, String attrValue, String content) {
        this.addElemWithAttrsAndContent(name, new String[]{attrName}, new String[]{attrValue}, content);
    }

    public void addElemWithAttrsAndContent(String name, String[] attrNames, String[] attrValues, String content) {
        this.checkElemName(name);
        this.checkAttrNames(attrNames);
        this.checkAttrValues(attrValues);
        this.checkLength(attrNames, attrValues);
        this.buffer.append(TAGSTART);
        this.buffer.append(name);
        int i = 0;
        while (i < attrNames.length) {
            this.buffer.append(" ");
            this.buffer.append(attrNames[i]);
            this.buffer.append("=\"");
            this.buffer.append(XMLFilter.checkAndFilterOutput(attrValues[i]));
            this.buffer.append("\"");
            ++i;
        }
        this.buffer.append(TAGEND);
        if (content != null) {
            this.buffer.append(XMLFilter.checkAndFilterOutput(content));
        }
        this.buffer.append(ENDTAGSTART);
        this.buffer.append(name);
        this.buffer.append(TAGEND);
    }

    public void startElem(String name) {
        this.startElemWithAttrs(name, new String[0], new String[0]);
    }

    public void startElemWithAttr(String name, String attrName, String attrValue) {
        this.startElemWithAttrs(name, new String[]{attrName}, new String[]{attrValue});
    }

    public void startElemWithAttrs(String name, String[] attrNames, String[] attrValues) {
        this.checkElemName(name);
        this.checkAttrNames(attrNames);
        this.checkAttrValues(attrValues);
        this.checkLength(attrNames, attrValues);
        this.buffer.append(TAGSTART);
        this.buffer.append(name);
        int i = 0;
        while (i < attrNames.length) {
            this.buffer.append(" ");
            this.buffer.append(attrNames[i]);
            this.buffer.append("=\"");
            this.buffer.append(XMLFilter.checkAndFilterOutput(attrValues[i]));
            this.buffer.append("\"");
            ++i;
        }
        this.buffer.append(TAGEND);
        this.startedElems.push(name);
    }

    public void endCurrentElem() {
        if (this.startedElems.empty()) {
            throw new RuntimeException("No more Element to end");
        }
        String currentElem = (String)this.startedElems.pop();
        this.buffer.append(ENDTAGSTART);
        this.buffer.append(currentElem);
        this.buffer.append(TAGEND);
    }

    public void endRootElem() {
        if (!this.startedElems.empty()) {
            throw new RuntimeException("Not all Elements ended");
        }
        this.buffer.append(ENDTAGSTART);
        this.buffer.append(this.rootElemName);
        this.buffer.append(TAGEND);
    }

    public String getString() {
        return this.buffer.toString();
    }

    private void checkElemName(String elemName) {
        if (elemName == null) {
            throw new NullPointerException("Element name null is not allowed");
        }
    }

    private void checkAttrName(String attrName) {
        if (attrName == null) {
            throw new NullPointerException("Attribute name null is not allowed");
        }
    }

    private void checkAttrValue(String attrValue) {
        if (attrValue == null) {
            throw new NullPointerException("Attribute value null is not allowed");
        }
    }

    private void checkAttrNames(String[] attrNames) {
        if (attrNames == null) {
            throw new NullPointerException("Attribute names array is null - not allowed!");
        }
        int i = 0;
        while (i < attrNames.length) {
            this.checkAttrName(attrNames[i]);
            ++i;
        }
    }

    private void checkAttrValues(String[] attrValues) {
        if (attrValues == null) {
            throw new NullPointerException("Attribute values array is null - not allowed!");
        }
        int i = 0;
        while (i < attrValues.length) {
            this.checkAttrValue(attrValues[i]);
            ++i;
        }
    }

    private void checkLength(String[] arr1, String[] arr2) {
        if (arr1.length != arr2.length) {
            throw new RuntimeException("Arrays have different length - not allowed!");
        }
    }
}

