/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.is.stringxml;

import com.sap.sdm.is.stringxml.StringPos;
import com.sap.sdm.util.xml.XMLFilter;

public final class StringFinder {
    public static StringPos findXMLElem(String name, String input) throws Exception {
        return StringFinder.findXMLElemInt(name, input, false);
    }

    public static StringPos findXMLElemOpen(String name, String input) throws Exception {
        return StringFinder.findXMLElemInt(name, input, true);
    }

    public static String findAttrForXMLElem(String elemName, String input, String attrName) throws Exception {
        StringFinder.checkNameInput(elemName, input);
        if (attrName == null) {
            throw new NullPointerException("Cannot find an Attribute with name null");
        }
        StringPos elemPos = StringFinder.findXMLElemInt(elemName, input, true);
        if (elemPos == null) {
            return null;
        }
        int elemEndIndex = input.indexOf(">", elemPos.beginPos);
        if (elemEndIndex == -1) {
            throw new Exception("No closing > found for " + elemName);
        }
        String attrString = input.substring(elemPos.beginPos, elemEndIndex);
        StringBuffer attrBuffer = new StringBuffer(attrName);
        attrBuffer.append("=\"");
        int attrBeginIndex = attrString.indexOf(attrBuffer.toString(), elemName.length());
        if (attrBeginIndex == -1) {
            return null;
        }
        int attrEndIndex = attrString.indexOf("\"", attrBeginIndex + 2 + attrName.length());
        if (attrBeginIndex + 2 + attrName.length() == -1) {
            throw new Exception("No closing \" found for attribute " + attrName);
        }
        String result = attrString.substring(attrBeginIndex + 2 + attrName.length(), attrEndIndex);
        return XMLFilter.checkAndFilterInput(result);
    }

    public static StringPos findOptXMLElem(String name, String input) throws Exception {
        StringFinder.checkNameInput(name, input);
        String startTag = StringFinder.createStartTag(name, false);
        String endTag = StringFinder.createEndTag(name);
        int beginIndex = input.indexOf(startTag);
        if (beginIndex == -1) {
            return null;
        }
        int endIndex = input.indexOf(endTag);
        if (endIndex == -1) {
            throw new Exception("No closing " + endTag + " found in XML data");
        }
        return new StringPos(beginIndex, endIndex);
    }

    public static String getNameOfNextXMLElement(String input) {
        String result = null;
        if (input == null) {
            return null;
        }
        int nextElemStart = input.indexOf("<");
        if (nextElemStart == -1) {
            return null;
        }
        int nextElemEnd = input.indexOf(">", nextElemStart + 1);
        if (nextElemEnd == -1) {
            return null;
        }
        String nextElemName = input.substring(nextElemStart + 1, nextElemEnd);
        if (nextElemName.indexOf(" ") != -1) {
            int resultIndex = nextElemName.indexOf(" ");
            result = nextElemName.substring(0, resultIndex);
        } else {
            result = nextElemName;
        }
        return result;
    }

    public static String getNameOfTopXMLElement(String input) {
        String result = null;
        if (input == null) {
            return null;
        }
        int indexHeaderStart = input.indexOf("<?");
        if (indexHeaderStart == -1) {
            return null;
        }
        int indexHeaderEnd = input.indexOf("?>", indexHeaderStart + 2);
        if (indexHeaderEnd == -1) {
            return null;
        }
        int topElemStart = input.indexOf("<", indexHeaderEnd + 2);
        if (topElemStart == -1) {
            return null;
        }
        int topElemEnd = input.indexOf(">", topElemStart + 1);
        if (topElemEnd == -1) {
            return null;
        }
        String topElemString = input.substring(topElemStart + 1, topElemEnd);
        if (topElemString.indexOf(" ") != -1) {
            int resultIndex = topElemString.indexOf(" ");
            result = topElemString.substring(0, resultIndex);
        } else {
            result = topElemString;
        }
        return result;
    }

    private static StringPos findXMLElemInt(String name, String input, boolean open) throws Exception {
        StringFinder.checkNameInput(name, input);
        String startTag = StringFinder.createStartTag(name, open);
        String endTag = StringFinder.createEndTag(name);
        int beginIndex = input.indexOf(startTag);
        if (beginIndex == -1) {
            throw new Exception("No opening " + startTag + " found in XML data");
        }
        int endIndex = input.indexOf(endTag);
        if (endIndex == -1) {
            throw new Exception("No closing " + endTag + " found in XML data");
        }
        return new StringPos(beginIndex, endIndex);
    }

    private static void checkNameInput(String name, String input) throws Exception {
        if (name == null) {
            throw new NullPointerException("Cannot find an Element with name null");
        }
        if (input == null) {
            throw new NullPointerException("Cannot find an Element within input null");
        }
    }

    private static String createStartTag(String name, boolean open) {
        StringBuffer startTag = new StringBuffer("<");
        startTag.append(name);
        if (!open) {
            startTag.append(">");
        }
        return startTag.toString();
    }

    private static String createEndTag(String name) {
        StringBuffer endTag = new StringBuffer("</");
        endTag.append(name);
        endTag.append(">");
        return endTag.toString();
    }
}

