/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.is.cs.session.common;

import com.sap.sdm.is.cs.cmd.CmdIF;
import com.sap.sdm.is.cs.cmd.CmdReconstructionException;
import com.sap.sdm.is.cs.session.common.CmdFactory;
import com.sap.sdm.is.cs.session.common.CmdSessionXMLizer;
import com.sap.sdm.is.stringxml.StringFinder;
import com.sap.sdm.is.stringxml.StringPos;
import com.sap.sdm.util.log.Logger;
import com.sap.sdm.util.xml.XMLFilter;

public class CmdSessionXMLizerString
extends CmdSessionXMLizer {
    private static final CmdSessionXMLizer INSTANCE = new CmdSessionXMLizerString();
    private static final Logger log = Logger.getLogger();

    private CmdSessionXMLizerString() {
    }

    public static CmdSessionXMLizer getInstance() {
        return INSTANCE;
    }

    public CmdIF fromXMLString(String input) throws CmdReconstructionException {
        String sessionID = null;
        try {
            StringPos sesPos = StringFinder.findXMLElem("SessionID", input);
            sessionID = XMLFilter.checkAndFilterInput(input.substring(sesPos.beginPos + 11, sesPos.endPos));
            StringPos cmdPos = StringFinder.findOptXMLElem("CloseConnection", input);
            if (cmdPos != null) {
                return CmdFactory.createCmdCloseConnection(sessionID);
            }
            cmdPos = StringFinder.findOptXMLElem("CloseSession", input);
            if (cmdPos != null) {
                return CmdFactory.createCmdCloseSession(sessionID);
            }
            cmdPos = StringFinder.findOptXMLElem("CloseSessionAcc", input);
            if (cmdPos != null) {
                return CmdFactory.createCmdCloseSessionAccepted(sessionID);
            }
            cmdPos = StringFinder.findOptXMLElem("ReopenConnection", input);
            if (cmdPos != null) {
                return CmdFactory.createCmdReopenConnection(sessionID);
            }
            cmdPos = StringFinder.findOptXMLElem("ReopenAccepted", input);
            if (cmdPos != null) {
                return CmdFactory.createCmdReopenConnectionAccepted(sessionID);
            }
        }
        catch (Exception exc) {
            String strErrMsg = "CmdSessionXMLizerString could not reconstruct the command";
            StringBuffer sbErrMsg = new StringBuffer();
            sbErrMsg.append(strErrMsg).append(". \nThe exception is: \"").append(exc.getMessage()).append("\".");
            log.error(sbErrMsg.toString(), exc);
            throw new CmdReconstructionException(strErrMsg);
        }
        String strErrMsg = "CmdSessionXMLizerString found unexpected element.\nThe command could not be reconstructed.";
        throw new CmdReconstructionException(strErrMsg);
    }
}

