/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.is.cs.session.common;

import com.sap.sdm.is.cs.cmd.CmdIF;
import com.sap.sdm.is.cs.cmd.CmdReconstructionException;
import com.sap.sdm.is.cs.session.common.CmdFactory;
import com.sap.sdm.is.cs.session.common.CmdLoginAcceptedXMLizer;
import com.sap.sdm.is.stringxml.StringFinder;
import com.sap.sdm.is.stringxml.StringPos;
import com.sap.sdm.util.log.Logger;
import com.sap.sdm.util.xml.XMLFilter;

public class CmdLoginAcceptedXMLizerString
extends CmdLoginAcceptedXMLizer {
    private static final CmdLoginAcceptedXMLizer INSTANCE = new CmdLoginAcceptedXMLizerString();
    private static final Logger log = Logger.getLogger();

    private CmdLoginAcceptedXMLizerString() {
    }

    public static CmdLoginAcceptedXMLizer getInstance() {
        return INSTANCE;
    }

    public CmdIF fromXMLString(String input) throws CmdReconstructionException {
        String sessionID = null;
        String apiServerVersion = null;
        try {
            StringPos apiPos;
            StringPos laPos = StringFinder.findXMLElem("LoginAccepted", input);
            StringPos sesPos = StringFinder.findOptXMLElem("SessionID", input);
            if (sesPos != null) {
                sessionID = XMLFilter.checkAndFilterInput(input.substring(sesPos.beginPos + 11, sesPos.endPos));
            }
            if ((apiPos = StringFinder.findOptXMLElem("APIVersion", input)) != null) {
                apiServerVersion = XMLFilter.checkAndFilterInput(input.substring(apiPos.beginPos + 12, apiPos.endPos));
            }
            return CmdFactory.createCmdLoginAccepted(sessionID, apiServerVersion);
        }
        catch (Exception exc) {
            String strErrMsg = "CmdLoginAcceptedXMLizer could not reconstruct the command";
            StringBuffer sbErrMsg = new StringBuffer();
            sbErrMsg.append(strErrMsg).append(". \nThe exception is: \"").append(exc.getMessage()).append("\".");
            log.error(sbErrMsg.toString(), exc);
            throw new CmdReconstructionException(strErrMsg);
        }
    }
}

