/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.is.cs.remoteproxy.common;

import com.sap.sdm.is.cs.remoteproxy.client.impl.ClientInvocationHandler;
import com.sap.sdm.is.cs.remoteproxy.common.ArrayElem;
import com.sap.sdm.is.cs.remoteproxy.common.CmdFactory;
import com.sap.sdm.is.cs.remoteproxy.common.InterfaceID;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Proxy;

public class RemoteCallArg {
    private String ifName = null;
    private String instanceID = null;
    private String value = null;
    private ArrayElem[] arrElemArr = null;
    private boolean isArray = false;
    private boolean isNull = false;

    public RemoteCallArg(String ifName, String instanceID, String value, ArrayElem[] arrElemArr, boolean isArray) {
        this.ifName = ifName;
        this.instanceID = instanceID;
        this.value = value;
        this.arrElemArr = arrElemArr;
        this.isArray = isArray;
    }

    public RemoteCallArg(Object arg) throws Exception {
        if (arg == null) {
            this.isNull = true;
            return;
        }
        Class<?> argClass = arg.getClass();
        if (!argClass.isArray()) {
            String argClassName = argClass.getName();
            if (argClassName.equals("java.lang.Boolean") || argClassName.equals("java.lang.Byte") || argClassName.equals("java.lang.Double") || argClassName.equals("java.lang.Float") || argClassName.equals("java.lang.Integer") || argClassName.equals("java.lang.Long") || argClassName.equals("java.lang.Short")) {
                this.ifName = argClassName;
                this.value = arg.toString();
            } else if (argClassName.equals("java.lang.String")) {
                this.ifName = argClassName;
                this.value = (String)arg;
            } else if (argClassName.equals("java.io.File")) {
                this.ifName = argClassName;
                this.value = ((File)arg).getName();
            } else {
                InterfaceID argID = this.getInterfaceIDForProxyArg(argClass, arg);
                this.ifName = argID.getClientClassName();
                this.instanceID = argID.getInstanceID();
            }
        } else {
            this.ifName = argClass.getName();
            this.isArray = true;
            int arrLength = Array.getLength(arg);
            this.arrElemArr = new ArrayElem[arrLength];
            String arrElemClassName = arg.getClass().getComponentType().getName();
            int i = 0;
            while (i < arrLength) {
                Object arrElem = Array.get(arg, i);
                if (arrElem == null) {
                    this.arrElemArr[i] = CmdFactory.createArrayElem(arrElemClassName, null, null, false);
                } else if (arrElemClassName.equals("java.lang.Boolean") || arrElemClassName.equals("java.lang.Byte") || arrElemClassName.equals("java.lang.Double") || arrElemClassName.equals("java.lang.Float") || arrElemClassName.equals("java.lang.Integer") || arrElemClassName.equals("java.lang.Long") || arrElemClassName.equals("java.lang.Short") || arrElemClassName.equals("java.lang.String")) {
                    this.arrElemArr[i] = CmdFactory.createArrayElem(arrElemClassName, null, Array.get(arg, i).toString(), false);
                } else if (arrElemClassName.equals("java.io.File")) {
                    File arrElemFile = (File)arrElem;
                    this.arrElemArr[i] = CmdFactory.createArrayElem(arrElemClassName, null, arrElemFile.getName(), false);
                } else {
                    InterfaceID argID = this.getInterfaceIDForProxyArg(Array.get(arg, i).getClass(), Array.get(arg, i));
                    if (argID == null) {
                        throw new Exception("ClientInterfaceID for \"" + Array.get(arg, i).getClass().getName() + "\" not found");
                    }
                    this.arrElemArr[i] = CmdFactory.createArrayElem(argID.getClientClassName(), argID.getInstanceID(), null, false);
                }
                ++i;
            }
        }
    }

    public String getInterfaceName() {
        return this.ifName;
    }

    public String getInstanceID() {
        return this.instanceID;
    }

    public String getValue() {
        return this.value;
    }

    public ArrayElem[] getArrElemArr() {
        return this.arrElemArr;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isNull() {
        return this.isNull;
    }

    public InterfaceID getInterfaceIDForProxyArg(Class proxyClass, Object arg) throws Exception {
        if (Proxy.isProxyClass(proxyClass)) {
            InterfaceID argID = ((ClientInvocationHandler)Proxy.getInvocationHandler(arg)).getClientInterfaceID();
            if (argID == null) {
                throw new Exception("ClientInterfaceID for \"" + proxyClass.getName() + "\" not found");
            }
            return argID;
        }
        throw new Exception("Error: argument is no primitive and no proxy");
    }
}

