/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.is.cs.remoteproxy.common;

import com.sap.sdm.is.cs.cmd.CmdIF;
import com.sap.sdm.is.cs.remoteproxy.common.ArrayElem;

public class CmdRemoteReturn
implements CmdIF {
    public static final String NAME = "RemoteReturn";
    private final String ifName;
    private final String instanceID;
    private final String value;
    private final ArrayElem[] arrElemArr;
    private final boolean isJavaImmutable;
    private final boolean hasCacheableNoArgMethods;
    private final boolean containsArr;

    public CmdRemoteReturn(String ifName, String instanceID, String value, ArrayElem[] arrElemArr, boolean hasCacheableNoArgMethods) {
        this.ifName = ifName;
        this.instanceID = instanceID;
        this.value = value;
        this.arrElemArr = arrElemArr;
        this.containsArr = this.arrElemArr != null;
        this.isJavaImmutable = this.ifName.equals("java.lang.Boolean") || this.ifName.equals("java.lang.Byte") || this.ifName.equals("java.lang.Double") || this.ifName.equals("java.lang.Float") || this.ifName.equals("java.lang.Integer") || this.ifName.equals("java.lang.Long") || this.ifName.equals("java.lang.Short") || this.ifName.equals("java.lang.String") || this.ifName.equals("boolean") || this.ifName.equals("byte") || this.ifName.equals("double") || this.ifName.equals("float") || this.ifName.equals("int") || this.ifName.equals("long") || this.ifName.equals("short") || this.ifName.equals("void") || this.instanceID == null;
        this.hasCacheableNoArgMethods = hasCacheableNoArgMethods;
    }

    public String getMyName() {
        return NAME;
    }

    public String getInterfaceName() {
        return this.ifName;
    }

    public String getInstanceID() {
        return this.instanceID;
    }

    public String getValue() {
        return this.value;
    }

    public ArrayElem[] getArrElementArray() {
        return this.arrElemArr;
    }

    public Object getValueAsObject() {
        if (this.ifName.equals("void")) {
            return null;
        }
        if (this.ifName.equals("java.lang.Boolean") || this.ifName.equals("boolean")) {
            return new Boolean(this.value);
        }
        if (this.ifName.equals("java.lang.Byte") || this.ifName.equals("byte")) {
            return new Byte(this.value);
        }
        if (this.ifName.equals("java.lang.Double") || this.ifName.equals("double")) {
            return new Double(this.value);
        }
        if (this.ifName.equals("java.lang.Float") || this.ifName.equals("float")) {
            return new Float(this.value);
        }
        if (this.ifName.equals("java.lang.Integer") || this.ifName.equals("int")) {
            return new Integer(this.value);
        }
        if (this.ifName.equals("java.lang.Long") || this.ifName.equals("long")) {
            return new Long(this.value);
        }
        if (this.ifName.equals("java.lang.Short") || this.ifName.equals("short")) {
            return new Short(this.value);
        }
        if (this.ifName.equals("java.lang.String")) {
            return this.value;
        }
        return null;
    }

    public boolean isJavaImmutable() {
        return this.isJavaImmutable;
    }

    public boolean hasCacheableNoArgMethods() {
        return this.hasCacheableNoArgMethods;
    }

    public boolean containsArray() {
        return this.containsArr;
    }
}

