/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.is.cs.remoteproxy.common;

import com.sap.sdm.is.cs.cmd.CmdIF;
import com.sap.sdm.is.cs.cmd.CmdReconstructionException;
import com.sap.sdm.is.cs.remoteproxy.common.CmdFactory;
import com.sap.sdm.is.cs.remoteproxy.common.CmdRemoteExceptionXMLizer;
import com.sap.sdm.is.stringxml.StringFinder;
import com.sap.sdm.is.stringxml.StringPos;
import com.sap.sdm.util.log.Logger;
import com.sap.sdm.util.xml.XMLFilter;

public class CmdRemoteExceptionXMLizerString
extends CmdRemoteExceptionXMLizer {
    private static final CmdRemoteExceptionXMLizer INSTANCE = new CmdRemoteExceptionXMLizerString();
    private static final Logger log = Logger.getLogger();

    private CmdRemoteExceptionXMLizerString() {
    }

    public static CmdRemoteExceptionXMLizer getInstance() {
        return INSTANCE;
    }

    public CmdIF fromXMLString(String input) throws CmdReconstructionException {
        String excName = null;
        String excMsg = null;
        try {
            StringPos excPos = StringFinder.findXMLElem("RemoteException", input);
            StringPos namePos = StringFinder.findXMLElem("Exc", input);
            excName = XMLFilter.checkAndFilterInput(input.substring(namePos.beginPos + 5, namePos.endPos));
            StringPos msgPos = StringFinder.findOptXMLElem("Msg", input);
            excMsg = msgPos == null ? null : XMLFilter.checkAndFilterInput(input.substring(msgPos.beginPos + 5, msgPos.endPos));
            return CmdFactory.createCmdRemoteException(excName, excMsg);
        }
        catch (Exception exc) {
            String strErrMsg = "CmdRemoteExceptionXMLizerString could not reconstruct the command";
            StringBuffer sbErrMsg = new StringBuffer();
            sbErrMsg.append(strErrMsg).append(". \nThe exception is: \"").append(exc.getMessage()).append("\".");
            log.error(sbErrMsg.toString(), exc);
            throw new CmdReconstructionException(strErrMsg);
        }
    }
}

