/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.is.cs.remoteproxy.common;

import com.sap.sdm.is.cs.cmd.CmdIF;
import com.sap.sdm.is.cs.cmd.CmdReconstructionException;
import com.sap.sdm.is.cs.cmd.CmdXMLizer;
import com.sap.sdm.is.cs.remoteproxy.common.CmdRemoteCall;
import com.sap.sdm.is.cs.remoteproxy.common.InterfaceID;
import com.sap.sdm.is.cs.remoteproxy.common.RemoteCallArg;
import com.sap.sdm.is.cs.remoteproxy.common.RemoteCallArgXMLizer;
import com.sap.sdm.is.stringxml.StringXMLizer;
import com.sap.sdm.is.stringxml.StringXMLizerFactory;

public abstract class CmdRemoteCallXMLizer
implements CmdXMLizer {
    protected static final String XML_SESSION_ID = "SessionID";
    protected static final String XML_DEL_LIST = "DelList";
    protected static final String XML_DEL_ITEM = "DelI";

    public String toXMLString(CmdIF cmd) {
        RemoteCallArg[] callArgs;
        CmdRemoteCall cmdRC = (CmdRemoteCall)cmd;
        StringXMLizerFactory factory = StringXMLizerFactory.getInstance();
        StringXMLizer sXML = factory.createStringXMLizer("RemoteCall");
        sXML.addElemWithContent(XML_SESSION_ID, cmdRC.getSessionID());
        InterfaceID[] delArr = cmdRC.getDelArr();
        if (delArr != null && delArr.length > 0) {
            sXML.startElem(XML_DEL_LIST);
            int i = 0;
            while (i < delArr.length) {
                sXML.startElem(XML_DEL_ITEM);
                sXML.addElemWithContent("If", delArr[i].getClientClassName());
                if (delArr[i].getInstanceID() != null) {
                    sXML.addElemWithContent("Id", delArr[i].getInstanceID());
                }
                sXML.endCurrentElem();
                ++i;
            }
            sXML.endCurrentElem();
        }
        sXML.addElemWithContent("If", cmdRC.getInterfaceName());
        sXML.startElem("Mtd");
        sXML.addElemWithContent("MName", cmdRC.getMethodName());
        sXML.startElem("Sig");
        String[] sigClassNames = cmdRC.getSignatureClassNames();
        if (sigClassNames != null) {
            int i = 0;
            while (i < sigClassNames.length) {
                sXML.addElemWithContent("If", sigClassNames[i]);
                ++i;
            }
        }
        sXML.endCurrentElem();
        sXML.endCurrentElem();
        if (cmdRC.getInstanceID() != null) {
            sXML.addElemWithContent("Id", cmdRC.getInstanceID());
        }
        if ((callArgs = cmdRC.getCallArgs()) != null && callArgs.length > 0) {
            sXML.startElem("Args");
            int i = 0;
            while (i < callArgs.length) {
                RemoteCallArgXMLizer.toXMLString(callArgs[i], sXML);
                ++i;
            }
            sXML.endCurrentElem();
        }
        sXML.endRootElem();
        return sXML.getString();
    }

    public abstract CmdIF fromXMLString(String var1) throws CmdReconstructionException;
}

