/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.is.cs.remoteproxy.common;

import com.sap.sdm.is.cs.cmd.CmdIF;
import com.sap.sdm.is.cs.remoteproxy.common.CmdFactory;
import com.sap.sdm.is.cs.remoteproxy.common.InterfaceID;
import com.sap.sdm.is.cs.remoteproxy.common.RemoteCallArg;
import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class CmdRemoteCall
implements CmdIF {
    public static final String NAME = "RemoteCall";
    private String ifName = null;
    private String methodName = null;
    private String instanceID = null;
    private String sessionID = null;
    private Object[] methodArgs = null;
    private RemoteCallArg[] rcArgs = null;
    private Class[] parameterTypeArr = null;
    private String[] sigClassNames = null;
    private List filesToBeTransferred = new ArrayList();
    private InterfaceID[] delArr = null;

    public CmdRemoteCall(String sessionID, String ifName, String methodName, String instanceID) {
        this(sessionID, ifName, methodName, instanceID, (RemoteCallArg[])null, (String[])null, (InterfaceID[])null);
    }

    public CmdRemoteCall(String sessionID, String ifName, String methodName, String instanceID, RemoteCallArg[] callArgs, String[] sigClassNames, InterfaceID[] delArr) {
        this.sessionID = sessionID;
        this.ifName = ifName;
        this.methodName = methodName;
        this.instanceID = instanceID;
        this.rcArgs = callArgs;
        this.sigClassNames = sigClassNames;
        this.delArr = delArr;
    }

    public CmdRemoteCall(String sessionID, String ifName, String methodName, String instanceID, Object[] args, String[] sigClassNames, InterfaceID[] delArr) throws Exception {
        this.sessionID = sessionID;
        this.ifName = ifName;
        this.methodName = methodName;
        this.instanceID = instanceID;
        this.methodArgs = args;
        this.sigClassNames = sigClassNames;
        this.delArr = delArr;
        if (args != null) {
            this.rcArgs = new RemoteCallArg[args.length];
            int i = 0;
            while (i < args.length) {
                this.rcArgs[i] = CmdFactory.createRemoteCallArg(args[i]);
                if (null != args[i]) {
                    Class<?> argClass = args[i].getClass();
                    if (!argClass.isArray()) {
                        String argClassName = argClass.getName();
                        if (argClassName.equals("java.io.File")) {
                            this.filesToBeTransferred.add((File)args[i]);
                        }
                    } else {
                        int arrLength = Array.getLength(args[i]);
                        String arrElemClassName = args[i].getClass().getComponentType().getName();
                        int j = 0;
                        while (j < arrLength) {
                            Object arrElem = Array.get(args[i], j);
                            if (arrElemClassName.equals("java.io.File")) {
                                File arrElemFile = (File)arrElem;
                                if (!arrElemFile.exists()) {
                                    throw new Exception("Given argument (java.io.File) within array \"" + arrElemFile.getAbsolutePath() + "\" does not exist");
                                }
                                if (arrElemFile.isDirectory()) {
                                    throw new Exception("Given argument (java.io.File) within array \"" + arrElemFile.getAbsolutePath() + "\" is a directory");
                                }
                                this.filesToBeTransferred.add(arrElemFile);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
    }

    public String getMyName() {
        return NAME;
    }

    public String getInterfaceName() {
        return this.ifName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getInstanceID() {
        return this.instanceID;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public Object[] getMethodArgs() {
        return this.methodArgs;
    }

    public RemoteCallArg[] getCallArgs() {
        return this.rcArgs;
    }

    public File[] getFileArrForTransfer() {
        File[] result = new File[this.filesToBeTransferred.size()];
        this.filesToBeTransferred.toArray(result);
        return result;
    }

    public String[] getSignatureClassNames() {
        return this.sigClassNames;
    }

    public InterfaceID[] getDelArr() {
        return this.delArr;
    }
}

