/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.is.cs.remoteproxy.client.impl;

import com.sap.sdm.is.cache.Cache;
import com.sap.sdm.is.cache.CacheFactory;
import com.sap.sdm.is.cs.cmd.CmdError;
import com.sap.sdm.is.cs.cmd.CmdIF;
import com.sap.sdm.is.cs.cmd.client.CmdClient;
import com.sap.sdm.is.cs.remoteproxy.client.CmdClientGetter;
import com.sap.sdm.is.cs.remoteproxy.client.ExceptionFactory;
import com.sap.sdm.is.cs.remoteproxy.client.ProxyLockHandler;
import com.sap.sdm.is.cs.remoteproxy.client.RemoteProxyClient;
import com.sap.sdm.is.cs.remoteproxy.client.impl.ClientInvocationHandler;
import com.sap.sdm.is.cs.remoteproxy.common.CmdFactory;
import com.sap.sdm.is.cs.remoteproxy.common.CmdRemoteCall;
import com.sap.sdm.is.cs.remoteproxy.common.CmdRemoteException;
import com.sap.sdm.is.cs.remoteproxy.common.CmdRemoteReturn;
import com.sap.sdm.is.cs.remoteproxy.common.InterfaceID;
import com.sap.sdm.is.cs.remoteproxy.common.InterfaceIDFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Vector;

final class RemoteProxyClientImpl
implements RemoteProxyClient {
    private final Cache proxyCache;
    private final List clientInstanceDeletionList = new Vector();
    private final ClassLoader classLoader;
    private final CmdClientGetter cmdClientGetter;
    private final ExceptionFactory exceptionFactory;
    private final String id;
    private final ProxyLockHandler proxyLockHandler;

    RemoteProxyClientImpl(String id, ClassLoader classLoader, CmdClientGetter clientGetter, ProxyLockHandler proxyLockHandler, ExceptionFactory excFactory, int cacheSize) {
        this.id = id;
        this.classLoader = classLoader;
        this.cmdClientGetter = clientGetter;
        this.proxyLockHandler = proxyLockHandler;
        this.exceptionFactory = excFactory;
        this.proxyCache = CacheFactory.getInstance().newLruCache(cacheSize);
    }

    public Object createInitialProxy(String interfaceName, String methodName) throws Exception {
        CmdRemoteCall cmdRC = CmdFactory.createCmdRemoteCall(this.id, interfaceName, methodName, null);
        CmdIF answerCmd = this.cmdClientGetter.get().processCommand(cmdRC);
        if (answerCmd instanceof CmdError) {
            Exception e = this.exceptionFactory.create("Error received from server: " + ((CmdError)answerCmd).getErrorText());
            throw e;
        }
        if (answerCmd instanceof CmdRemoteException) {
            Exception e = this.exceptionFactory.create(((CmdRemoteException)answerCmd).getExceptionMsg());
            throw e;
        }
        if (answerCmd instanceof CmdRemoteReturn) {
            CmdRemoteReturn initReturn = (CmdRemoteReturn)answerCmd;
            InterfaceID clIFID = InterfaceIDFactory.getInstance().createInterfaceID(interfaceName, initReturn.getInstanceID());
            return this.buildNewProxy(interfaceName, clIFID, initReturn.hasCacheableNoArgMethods());
        }
        Exception e = this.exceptionFactory.create("Received unexpected server answer: " + answerCmd.getMyName());
        throw e;
    }

    Object searchInstanceByID(InterfaceID ciID) {
        return this.proxyCache.get(ciID);
    }

    void registerIDForDeletion(InterfaceID ciID) {
        List list = this.clientInstanceDeletionList;
        synchronized (list) {
            if (ciID != null) {
                this.clientInstanceDeletionList.add(ciID);
            }
        }
    }

    InterfaceID[] getIDDeletionArr() {
        InterfaceID[] resultArr = null;
        List list = this.clientInstanceDeletionList;
        synchronized (list) {
            resultArr = new InterfaceID[this.clientInstanceDeletionList.size()];
            this.clientInstanceDeletionList.toArray(resultArr);
            this.clientInstanceDeletionList.clear();
        }
        return resultArr;
    }

    String getID() {
        return this.id;
    }

    Object buildNewProxy(String interfaceName, InterfaceID newID, boolean hasCacheableNoArgMethods) {
        Object newProxy = null;
        try {
            ClientInvocationHandler handler = new ClientInvocationHandler(newID, this, hasCacheableNoArgMethods);
            newProxy = Proxy.newProxyInstance(this.classLoader, new Class[]{Class.forName(interfaceName)}, (InvocationHandler)handler);
            handler.setProxyInstance(newProxy);
        }
        catch (ClassNotFoundException newProxyExc) {
            throw new RuntimeException("Runtime Exception: " + newProxyExc.getMessage());
        }
        this.proxyCache.put(newID, newProxy);
        return newProxy;
    }

    CmdClient getCmdClient() throws CmdClientGetter.Exception {
        return this.cmdClientGetter.get();
    }

    ProxyLockHandler getProxyLockHandler() {
        return this.proxyLockHandler;
    }

    ExceptionFactory getExceptionFactory() {
        return this.exceptionFactory;
    }
}

